/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.ARQConstants;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileBase;
import org.apache.jena.riot.system.ParserProfileChecker;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

public class RiotLib {
    static final String bNodeLabelStart = "_:";
    static final boolean skolomizedBNodes = ARQ.isTrue(ARQ.constantBNodeLabels);
    static ParserProfile profile = RiotLib.profile(RDFLanguages.TURTLE, null, null);

    public static Node createIRIorBNode(String iri2) {
        if (RiotLib.isBNodeIRI(iri2)) {
            String s = iri2.substring(bNodeLabelStart.length());
            Node n = Node.createAnon((AnonId)new AnonId(s));
            return n;
        }
        return Node.createURI((String)iri2);
    }

    public static boolean isBNodeIRI(String iri2) {
        return skolomizedBNodes && iri2.startsWith(bNodeLabelStart);
    }

    public static Node parse(String string) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        if (!tokenizer.hasNext()) {
            return null;
        }
        Token t = tokenizer.next();
        Node n = profile.create(null, t);
        if (tokenizer.hasNext()) {
            Log.warn(RiotLib.class, "String has more than one token in it: " + string);
        }
        return n;
    }

    public static ParserProfile profile(Lang lang, String baseIRI) {
        return RiotLib.profile(lang, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler());
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotLib.profile(baseIRI, false, false, handler);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotLib.profile(baseIRI, false, true, handler);
        }
        return RiotLib.profile(baseIRI, true, true, handler);
    }

    public static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        Prologue prologue = resolveIRIs ? new Prologue(PrefixMapFactory.createForInput(), IRIResolver.create(baseIRI)) : new Prologue(PrefixMapFactory.createForInput(), IRIResolver.createNoResolve());
        if (checking) {
            return new ParserProfileChecker(prologue, handler);
        }
        return new ParserProfileBase(prologue, handler);
    }

    static {
        PrefixMap pmap = profile.getPrologue().getPrefixMap();
        pmap.add("rdf", ARQConstants.rdfPrefix);
        pmap.add("rdfs", ARQConstants.rdfsPrefix);
        pmap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        pmap.add("owl", ARQConstants.owlPrefix);
        pmap.add("fn", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("op", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("ex", "http://example/ns#");
        pmap.add("", "http://example/");
    }
}

