/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.clarkparsia.sparqlowl.parser.arq.ARQTerpParser;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.output.TableData;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletQuery
extends PelletCmdApp {
    private String queryFile;
    private String queryString;
    private Query query;
    private JenaLoader loader;
    private ResultSet queryResults;
    private Model constructQueryModel;
    private boolean askQueryResult;
    private Syntax queryFormat = Syntax.syntaxSPARQL;
    private OutputFormat outputFormat = OutputFormat.TABULAR;
    private SparqlDLExecutionFactory.QueryEngineType queryEngine = null;

    @Override
    public String getAppId() {
        return "PelletQuery: SPARQL-DL Query Engine";
    }

    @Override
    public String getAppCmd() {
        return "pellet query " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("query-file");
        pelletCmdOption.setShortOption("q");
        pelletCmdOption.setType("<file URI>");
        pelletCmdOption.setDescription("Read the SPARQL query from the given file");
        pelletCmdOption.setIsMandatory(true);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("output-format");
        pelletCmdOption.setShortOption("o");
        pelletCmdOption.setType("Tabular | XML | JSON");
        pelletCmdOption.setDescription("Format of result set (SELECT queries)");
        pelletCmdOption.setDefaultValue("Tabular");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("query-format");
        pelletCmdOption.setType("SPARQL | ARQ | TERP");
        pelletCmdOption.setDescription("The query format");
        pelletCmdOption.setDefaultValue("SPARQL");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        pelletCmdOptions.add(this.getInputFormatOption());
        pelletCmdOption = new PelletCmdOption("query-engine");
        pelletCmdOption.setType("Pellet | ARQ | Mixed");
        pelletCmdOption.setShortOption("e");
        pelletCmdOption.setDescription("The query engine that will be used. Default behavior is to auto select the engine that can handle the given query with best performance. Pellet query engine is the typically fastest but cannot handle FILTER, OPTIONAL, UNION, DESCRIBE or named graphs. Mixed engine uses ARQ to handle SPARQL algebra and uses Pellet to answer Basic Graph Patterns (BGP) which can be expressed in SPARQL-DL. ARQ engine uses Pellet to answer single triple patterns and can handle queries that do not fit into SPARQL-DL. As a consequence SPARQL-DL extensions and complex class expressions encoded inside the SPARQL query are not supported.");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("bnode");
        pelletCmdOption.setDescription("Treat bnodes in the query as undistinguished variables. Undistinguished variables can match individuals whose existence is inferred by the reasoner, e.g. due to a someValuesFrom restriction. This option has no effect if ARQ engine is selected.");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        return pelletCmdOptions;
    }

    @Override
    public void parseArgs(String[] stringArray) {
        super.parseArgs(stringArray);
        this.setQueryFile(this.options.getOption("query-file").getValueAsString());
        this.setOutputFormat(this.options.getOption("output-format").getValueAsString());
        this.setQueryFormat(this.options.getOption("query-format").getValueAsString());
        this.setQueryEngine(this.options.getOption("query-engine").getValueAsString());
        PelletOptions.TREAT_ALL_VARS_DISTINGUISHED = !this.options.getOption("bnode").getValueAsBoolean();
    }

    @Override
    public void run() {
        this.loadQuery();
        this.loadInput();
        this.execQuery();
        this.printQueryResults();
    }

    public void setQueryFile(String string) {
        this.queryFile = string;
    }

    public void setOutputFormat(String string) {
        if (string == null) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (string.equalsIgnoreCase("Tabular")) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (string.equalsIgnoreCase("XML")) {
            this.outputFormat = OutputFormat.XML;
        } else if (string.equalsIgnoreCase("JSON")) {
            this.outputFormat = OutputFormat.JSON;
        } else {
            throw new PelletCmdException("Invalid output format: " + (Object)((Object)this.outputFormat));
        }
    }

    public ResultSet getQueryResults() {
        return this.queryResults;
    }

    public Model getConstructQueryModel() {
        return this.constructQueryModel;
    }

    public boolean getAskQueryResult() {
        return this.askQueryResult;
    }

    public void setQueryFormat(String string) {
        if (string == null) {
            throw new PelletCmdException("Query format is null");
        }
        if (string.equalsIgnoreCase("SPARQL")) {
            this.queryFormat = Syntax.lookup((String)"SPARQL");
        } else if (string.equalsIgnoreCase("ARQ")) {
            this.queryFormat = Syntax.lookup((String)"ARQ");
        } else if (string.equalsIgnoreCase("TERP")) {
            this.queryFormat = Syntax.lookup((String)"TERP");
        } else {
            throw new PelletCmdException("Unknown query format: " + string);
        }
        if (this.queryFormat == null) {
            throw new PelletCmdException("Query format is null: " + string);
        }
    }

    public void setQueryEngine(String string) {
        if (string == null) {
            this.queryEngine = null;
            return;
        }
        try {
            this.queryEngine = SparqlDLExecutionFactory.QueryEngineType.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PelletCmdException("Unknown query engine: " + string);
        }
    }

    private void loadInput() {
        try {
            this.loader = (JenaLoader)this.getLoader("Jena");
            KnowledgeBase knowledgeBase = this.getKB(this.loader);
            this.startTask("consistency check");
            boolean bl = knowledgeBase.isConsistent();
            this.finishTask("consistency check");
            if (!bl) {
                throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
            }
        }
        catch (NotFoundException notFoundException) {
            throw new PelletCmdException(notFoundException);
        }
        catch (QueryParseException queryParseException) {
            throw new PelletCmdException(queryParseException);
        }
        catch (InconsistentOntologyException inconsistentOntologyException) {
            throw new PelletCmdException("Cannot query inconsistent ontology!");
        }
    }

    private void loadQuery() {
        try {
            this.verbose("Query file: " + this.queryFile);
            this.startTask("parsing query file");
            this.queryString = FileManager.get().readWholeFileAsUTF8(this.queryFile);
            this.query = QueryFactory.create((String)this.queryString, (Syntax)this.queryFormat);
            this.finishTask("parsing query file");
            this.verbose("Query: ");
            this.verbose("-----------------------------------------------------");
            this.verbose(this.queryString.trim());
            this.verbose("-----------------------------------------------------");
        }
        catch (NotFoundException notFoundException) {
            throw new PelletCmdException(notFoundException);
        }
        catch (QueryParseException queryParseException) {
            throw new PelletCmdException(queryParseException);
        }
    }

    private void execQuery() {
        Dataset dataset = DatasetFactory.create((Model)this.loader.getModel());
        QueryExecution queryExecution = this.queryEngine == null ? SparqlDLExecutionFactory.create(this.query, dataset) : SparqlDLExecutionFactory.create(this.query, dataset, null, this.queryEngine);
        this.verbose("Created query engine: " + queryExecution.getClass().getName());
        this.startTask("query execution");
        if (this.query.isSelectType()) {
            this.queryResults = ResultSetFactory.makeRewindable((ResultSet)queryExecution.execSelect());
        } else if (this.query.isConstructType()) {
            this.constructQueryModel = queryExecution.execConstruct();
        } else if (this.query.isAskType()) {
            this.askQueryResult = queryExecution.execAsk();
        } else {
            throw new UnsupportedOperationException("Unsupported query type");
        }
        this.finishTask("query execution");
    }

    private void printQueryResults() {
        if (this.query.isSelectType()) {
            this.printSelectQueryResuts();
        } else if (this.query.isConstructType()) {
            this.printConstructQueryResults();
        } else if (this.query.isAskType()) {
            this.printAskQueryResult();
        }
    }

    private void printSelectQueryResuts() {
        if (this.queryResults.hasNext()) {
            if (this.outputFormat == OutputFormat.TABULAR) {
                this.printTabularQueryResults();
            } else if (this.outputFormat == OutputFormat.XML) {
                this.printXMLQueryResults();
            } else if (this.outputFormat == OutputFormat.JSON) {
                this.printJSONQueryResults();
            } else {
                this.printTabularQueryResults();
            }
        } else {
            this.output("Query Results (0 answers): ");
            this.output("NO RESULTS");
        }
    }

    private void printTabularQueryResults() {
        Object object;
        Object object2;
        int n = 0;
        NodeFormatter nodeFormatter = new NodeFormatter((Model)this.loader.getModel());
        List list = this.query.getResultVars();
        ArrayList arrayList = new ArrayList();
        while (this.queryResults.hasNext()) {
            object2 = this.queryResults.nextSolution();
            object = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                RDFNode rDFNode = object2.get(string);
                object.add(nodeFormatter.format(rDFNode));
            }
            if (!arrayList.add(object)) continue;
            ++n;
        }
        this.output("Query Results (" + n + " answers): ");
        object2 = new TableData(arrayList, list);
        object = new StringWriter();
        ((TableData)object2).print((Writer)object);
        this.output(((StringWriter)object).toString());
    }

    private void printXMLQueryResults() {
        ResultSetFormatter.outputAsXML((ResultSet)this.queryResults);
    }

    private void printJSONQueryResults() {
        if (this.verbose) {
            System.out.println("/* ");
            System.out.println(this.queryString.replace("*/", "* /"));
            System.out.println("*/ ");
        }
        ResultSetFormatter.outputAsJSON((ResultSet)this.queryResults);
    }

    private void printConstructQueryResults() {
        StringWriter stringWriter = new StringWriter();
        this.constructQueryModel.write((Writer)stringWriter);
        this.output(stringWriter.toString());
    }

    private void printAskQueryResult() {
        this.output("ASK query result: ");
        this.output(this.askQueryResult ? "yes" : "no");
    }

    static {
        ARQTerpParser.registerFactory();
    }

    private static enum OutputFormat {
        TABULAR,
        XML,
        JSON;

    }
}

