/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.DisjunctionBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjunctionRule
extends AbstractTableauRule {
    public DisjunctionRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.DISJUNCTION, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(1)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(1);
        int n = list.size();
        ATermAppl[] aTermApplArray = new ATermAppl[n - individual.applyNext[1]];
        list.subList(individual.applyNext[1], n).toArray(aTermApplArray);
        if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
            DisjunctionRule.sortDisjunctions(individual, aTermApplArray);
        }
        for (ATermAppl aTermAppl : aTermApplArray) {
            this.applyDisjunctionRule(individual, aTermAppl);
            if (!this.strategy.getABox().isClosed() && !individual.isMerged()) continue;
            return;
        }
        individual.applyNext[1] = n;
    }

    private static void sortDisjunctions(final Individual individual, ATermAppl[] aTermApplArray) {
        if (PelletOptions.USE_DISJUNCTION_SORTING != "OLDEST_FIRST") {
            throw new InternalReasonerException("Unknown disjunction sorting option " + PelletOptions.USE_DISJUNCTION_SORTING);
        }
        Comparator<ATermAppl> comparator = new Comparator<ATermAppl>(){

            @Override
            public int compare(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
                return individual.getDepends((ATerm)aTermAppl).max() - individual.getDepends((ATerm)aTermAppl2).max();
            }
        };
        Arrays.sort(aTermApplArray, comparator);
    }

    protected void applyDisjunctionRule(Individual individual, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
        ATermAppl[] aTermApplArray = new ATermAppl[aTermList.getLength()];
        int n = 0;
        while (!aTermList.isEmpty()) {
            aTermApplArray[n] = ATermUtils.negate((ATermAppl)aTermList.getFirst());
            if (individual.hasType((ATerm)aTermApplArray[n])) {
                return;
            }
            aTermList = aTermList.getNext();
            ++n;
        }
        DisjunctionBranch disjunctionBranch = new DisjunctionBranch(this.strategy.getABox(), this.strategy, individual, aTermAppl, individual.getDepends((ATerm)aTermAppl), aTermApplArray);
        this.strategy.addBranch(disjunctionBranch);
        disjunctionBranch.tryNext();
    }
}

