/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;

public abstract class Node {
    public static final Logger log = Logger.getLogger(Node.class.getName());
    public static final int BLOCKABLE = Integer.MAX_VALUE;
    public static final int NOMINAL = 0;
    public static final int CHANGED = 127;
    public static final int UNCHANGED = 0;
    public static final int ATOM = 0;
    public static final int OR = 1;
    public static final int SOME = 2;
    public static final int ALL = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int NOM = 6;
    public static final int TYPES = 7;
    protected ABox abox;
    protected ATermAppl name;
    protected Map<ATermAppl, DependencySet> depends;
    private boolean isRoot;
    private boolean isConceptRoot;
    protected Node mergedTo = this;
    protected EdgeList inEdges;
    protected DependencySet mergeDepends = null;
    protected DependencySet pruned = null;
    protected Set<Node> merged;
    protected Map<Node, DependencySet> differents;

    protected Node(ATermAppl aTermAppl, ABox aBox) {
        this.name = aTermAppl;
        this.abox = aBox;
        this.isRoot = !ATermUtils.isAnon(aTermAppl);
        this.isConceptRoot = false;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.differents = CollectionUtils.makeMap();
        this.depends = CollectionUtils.makeMap();
        this.inEdges = new EdgeList();
    }

    protected Node(Node node, ABox aBox) {
        this.name = node.getName();
        this.abox = aBox;
        this.isRoot = node.isRoot;
        this.isConceptRoot = node.isConceptRoot;
        this.mergeDepends = node.mergeDepends;
        this.mergedTo = node.mergedTo;
        this.merged = node.merged;
        this.pruned = node.pruned;
        this.differents = node.differents;
        this.depends = CollectionUtils.makeMap(node.depends);
        this.inEdges = node.inEdges;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateNodeReferences() {
        void var3_7;
        HashSet<Node> hashSet;
        this.mergedTo = this.abox.getNode((ATerm)this.mergedTo.getName());
        HashMap<Node, DependencySet> hashMap = new HashMap<Node, DependencySet>(this.differents.size());
        for (Map.Entry<Node, DependencySet> object2 : this.differents.entrySet()) {
            Node node = object2.getKey();
            hashMap.put(this.abox.getNode((ATerm)node.getName()), object2.getValue());
        }
        this.differents = hashMap;
        if (this.merged != null) {
            hashSet = new HashSet<Node>(this.merged.size());
            for (Node node : this.merged) {
                hashSet.add(this.abox.getNode((ATerm)node.getName()));
            }
            this.merged = hashSet;
        }
        hashSet = this.inEdges;
        this.inEdges = new EdgeList(((EdgeList)((Object)hashSet)).size());
        boolean bl = false;
        while (var3_7 < ((EdgeList)((Object)hashSet)).size()) {
            Edge edge = ((EdgeList)((Object)hashSet)).edgeAt((int)var3_7);
            Individual individual = this.abox.getIndividual((ATerm)edge.getFrom().getName());
            DefaultEdge defaultEdge = new DefaultEdge(edge.getRole(), individual, this, edge.getDepends());
            this.inEdges.addEdge(defaultEdge);
            if (!this.isPruned()) {
                individual.getOutEdges().addEdge(defaultEdge);
            }
            ++var3_7;
        }
    }

    public void setChanged(int n) {
        QueueElement queueElement = new QueueElement(this);
        if ((n == 3 || n == 4) && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.DATATYPE);
        }
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
    }

    public boolean isConceptRoot() {
        return this.isConceptRoot;
    }

    public void setConceptRoot(boolean bl) {
        this.isConceptRoot = bl;
    }

    public boolean isBnode() {
        return ATermUtils.isBnode(this.name);
    }

    public boolean isNamedIndividual() {
        return this.isRoot && !this.isConceptRoot && !this.isBnode();
    }

    public boolean isRoot() {
        return this.isRoot || this.isNominal();
    }

    public abstract boolean isLeaf();

    public boolean isRootNominal() {
        return this.isRoot && this.isNominal();
    }

    public abstract Node copyTo(ABox var1);

    protected void addInEdge(Edge edge) {
        this.inEdges.addEdge(edge);
    }

    public EdgeList getInEdges() {
        return this.inEdges;
    }

    public boolean removeInEdge(Edge edge) {
        boolean bl = this.inEdges.removeEdge(edge);
        if (!bl) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public void removeInEdges() {
        this.inEdges = new EdgeList();
    }

    public void reset(boolean bl) {
        assert (bl || this.isRootNominal()) : "Only asserted individuals can be reset: " + this;
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(new QueueElement(this));
        }
        if (bl) {
            return;
        }
        if (this.pruned != null) {
            this.unprune(DependencySet.NO_BRANCH);
        }
        this.mergedTo = this;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.merged = null;
        Iterator<DependencySet> iterator = this.differents.values().iterator();
        while (iterator.hasNext()) {
            DependencySet dependencySet = iterator.next();
            if (dependencySet.getBranch() == DependencySet.NO_BRANCH) continue;
            iterator.remove();
        }
        this.resetTypes();
        this.inEdges.reset();
    }

    protected void resetTypes() {
        Iterator<DependencySet> iterator = this.depends.values().iterator();
        while (iterator.hasNext()) {
            DependencySet dependencySet = iterator.next();
            if (dependencySet.getBranch() == DependencySet.NO_BRANCH) continue;
            iterator.remove();
        }
    }

    public Boolean restorePruned(int n) {
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.name);
        }
        if (this.pruned != null) {
            if (this.pruned.getBranch() > n) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RESTORE: " + this + " merged node " + this.mergedTo + " " + this.mergeDepends);
                }
                if (this.mergeDepends.getBranch() > n) {
                    this.undoSetSame();
                }
                this.unprune(n);
                if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                    this.abox.getIncrementalChangeTracker().addUnprunedNode(this);
                }
                if (this instanceof Individual) {
                    Individual individual = (Individual)this;
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        individual.applyNext[6] = 0;
                        this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.NOMINAL);
                    }
                }
                return Boolean.TRUE;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DO NOT RESTORE: pruned node " + this + " = " + this.mergedTo + " " + this.mergeDepends);
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean restore(int n) {
        Object object;
        Object object22;
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.name);
        }
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl2 = false;
        Object object3 = this.getTypes().iterator();
        while (object3.hasNext()) {
            boolean bl3;
            object22 = object3.next();
            object = this.getDepends((ATerm)object22);
            boolean bl4 = PelletOptions.USE_SMART_RESTORE ? ((DependencySet)object).max() >= n : (bl3 = ((DependencySet)object).getBranch() > n);
            if (bl3) {
                bl2 = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RESTORE: " + this + " remove type " + object22 + " " + object + " " + n);
                }
                if (PelletOptions.USE_INCREMENTAL_CONSISTENCY && this instanceof Individual) {
                    this.abox.getIncrementalChangeTracker().addDeletedType(this, (ATermAppl)object22);
                }
                object3.remove();
                this.removeType((ATermAppl)object22);
                bl = true;
                continue;
            }
            if (!PelletOptions.USE_SMART_RESTORE || !ATermUtils.isAnd((ATermAppl)object22)) continue;
            arrayList.add(object22);
        }
        if (bl2 && PelletOptions.USE_COMPLETION_QUEUE && this instanceof Individual) {
            object3 = (Individual)this;
            ((Individual)object3).applyNext[0] = 0;
            ((Individual)object3).applyNext[1] = 0;
            object22 = new QueueElement(this);
            this.abox.getCompletionQueue().add((QueueElement)object22, NodeSelector.DISJUNCTION);
            this.abox.getCompletionQueue().add((QueueElement)object22, NodeSelector.ATOM);
        }
        if (PelletOptions.USE_SMART_RESTORE) {
            for (Object object22 : arrayList) {
                object = this.getDepends((ATerm)object22);
                ATermList aTermList = (ATermList)object22.getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
                    this.addType(aTermAppl, (DependencySet)object);
                    aTermList = aTermList.getNext();
                }
            }
        }
        object3 = this.differents.entrySet().iterator();
        while (object3.hasNext()) {
            object22 = (Map.Entry)object3.next();
            object = (Node)object22.getKey();
            DependencySet dependencySet = (DependencySet)object22.getValue();
            if (dependencySet.getBranch() <= n) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " delete difference " + object);
            }
            object3.remove();
            bl = true;
        }
        bl2 = false;
        object3 = this.inEdges.iterator();
        while (object3.hasNext()) {
            object22 = object3.next();
            object = object22.getDepends();
            if (((DependencySet)object).getBranch() <= n) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " delete reverse edge " + object22);
            }
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.getIncrementalChangeTracker().addDeletedEdge((Edge)object22);
            }
            object3.remove();
            bl = true;
            bl2 = true;
        }
        if (bl2 && PelletOptions.USE_COMPLETION_QUEUE) {
            object3 = new QueueElement(this);
            this.abox.getCompletionQueue().add((QueueElement)object3, NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add((QueueElement)object3, NodeSelector.MIN_NUMBER);
        }
        return bl;
    }

    public void addType(ATermAppl aTermAppl, DependencySet dependencySet) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + aTermAppl);
        }
        if (this.isMerged()) {
            return;
        }
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        int n = this.abox.getBranch();
        int n2 = dependencySet.max();
        if (n == -1 && n2 != 0) {
            n = n2 + 1;
        }
        dependencySet = dependencySet.copy(n);
        this.depends.put(aTermAppl, dependencySet);
        this.abox.setChanged(true);
    }

    public boolean removeType(ATermAppl aTermAppl) {
        return this.depends.remove(aTermAppl) != null;
    }

    public boolean hasType(ATerm aTerm) {
        return this.depends.containsKey(aTerm);
    }

    public Bool hasObviousType(ATermAppl aTermAppl) {
        DependencySet dependencySet = this.getDepends((ATerm)aTermAppl);
        if (dependencySet != null) {
            if (dependencySet.isIndependent()) {
                return Bool.TRUE;
            }
        } else {
            dependencySet = this.getDepends((ATerm)ATermUtils.negate(aTermAppl));
            if (dependencySet != null) {
                if (dependencySet.isIndependent()) {
                    return Bool.FALSE;
                }
            } else if (this.isIndividual() && ATermUtils.isNominal(aTermAppl)) {
                if (!aTermAppl.getArgument(0).equals((Object)this.getName())) {
                    return Bool.FALSE;
                }
                return Bool.TRUE;
            }
        }
        if (this.isIndividual()) {
            Object object;
            ATermAppl aTermAppl2 = null;
            ATermAppl aTermAppl3 = null;
            if (ATermUtils.isNot(aTermAppl)) {
                object = (ATermAppl)aTermAppl.getArgument(0);
                if (ATermUtils.isAllValues((ATermAppl)object)) {
                    aTermAppl2 = (ATermAppl)object.getArgument(0);
                    aTermAppl3 = ATermUtils.negate((ATermAppl)object.getArgument(1));
                }
            } else if (ATermUtils.isSomeValues(aTermAppl)) {
                aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
            }
            if (aTermAppl2 != null) {
                object = (Individual)this;
                Role role = this.abox.getRole((ATerm)aTermAppl2);
                if (!role.isObjectRole() || !role.isSimple()) {
                    return Bool.UNKNOWN;
                }
                EdgeList edgeList = ((Individual)object).getRNeighborEdges(role);
                Bool bool = Bool.FALSE;
                for (int i = 0; i < edgeList.size(); ++i) {
                    Edge edge = edgeList.edgeAt(i);
                    if (!edge.getDepends().isIndependent()) {
                        bool = Bool.UNKNOWN;
                        continue;
                    }
                    Individual individual = (Individual)edge.getNeighbor((Node)object);
                    if (!(bool = bool.or(this.abox.isKnownType(individual, aTermAppl3, SetUtils.emptySet()))).isTrue()) continue;
                    return bool;
                }
                return bool;
            }
        }
        return Bool.UNKNOWN;
    }

    public boolean hasObviousType(Collection<ATermAppl> collection) {
        for (ATermAppl aTermAppl : collection) {
            DependencySet dependencySet = this.getDepends((ATerm)aTermAppl);
            if (dependencySet == null || !dependencySet.isIndependent()) continue;
            return true;
        }
        return false;
    }

    boolean hasPredecessor(Individual individual) {
        return individual.hasSuccessor(this);
    }

    public abstract boolean hasSuccessor(Node var1);

    public abstract DependencySet getNodeDepends();

    public DependencySet getDepends(ATerm aTerm) {
        return this.depends.get(aTerm);
    }

    public Map<ATermAppl, DependencySet> getDepends() {
        return this.depends;
    }

    public Set<ATermAppl> getTypes() {
        return this.depends.keySet();
    }

    public void removeTypes() {
        this.depends.clear();
    }

    public int prunedAt() {
        return this.pruned.getBranch();
    }

    public boolean isPruned() {
        return this.pruned != null;
    }

    public DependencySet getPruned() {
        return this.pruned;
    }

    public abstract void prune(DependencySet var1);

    public void unprune(int n) {
        Object object;
        this.pruned = null;
        boolean bl = false;
        for (int i = 0; i < this.inEdges.size(); ++i) {
            object = this.inEdges.edgeAt(i);
            DependencySet dependencySet = object.getDepends();
            if (dependencySet.getBranch() > n) continue;
            Individual individual = object.getFrom();
            Role role = object.getRole();
            if (individual.getOutEdges().hasExactEdge(individual, role, this)) continue;
            individual.addOutEdge((Edge)object);
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.abox.getBranchEffectTracker().add(dependencySet.getBranch(), individual.name);
                this.abox.getBranchEffectTracker().add(dependencySet.getBranch(), this.name);
            }
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                bl = true;
                individual.applyNext[5] = 0;
                QueueElement queueElement = new QueueElement(individual);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.MAX_NUMBER);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.GUESS);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.CHOOSE);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.UNIVERSAL);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("RESTORE: " + this.name + " ADD reverse edge " + object);
        }
        if (bl && this instanceof Individual) {
            Individual individual = (Individual)this;
            individual.applyNext[5] = 0;
            object = new QueueElement(individual);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.CHOOSE);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.UNIVERSAL);
        }
    }

    public abstract int getNominalLevel();

    public abstract boolean isNominal();

    public abstract boolean isBlockable();

    public abstract boolean isLiteral();

    public abstract boolean isIndividual();

    public int mergedAt() {
        return this.mergeDepends.getBranch();
    }

    public boolean isMerged() {
        return this.mergedTo != this;
    }

    public Node getMergedTo() {
        return this.mergedTo;
    }

    public DependencySet getMergeDependency(boolean bl) {
        if (!this.isMerged() || !bl) {
            return this.mergeDepends;
        }
        DependencySet dependencySet = this.mergeDepends;
        Node node = this.mergedTo;
        while (node.isMerged()) {
            dependencySet = dependencySet.union(node.mergeDepends, this.abox.doExplanation());
            node = node.mergedTo;
        }
        return dependencySet;
    }

    public Node getSame() {
        if (this.mergedTo == this) {
            return this;
        }
        return this.mergedTo.getSame();
    }

    public void undoSetSame() {
        this.mergedTo.removeMerged(this);
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.mergedTo = this;
    }

    private void addMerged(Node node) {
        if (this.merged == null) {
            this.merged = new HashSet<Node>(3);
        }
        this.merged.add(node);
    }

    public Set<Node> getMerged() {
        if (this.merged == null) {
            return SetUtils.emptySet();
        }
        return this.merged;
    }

    public Map<Node, DependencySet> getAllMerged() {
        HashMap<Node, DependencySet> hashMap = new HashMap<Node, DependencySet>();
        this.getAllMerged(DependencySet.INDEPENDENT, hashMap);
        return hashMap;
    }

    private void getAllMerged(DependencySet dependencySet, Map<Node, DependencySet> map) {
        if (this.merged == null) {
            return;
        }
        for (Node node : this.merged) {
            DependencySet dependencySet2 = dependencySet.union(node.getMergeDependency(false), false);
            map.put(node, dependencySet2);
            node.getAllMerged(dependencySet2, map);
        }
    }

    private void removeMerged(Node node) {
        this.merged.remove(node);
        if (this.merged.isEmpty()) {
            this.merged = null;
        }
    }

    public void setSame(Node node, DependencySet dependencySet) {
        if (this.isSame(node)) {
            return;
        }
        if (this.isDifferent(node)) {
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.setClash(Clash.nominal(this, dependencySet.union(this.mergeDepends, this.abox.doExplanation()).union(node.mergeDepends, this.abox.doExplanation()), node.getName()));
            } else {
                this.abox.setClash(Clash.nominal(this, dependencySet, node.getName()));
            }
            return;
        }
        this.mergedTo = node;
        this.mergeDepends = dependencySet.copy(this.abox.getBranch());
        node.addMerged(this);
    }

    public boolean isSame(Node node) {
        return this.getSame().equals(node.getSame());
    }

    public boolean isDifferent(Node node) {
        return this.differents.containsKey(node);
    }

    public Set<Node> getDifferents() {
        return this.differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return this.differents.get(node);
    }

    public void setDifferent(Node node, DependencySet dependencySet) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node.getName());
        }
        if (this.isDifferent(node)) {
            return;
        }
        if (this.isSame(node)) {
            dependencySet = dependencySet.union(this.getMergeDependency(true), this.abox.doExplanation());
            dependencySet = dependencySet.union(node.getMergeDependency(true), this.abox.doExplanation());
            this.abox.setClash(Clash.nominal(this, dependencySet, node.getName()));
            if (!dependencySet.isIndependent()) {
                return;
            }
        }
        dependencySet = dependencySet.copy(this.abox.getBranch());
        this.differents.put(node, dependencySet);
        node.setDifferent(this, dependencySet);
        this.abox.setChanged(true);
    }

    public void inheritDifferents(Node node, DependencySet dependencySet) {
        for (Map.Entry<Node, DependencySet> entry : node.differents.entrySet()) {
            Node node2 = entry.getKey();
            DependencySet dependencySet2 = dependencySet.union(entry.getValue(), this.abox.doExplanation());
            this.setDifferent(node2, dependencySet2);
        }
    }

    public ATermAppl getName() {
        return this.name;
    }

    public abstract ATermAppl getTerm();

    public String getNameStr() {
        return this.name.getName();
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }

    public List<ATermAppl> getPath() {
        LinkedList<ATermAppl> linkedList = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            linkedList.add(this.name);
        } else {
            Edge edge;
            HashSet<Node> hashSet = new HashSet<Node>();
            Node node = this;
            while (!node.getInEdges().isEmpty() && !hashSet.contains(node = (edge = node.getInEdges().edgeAt(0)).getFrom())) {
                hashSet.add(node);
                linkedList.addFirst(edge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                linkedList.addFirst(node.getName());
                break;
            }
        }
        return linkedList;
    }

    public ABox getABox() {
        return this.abox;
    }
}

