/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.format;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;

public class SimpleLintFormat
implements LintFormat {
    private static final int CLASSES_LIMIT = 6;

    @Override
    public String format(Lint lint) {
        Set<OWLClass> set = lint.getParticipatingClasses();
        Set<OWLClassAxiom> set2 = lint.getParticipatingAxioms();
        if ((set == null || set.isEmpty()) && (set2 == null || set2.isEmpty())) {
            return "";
        }
        Severity severity = lint.getSeverity();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" - ");
        if (severity != null) {
            stringBuilder.append(severity).append(' ');
        }
        if (set != null && !set.isEmpty()) {
            Iterator<OWLClass> iterator = set.iterator();
            for (int i = 0; iterator.hasNext() && i < 6; ++i) {
                OWLClass oWLClass = iterator.next();
                stringBuilder.append(oWLClass).append(' ');
            }
            if (set.size() > 6) {
                stringBuilder.append("... and ");
                stringBuilder.append(set.size() - 6);
                stringBuilder.append(" more.");
            }
            stringBuilder.append('\n');
        } else if (set2 != null && !set2.isEmpty()) {
            for (OWLClassAxiom oWLClassAxiom : set2) {
                stringBuilder.append(oWLClassAxiom).append('\n');
            }
        }
        return stringBuilder.toString();
    }
}

