/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class NumericOperators {
    public static final NumericFunction abs = new Abs();
    public static final NumericFunction add = new Add();
    public static final NumericFunction ceiling = new Ceiling();
    public static final NumericFunction cos = new Cos();
    public static final NumericFunction divide = new Divide();
    public static final NumericFunction floor = new Floor();
    public static final NumericFunction integerDivide = new IntegerDivide();
    public static final NumericFunction mod = new Mod();
    public static final NumericFunction multiply = new Multiply();
    public static final NumericFunction pow = new Pow();
    public static final NumericFunction round = new Round();
    public static final NumericFunction roundHalfToEven = new RoundHalfToEven();
    public static final NumericFunction sin = new Sin();
    public static final NumericFunction subtract = new Subtract();
    public static final NumericFunction tan = new Tan();
    public static final NumericFunction unaryMinus = new UnaryMinus();
    public static final NumericFunction unaryPlus = new UnaryPlus();
    private static final BigInteger BIGINTMAX = new BigInteger("2147483647");
    private static final BigInteger BIGINTMIN = new BigInteger("-2147483648");

    private static class UnaryPlus
    implements NumericFunction {
        private UnaryPlus() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0];
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0];
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return doubleArray[0];
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return floatArray[0];
        }
    }

    private static class UnaryMinus
    implements NumericFunction {
        private UnaryMinus() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0].negate();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0].negate();
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return 0.0 - doubleArray[0];
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return Float.valueOf(0.0f - floatArray[0].floatValue());
        }
    }

    private static class Tan
    implements NumericFunction {
        private Tan() {
        }

        @Override
        public Double apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return this.apply(bigDecimalArray[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return this.apply(bigIntegerArray[0].doubleValue());
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.tan(doubleArray[0]);
        }

        @Override
        public Double apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return this.apply(floatArray[0].doubleValue());
        }
    }

    private static class Subtract
    implements NumericFunction {
        private Subtract() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 2) {
                return null;
            }
            BigDecimal bigDecimal = bigDecimalArray[0].subtract(bigDecimalArray[1]);
            return bigDecimal;
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 2) {
                return null;
            }
            BigInteger bigInteger = bigIntegerArray[0].subtract(bigIntegerArray[1]);
            return bigInteger;
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 2) {
                return null;
            }
            return doubleArray[0] - doubleArray[1];
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 2) {
                return null;
            }
            return Float.valueOf(floatArray[0].floatValue() - floatArray[1].floatValue());
        }
    }

    private static class Sin
    implements NumericFunction {
        private Sin() {
        }

        @Override
        public Double apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return this.apply(bigDecimalArray[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return this.apply(bigIntegerArray[0].doubleValue());
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.sin(doubleArray[0]);
        }

        @Override
        public Double apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return this.apply(floatArray[0].doubleValue());
        }
    }

    private static class RoundHalfToEven
    implements NumericFunction {
        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length < 1 || bigDecimalArray.length > 2) {
                return null;
            }
            int n = 0;
            if (bigDecimalArray.length == 2) {
                if (bigDecimalArray[1].stripTrailingZeros().scale() > 0) {
                    return null;
                }
                BigInteger bigInteger = bigDecimalArray[1].toBigInteger();
                if (bigInteger.compareTo(BIGINTMAX) > 0 || bigInteger.compareTo(BIGINTMIN) < 0) {
                    return null;
                }
                n = bigInteger.intValue();
            }
            return bigDecimalArray[0].setScale(n, 6).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length < 1 || bigIntegerArray.length > 2) {
                return null;
            }
            return bigIntegerArray[0];
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length < 1 || doubleArray.length > 2) {
                return null;
            }
            BigDecimal[] bigDecimalArray = new BigDecimal[doubleArray.length];
            for (int i = 0; i < doubleArray.length; ++i) {
                bigDecimalArray[i] = new BigDecimal(doubleArray[i].toString());
            }
            return this.apply(bigDecimalArray).doubleValue();
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length < 1 || floatArray.length > 2) {
                return null;
            }
            BigDecimal[] bigDecimalArray = new BigDecimal[floatArray.length];
            for (int i = 0; i < floatArray.length; ++i) {
                bigDecimalArray[i] = new BigDecimal(floatArray[i].toString());
            }
            return Float.valueOf(this.apply(bigDecimalArray).floatValue());
        }
    }

    private static class Round
    implements NumericFunction {
        BigDecimal HALF = new BigDecimal("0.5");

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0].add(this.HALF).setScale(0, 3).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0];
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.round(doubleArray[0]);
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return Float.valueOf(Math.round(floatArray[0].floatValue()));
        }
    }

    private static class Pow
    implements NumericFunction {
        private Pow() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 2) {
                return null;
            }
            try {
                BigDecimal bigDecimal = bigDecimalArray[0].pow(bigDecimalArray[1].intValueExact(), MathContext.DECIMAL128);
                return bigDecimal;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 2) {
                return null;
            }
            if (bigIntegerArray[1].compareTo(BIGINTMAX) > 0 || bigIntegerArray[1].compareTo(BigInteger.ZERO) < 0) {
                return null;
            }
            return bigIntegerArray[0].pow(bigIntegerArray[1].intValue());
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 2) {
                return null;
            }
            return Math.pow(doubleArray[0], doubleArray[1]);
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 2) {
                return null;
            }
            return Float.valueOf((float)Math.pow(floatArray[0].floatValue(), floatArray[1].floatValue()));
        }
    }

    private static class Multiply
    implements NumericFunction {
        private Multiply() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length < 1) {
                return null;
            }
            BigDecimal bigDecimal = bigDecimalArray[0];
            for (int i = 1; i < bigDecimalArray.length; ++i) {
                bigDecimal = bigDecimal.multiply(bigDecimalArray[i]);
            }
            return bigDecimal;
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length < 1) {
                return null;
            }
            BigInteger bigInteger = bigIntegerArray[0];
            for (int i = 1; i < bigIntegerArray.length; ++i) {
                bigInteger = bigInteger.multiply(bigIntegerArray[i]);
            }
            return bigInteger;
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length < 1) {
                return null;
            }
            double d = doubleArray[0];
            for (int i = 1; i < doubleArray.length; ++i) {
                d *= doubleArray[i].doubleValue();
            }
            return d;
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length < 1) {
                return null;
            }
            float f = floatArray[0].floatValue();
            for (int i = 1; i < floatArray.length; ++i) {
                f *= floatArray[i].floatValue();
            }
            return Float.valueOf(f);
        }
    }

    private static class Mod
    implements NumericFunction {
        private Mod() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 2) {
                return null;
            }
            if (bigDecimalArray[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            return bigDecimalArray[0].remainder(bigDecimalArray[1], MathContext.DECIMAL128);
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 2) {
                return null;
            }
            if (bigIntegerArray[1].equals(BigInteger.ZERO)) {
                return null;
            }
            return bigIntegerArray[0].remainder(bigIntegerArray[1]);
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 2) {
                return null;
            }
            return doubleArray[0] % doubleArray[1];
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 2) {
                return null;
            }
            return Float.valueOf(floatArray[0].floatValue() % floatArray[1].floatValue());
        }
    }

    private static class IntegerDivide
    implements NumericFunction {
        private IntegerDivide() {
        }

        @Override
        public BigInteger apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 2) {
                return null;
            }
            if (bigDecimalArray[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            return bigDecimalArray[0].divideToIntegralValue(bigDecimalArray[1], MathContext.DECIMAL128).toBigIntegerExact();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 2) {
                return null;
            }
            if (bigIntegerArray[1].equals(BigInteger.ZERO)) {
                return null;
            }
            return bigIntegerArray[0].divide(bigIntegerArray[1]);
        }

        @Override
        public BigInteger apply(Double ... doubleArray) {
            if (doubleArray.length != 2) {
                return null;
            }
            double d = doubleArray[0] / doubleArray[1];
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return null;
            }
            return new BigDecimal(d).toBigInteger();
        }

        @Override
        public BigInteger apply(Float ... floatArray) {
            if (floatArray.length != 2) {
                return null;
            }
            float f = floatArray[0].floatValue() / floatArray[1].floatValue();
            if (Float.isInfinite(f) || Float.isNaN(f)) {
                return null;
            }
            return new BigDecimal(f).toBigInteger();
        }
    }

    private static class Floor
    implements NumericFunction {
        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0].setScale(0, 3).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0];
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.floor(doubleArray[0]);
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return Float.valueOf((float)Math.floor(floatArray[0].floatValue()));
        }
    }

    private static class Divide
    implements NumericFunction {
        private Divide() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 2) {
                return null;
            }
            if (bigDecimalArray[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            BigDecimal bigDecimal = bigDecimalArray[0].divide(bigDecimalArray[1], MathContext.DECIMAL128);
            return bigDecimal;
        }

        @Override
        public BigDecimal apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 2) {
                return null;
            }
            if (bigIntegerArray[1].equals(BigInteger.ZERO)) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(bigIntegerArray[0]);
            BigDecimal bigDecimal2 = new BigDecimal(bigIntegerArray[1]);
            return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128);
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 2) {
                return null;
            }
            return doubleArray[0] / doubleArray[1];
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 2) {
                return null;
            }
            return Float.valueOf(floatArray[0].floatValue() / floatArray[1].floatValue());
        }
    }

    private static class Cos
    implements NumericFunction {
        private Cos() {
        }

        @Override
        public Double apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return this.apply(bigDecimalArray[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return this.apply(bigIntegerArray[0].doubleValue());
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.cos(doubleArray[0]);
        }

        @Override
        public Double apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return this.apply(floatArray[0].doubleValue());
        }
    }

    private static class Ceiling
    implements NumericFunction {
        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0].setScale(0, 2).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0];
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.ceil(doubleArray[0]);
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return Float.valueOf((float)Math.ceil(floatArray[0].floatValue()));
        }
    }

    private static class Add
    implements NumericFunction {
        private Add() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length < 1) {
                return null;
            }
            BigDecimal bigDecimal = bigDecimalArray[0];
            for (int i = 1; i < bigDecimalArray.length; ++i) {
                bigDecimal = bigDecimal.add(bigDecimalArray[i]);
            }
            return bigDecimal;
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length < 1) {
                return null;
            }
            BigInteger bigInteger = bigIntegerArray[0];
            for (int i = 1; i < bigIntegerArray.length; ++i) {
                bigInteger = bigInteger.add(bigIntegerArray[i]);
            }
            return bigInteger;
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length < 1) {
                return null;
            }
            double d = doubleArray[0];
            for (int i = 1; i < doubleArray.length; ++i) {
                d += doubleArray[i].doubleValue();
            }
            return d;
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length < 1) {
                return null;
            }
            float f = floatArray[0].floatValue();
            for (int i = 1; i < floatArray.length; ++i) {
                f += floatArray[i].floatValue();
            }
            return Float.valueOf(f);
        }
    }

    private static class Abs
    implements NumericFunction {
        private Abs() {
        }

        @Override
        public BigDecimal apply(BigDecimal ... bigDecimalArray) {
            if (bigDecimalArray.length != 1) {
                return null;
            }
            return bigDecimalArray[0].abs();
        }

        @Override
        public BigInteger apply(BigInteger ... bigIntegerArray) {
            if (bigIntegerArray.length != 1) {
                return null;
            }
            return bigIntegerArray[0].abs();
        }

        @Override
        public Double apply(Double ... doubleArray) {
            if (doubleArray.length != 1) {
                return null;
            }
            return Math.abs(doubleArray[0]);
        }

        @Override
        public Float apply(Float ... floatArray) {
            if (floatArray.length != 1) {
                return null;
            }
            return Float.valueOf(Math.abs(floatArray[0].floatValue()));
        }
    }
}

