/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class NumericComparisonVisitor
implements NumericVisitor {
    private int result;

    private void argCheck(Number[] numberArray) {
        if (numberArray.length != 2) {
            throw new InternalReasonerException("Wrong number of arguments to comparison visitor.");
        }
    }

    public int getComparison() {
        return this.result;
    }

    @Override
    public void visit(BigDecimal[] bigDecimalArray) {
        this.argCheck(bigDecimalArray);
        this.result = bigDecimalArray[0].compareTo(bigDecimalArray[1]);
    }

    @Override
    public void visit(BigInteger[] bigIntegerArray) {
        this.argCheck(bigIntegerArray);
        this.result = bigIntegerArray[0].compareTo(bigIntegerArray[1]);
    }

    @Override
    public void visit(Double[] doubleArray) {
        this.argCheck(doubleArray);
        this.result = doubleArray[0].compareTo(doubleArray[1]);
    }

    @Override
    public void visit(Float[] floatArray) {
        this.argCheck(floatArray);
        this.result = floatArray[0].compareTo(floatArray[1]);
    }
}

