/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import java.util.ArrayList;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class EntailmentQueryVisitor
extends OWLAxiomVisitorAdapter {
    private IndividualTermConverter indConv;
    private PelletReasoner reasoner;
    private Query query;

    public EntailmentQueryVisitor(PelletReasoner pelletReasoner) {
        this.reasoner = pelletReasoner;
        this.indConv = new IndividualTermConverter();
        this.reset();
    }

    public boolean isEntailed() {
        QueryResult queryResult = QueryEngine.exec(this.query);
        return !queryResult.isEmpty();
    }

    public void reset() {
        this.query = new QueryImpl(this.reasoner.getKB(), false);
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        ATermAppl aTermAppl = this.indConv.getTerm(oWLClassAssertionAxiom.getIndividual());
        ATermAppl aTermAppl2 = this.reasoner.term((OWLObject)oWLClassAssertionAxiom.getClassExpression());
        this.query.add(QueryAtomFactory.TypeAtom(aTermAppl, aTermAppl2));
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        ATermAppl aTermAppl = this.indConv.getTerm(oWLDataPropertyAssertionAxiom.getSubject());
        ATermAppl aTermAppl2 = this.reasoner.term((OWLObject)oWLDataPropertyAssertionAxiom.getProperty());
        ATermAppl aTermAppl3 = this.reasoner.term((OWLObject)oWLDataPropertyAssertionAxiom.getObject());
        this.query.add(QueryAtomFactory.PropertyValueAtom(aTermAppl, aTermAppl2, aTermAppl3));
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        ArrayList arrayList = new ArrayList();
        for (OWLIndividual oWLIndividual : oWLDifferentIndividualsAxiom.getIndividuals()) {
            ATermAppl aTermAppl = this.indConv.getTerm(oWLIndividual);
            for (ATermAppl aTermAppl2 : arrayList) {
                this.query.add(QueryAtomFactory.DifferentFromAtom(aTermAppl, aTermAppl2));
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        ATermAppl aTermAppl = this.indConv.getTerm(oWLNegativeDataPropertyAssertionAxiom.getSubject());
        ATermAppl aTermAppl2 = this.reasoner.term((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getProperty());
        ATermAppl aTermAppl3 = this.reasoner.term((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getObject());
        this.query.add(QueryAtomFactory.NegativePropertyValueAtom(aTermAppl, aTermAppl2, aTermAppl3));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        ATermAppl aTermAppl = this.indConv.getTerm(oWLNegativeObjectPropertyAssertionAxiom.getSubject());
        ATermAppl aTermAppl2 = this.reasoner.term((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getProperty());
        ATermAppl aTermAppl3 = this.indConv.getTerm((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject());
        this.query.add(QueryAtomFactory.NegativePropertyValueAtom(aTermAppl, aTermAppl2, aTermAppl3));
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        ATermAppl aTermAppl = this.indConv.getTerm(oWLObjectPropertyAssertionAxiom.getSubject());
        ATermAppl aTermAppl2 = this.reasoner.term((OWLObject)oWLObjectPropertyAssertionAxiom.getProperty());
        ATermAppl aTermAppl3 = this.indConv.getTerm((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject());
        this.query.add(QueryAtomFactory.PropertyValueAtom(aTermAppl, aTermAppl2, aTermAppl3));
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        ATermAppl aTermAppl = null;
        for (OWLIndividual oWLIndividual : oWLSameIndividualAxiom.getIndividuals()) {
            ATermAppl aTermAppl2 = this.indConv.getTerm(oWLIndividual);
            if (aTermAppl == null) {
                aTermAppl = aTermAppl2;
                continue;
            }
            this.query.add(QueryAtomFactory.SameAsAtom(aTermAppl, aTermAppl2));
        }
    }

    private class IndividualTermConverter
    implements OWLIndividualVisitor {
        private ATermAppl term;

        private IndividualTermConverter() {
        }

        public ATermAppl getTerm(OWLIndividual oWLIndividual) {
            this.term = null;
            oWLIndividual.accept((OWLIndividualVisitor)this);
            return this.term;
        }

        public void visit(OWLNamedIndividual oWLNamedIndividual) {
            this.term = EntailmentQueryVisitor.this.reasoner.term((OWLObject)oWLNamedIndividual);
        }

        public void visit(OWLAnonymousIndividual oWLAnonymousIndividual) {
            this.term = ATermUtils.makeVar(oWLAnonymousIndividual.toStringID());
        }
    }
}

