/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.converter;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.converter.TripleAdder;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;

public class ConceptConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private Graph graph;
    private Node subj;
    private Node obj;

    public ConceptConverter(Graph graph) {
        this.graph = graph;
    }

    public Node convert(ATerm aTerm) {
        return this.convert(aTerm, null);
    }

    public Node convert(ATerm aTerm, Node node) {
        Node node2 = this.subj;
        this.subj = node;
        this.obj = null;
        if (aTerm instanceof ATermAppl) {
            this.visit((ATermAppl)aTerm);
        } else if (aTerm instanceof ATermInt) {
            this.obj = Node.createLiteral((String)aTerm.toString(), null, (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        } else if (aTerm instanceof ATermList) {
            this.visitList((ATermList)aTerm);
        } else {
            throw new IllegalArgumentException(aTerm.toString());
        }
        this.subj = node2;
        return this.obj;
    }

    public Node getResult() {
        return this.obj;
    }

    @Override
    public void visitTerm(ATermAppl aTermAppl) {
        this.obj = JenaUtils.makeGraphNode(aTermAppl);
    }

    private void createClassExpression(Property property) {
        this.createExpression(property);
    }

    private void createDataExpression(Property property) {
        this.createExpression(property);
    }

    private void createExpression(Property property) {
        if (this.subj != null) {
            TripleAdder.add(this.graph, this.subj, (Resource)property, this.obj);
        } else {
            Node node = Node.createAnon();
            TripleAdder.add(this.graph, node, (Resource)property, this.obj);
            this.obj = node;
        }
    }

    @Override
    public void visitAnd(ATermAppl aTermAppl) {
        this.visitList((ATermList)aTermAppl.getArgument(0));
        this.createClassExpression(OWL.intersectionOf);
    }

    @Override
    public void visitOr(ATermAppl aTermAppl) {
        this.visitList((ATermList)aTermAppl.getArgument(0));
        this.createClassExpression(OWL.unionOf);
    }

    @Override
    public void visitNot(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.createClassExpression(OWL.complementOf);
    }

    private Node createQualifiedRestriction(ATermAppl aTermAppl, Property property) {
        Node node = this.createRestriction(aTermAppl, property);
        Node node2 = this.convert(aTermAppl.getArgument(2));
        if (!ATermUtils.isTop((ATermAppl)aTermAppl.getArgument(2))) {
            TripleAdder.add(this.graph, node, (Resource)OWL2.onClass, node2);
        }
        this.obj = node;
        return node;
    }

    private Node createRestriction(ATermAppl aTermAppl, Property property) {
        Node node = Node.createAnon();
        Node node2 = this.convert(aTermAppl.getArgument(0));
        Node node3 = this.convert(aTermAppl.getArgument(1));
        TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this.graph, node, (Resource)OWL.onProperty, node2);
        TripleAdder.add(this.graph, node, (Resource)property, node3);
        this.obj = node;
        return node;
    }

    @Override
    public void visitSome(ATermAppl aTermAppl) {
        this.createRestriction(aTermAppl, OWL.someValuesFrom);
    }

    @Override
    public void visitAll(ATermAppl aTermAppl) {
        this.createRestriction(aTermAppl, OWL.allValuesFrom);
    }

    @Override
    public void visitMin(ATermAppl aTermAppl) {
        this.createQualifiedRestriction(aTermAppl, OWL.minCardinality);
    }

    @Override
    public void visitCard(ATermAppl aTermAppl) {
        this.createQualifiedRestriction(aTermAppl, OWL.cardinality);
    }

    @Override
    public void visitMax(ATermAppl aTermAppl) {
        this.createQualifiedRestriction(aTermAppl, OWL.maxCardinality);
    }

    @Override
    public void visitHasValue(ATermAppl aTermAppl) {
        this.createRestriction(aTermAppl, OWL.hasValue);
    }

    @Override
    public void visitValue(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
    }

    @Override
    public void visitSelf(ATermAppl aTermAppl) {
        Node node = Node.createAnon();
        Node node2 = this.convert(aTermAppl.getArgument(0));
        TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this.graph, node, (Resource)OWL.onProperty, node2);
        TripleAdder.add(this.graph, node, (Resource)OWL2.hasSelf, (RDFNode)JenaUtils.XSD_BOOLEAN_TRUE);
        this.obj = node;
    }

    @Override
    public void visitOneOf(ATermAppl aTermAppl) {
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        this.visitList(aTermList);
        if (aTermList.isEmpty() || !ATermUtils.isLiteral((ATermAppl)((ATermAppl)aTermList.getFirst()).getArgument(0))) {
            this.createClassExpression(OWL.oneOf);
        } else {
            this.createDataExpression(OWL.oneOf);
        }
    }

    @Override
    public void visitLiteral(ATermAppl aTermAppl) {
        this.obj = JenaUtils.makeGraphNode(aTermAppl);
    }

    @Override
    public void visitList(ATermList aTermList) {
        if (aTermList.isEmpty()) {
            this.obj = RDF.nil.asNode();
        } else {
            Node node = Node.createAnon();
            Node node2 = this.convert(aTermList.getFirst());
            TripleAdder.add(this.graph, node, (Resource)RDF.first, node2);
            this.visitList(aTermList.getNext());
            TripleAdder.add(this.graph, node, (Resource)RDF.rest, this.obj);
            this.obj = node;
        }
    }

    @Override
    public void visitInverse(ATermAppl aTermAppl) {
        Node node = Node.createAnon();
        Node node2 = this.convert(aTermAppl.getArgument(0));
        TripleAdder.add(this.graph, node, (Resource)OWL.inverseOf, node2);
        this.obj = node;
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl aTermAppl) {
        Node node = Node.createAnon();
        TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)RDFS.Datatype);
        TripleAdder.add(this.graph, node, (Resource)OWL2.onDatatype, JenaUtils.makeGraphNode((ATermAppl)aTermAppl.getArgument(0)));
        Node node2 = null;
        ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            Node node3 = Node.createAnon();
            TripleAdder.add(this.graph, node3, JenaUtils.makeGraphNode((ATermAppl)aTermAppl2.getArgument(0)), JenaUtils.makeGraphNode((ATermAppl)aTermAppl2.getArgument(1)));
            Node node4 = Node.createAnon();
            TripleAdder.add(this.graph, node4, (Resource)RDF.first, node3);
            if (node2 != null) {
                TripleAdder.add(this.graph, node2, (Resource)RDF.rest, node4);
            } else {
                TripleAdder.add(this.graph, node, (Resource)OWL2.withRestrictions, node4);
            }
            node2 = node4;
            aTermList = aTermList.getNext();
        }
        TripleAdder.add(this.graph, node2, (Resource)RDF.rest, (RDFNode)RDF.nil);
        this.obj = node;
    }
}

