/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.text.DecimalFormat;

public class MemUtils {
    private static final Runtime runtime = Runtime.getRuntime();
    public static final double BYTES_PER_MB = 1048576.0;
    private static final DecimalFormat MB_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance();

    public static void runGC() {
        try {
            for (int i = 0; i < 4; ++i) {
                MemUtils._runGC();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void _runGC() throws Exception {
        long l = MemUtils.usedMemory();
        long l2 = Long.MAX_VALUE;
        for (int i = 0; l < l2 && i < 500; ++i) {
            runtime.runFinalization();
            runtime.gc();
            Thread.yield();
            l2 = l;
            l = MemUtils.usedMemory();
        }
    }

    public static long usedMemory() {
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static long freeMemory() {
        return runtime.freeMemory();
    }

    public static long totalMemory() {
        return runtime.totalMemory();
    }

    public static double mb(long l) {
        return (double)l / 1048576.0;
    }

    public static void printUsedMemory(String string) {
        System.out.println(string + " " + MB_FORMAT.format(MemUtils.mb(MemUtils.usedMemory())) + "mb");
    }

    public static void printMemory(String string, long l) {
        System.out.println(string + " " + MB_FORMAT.format(MemUtils.mb(l)) + "mb");
    }

    static {
        MB_FORMAT.setMaximumFractionDigits(2);
    }
}

