/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.mindswap.pellet.utils.AlphaNumericComparator;

public class FileUtils {
    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static String readURL(URL uRL) throws IOException {
        return FileUtils.readAll(new InputStreamReader(uRL.openStream()));
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(file));
    }

    public static String readFile(String string) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(string));
    }

    public static String readAll(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((n = bufferedReader.read()) > -1) {
            stringBuffer.append((char)n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static String toURI(String string) {
        if (com.hp.hpl.jena.util.FileUtils.isURI((String)string)) {
            return string;
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException(new FileNotFoundException(file.getAbsolutePath()));
        }
        try {
            return file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(string + " is not a valid URI");
        }
    }

    public static Collection<String> getFileURIsFromRegex(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && file2.exists()) {
                final String string2 = file.getName();
                File[] fileArray = file2.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return file != null && string.matches(string2);
                    }
                });
                if (fileArray.length == 0) {
                    throw new RuntimeException("File not found: " + string);
                }
                Arrays.sort(fileArray, AlphaNumericComparator.CASE_INSENSITIVE);
                for (File file3 : fileArray) {
                    arrayList.add(file3.toURI().toString());
                }
                continue;
            }
            if (file.exists()) {
                arrayList.add(file.toURI().toString());
                continue;
            }
            if (URI.create(string) == null) {
                throw new RuntimeException(new FileNotFoundException(string));
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Collection<String> getFileURIs(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(FileUtils.getFileURI(string));
        }
        return arrayList;
    }

    public static String getFileURI(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file.exists()) {
            return file.toURI().toString();
        }
        if (file2 != null && file2.exists()) {
            throw new RuntimeException(new FileNotFoundException(string));
        }
        if (URI.create(string) == null) {
            throw new RuntimeException(new FileNotFoundException(string));
        }
        return string;
    }
}

