/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class KRSSLoader
extends KBLoader {
    public static final Logger log = Logger.getLogger(KRSSLoader.class.getName());
    private static final ATermAppl XSD_INTEGER = XSDInteger.getInstance().getName();
    private StreamTokenizer in;
    private KnowledgeBase kb;
    private ArrayList<ATermAppl> terms;
    private Map<ATermAppl, List<ATermAppl>> disjoints;
    private boolean forceUppercase;
    private static final int QUOTE = 124;

    public KRSSLoader() {
        this(new KnowledgeBase());
    }

    public KRSSLoader(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.forceUppercase = false;
    }

    @Override
    public void clear() {
        this.kb.clear();
    }

    public boolean isForceUppercase() {
        return this.forceUppercase;
    }

    public void setForceUppercase(boolean bl) {
        this.forceUppercase = bl;
    }

    private void initTokenizer(Reader reader) {
        this.in = new StreamTokenizer(reader);
        this.in.lowerCaseMode(false);
        this.in.commentChar(59);
        this.in.wordChars(47, 47);
        this.in.wordChars(95, 95);
        this.in.wordChars(42, 42);
        this.in.wordChars(63, 63);
        this.in.wordChars(37, 37);
        this.in.wordChars(62, 62);
        this.in.wordChars(60, 60);
        this.in.wordChars(61, 61);
        this.in.quoteChar(124);
    }

    private void skipNext() throws IOException {
        this.in.nextToken();
    }

    private void skipNext(int n) throws IOException {
        ATermUtils.assertTrue(n == this.in.nextToken());
    }

    private void skipNext(String string) throws IOException {
        this.in.nextToken();
        ATermUtils.assertTrue(string.equals(this.in.sval));
    }

    private boolean peekNext(int n) throws IOException {
        int n2 = this.in.nextToken();
        this.in.pushBack();
        return n == n2;
    }

    private String nextString() throws IOException {
        this.in.nextToken();
        switch (this.in.ttype) {
            case -3: 
            case 124: {
                return this.in.sval;
            }
            case -2: {
                return String.valueOf(this.in.nval);
            }
        }
        throw new RuntimeException("Expecting string found " + (char)this.in.ttype);
    }

    private int nextInt() throws IOException {
        this.in.nextToken();
        return (int)this.in.nval;
    }

    private String nextNumber() throws IOException {
        this.in.nextToken();
        String string = String.valueOf((long)this.in.nval);
        return string;
    }

    private ATermAppl nextTerm() throws IOException {
        String string = this.nextString();
        if (this.forceUppercase) {
            string = string.toUpperCase();
        }
        return ATermUtils.makeTermAppl(string);
    }

    private ATermAppl[] parseExprList() throws IOException {
        int n = 0;
        while (this.peekNext(40)) {
            this.skipNext();
            ++n;
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        while (true) {
            if (this.peekNext(41)) {
                if (n == 0) break;
                this.skipNext();
                if (--n != 0) continue;
                break;
            }
            if (this.peekNext(40)) {
                this.skipNext();
                ++n;
                continue;
            }
            arrayList.add(this.parseExpr());
        }
        return arrayList.toArray(new ATermAppl[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ATermAppl parseExpr() throws IOException {
        int n;
        ATermAppl aTermAppl = null;
        int n2 = this.in.nextToken();
        String string = this.in.sval;
        if (n2 == -3 || n2 == 124) {
            if (string.equalsIgnoreCase("TOP")) return ATermUtils.TOP;
            if (string.equalsIgnoreCase("*TOP*")) return ATermUtils.TOP;
            if (string.equalsIgnoreCase(":TOP")) {
                return ATermUtils.TOP;
            }
            if (string.equalsIgnoreCase("BOTTOM")) return ATermUtils.BOTTOM;
            if (string.equalsIgnoreCase("*BOTTOM*")) {
                return ATermUtils.BOTTOM;
            }
            if (!this.forceUppercase) return ATermUtils.makeTermAppl(string);
            string = string.toUpperCase();
            return ATermUtils.makeTermAppl(string);
        }
        if (n2 == -2) {
            return ATermUtils.makeTermAppl(String.valueOf(this.in.nval));
        }
        if (n2 == 58) {
            string = this.nextString();
            if (string.equalsIgnoreCase("TOP")) {
                return ATermUtils.TOP;
            }
            if (!string.equalsIgnoreCase("BOTTOM")) throw new RuntimeException("Parse exception after ':' " + string);
            return ATermUtils.BOTTOM;
        }
        if (n2 == 40) {
            n2 = this.in.nextToken();
            ATermUtils.assertTrue(n2 == -3);
            string = this.in.sval;
            if (string.equalsIgnoreCase("NOT")) {
                ATermAppl aTermAppl2 = this.parseExpr();
                aTermAppl = ATermUtils.makeNot((ATerm)aTermAppl2);
                if (ATermUtils.isPrimitive(aTermAppl2)) {
                    this.kb.addClass(aTermAppl2);
                }
            } else if (string.equalsIgnoreCase("AND")) {
                ATermList aTermList = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl aTermAppl3 = this.parseExpr();
                    if (ATermUtils.isPrimitive(aTermAppl3)) {
                        this.kb.addClass(aTermAppl3);
                    }
                    aTermList = aTermList.insert((ATerm)aTermAppl3);
                }
                aTermAppl = ATermUtils.makeAnd(aTermList);
            } else if (string.equalsIgnoreCase("OR")) {
                ATermList aTermList = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl aTermAppl4 = this.parseExpr();
                    if (ATermUtils.isPrimitive(aTermAppl4)) {
                        this.kb.addClass(aTermAppl4);
                    }
                    aTermList = aTermList.insert((ATerm)aTermAppl4);
                }
                aTermAppl = ATermUtils.makeOr(aTermList);
            } else if (string.equalsIgnoreCase("ONE-OF")) {
                ATermList aTermList = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl aTermAppl5 = this.parseExpr();
                    this.kb.addIndividual(aTermAppl5);
                    aTermList = aTermList.insert((ATerm)ATermUtils.makeValue((ATerm)aTermAppl5));
                }
                aTermAppl = ATermUtils.makeOr(aTermList);
            } else if (string.equalsIgnoreCase("ALL")) {
                ATermAppl aTermAppl6 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl6);
                ATermAppl aTermAppl7 = this.parseExpr();
                if (ATermUtils.isPrimitive(aTermAppl7)) {
                    this.kb.addClass(aTermAppl7);
                }
                aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl6, (ATerm)aTermAppl7);
            } else if (string.equalsIgnoreCase("SOME")) {
                ATermAppl aTermAppl8 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl8);
                ATermAppl aTermAppl9 = this.parseExpr();
                if (ATermUtils.isPrimitive(aTermAppl9)) {
                    this.kb.addClass(aTermAppl9);
                }
                aTermAppl = ATermUtils.makeSomeValues((ATerm)aTermAppl8, (ATerm)aTermAppl9);
            } else if (string.equalsIgnoreCase("AT-LEAST") || string.equalsIgnoreCase("ATLEAST")) {
                int n3 = this.nextInt();
                ATermAppl aTermAppl10 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl10);
                ATermAppl aTermAppl11 = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    aTermAppl11 = this.parseExpr();
                }
                aTermAppl = ATermUtils.makeMin((ATerm)aTermAppl10, n3, (ATerm)aTermAppl11);
            } else if (string.equalsIgnoreCase("AT-MOST") || string.equalsIgnoreCase("ATMOST")) {
                int n4 = this.nextInt();
                ATermAppl aTermAppl12 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl12);
                ATermAppl aTermAppl13 = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    aTermAppl13 = this.parseExpr();
                }
                aTermAppl = ATermUtils.makeMax((ATerm)aTermAppl12, n4, (ATerm)aTermAppl13);
            } else if (string.equalsIgnoreCase("EXACTLY")) {
                int n5 = this.nextInt();
                ATermAppl aTermAppl14 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl14);
                ATermAppl aTermAppl15 = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    aTermAppl15 = this.parseExpr();
                }
                aTermAppl = ATermUtils.makeCard((ATerm)aTermAppl14, n5, (ATerm)aTermAppl15);
            } else if (string.equalsIgnoreCase("A")) {
                ATermAppl aTermAppl16 = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)aTermAppl16);
                this.kb.addFunctionalProperty(aTermAppl16);
                aTermAppl = ATermUtils.makeMin((ATerm)aTermAppl16, 1, (ATerm)ATermUtils.TOP_LIT);
            } else if (string.equalsIgnoreCase("MIN") || string.equals(">=")) {
                ATermAppl aTermAppl17 = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)aTermAppl17);
                String string2 = this.nextNumber();
                ATermAppl aTermAppl18 = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MIN_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(string2, XSD_INTEGER))});
                aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl17, (ATerm)aTermAppl18);
            } else if (string.equalsIgnoreCase("MAX") || string.equals("<=")) {
                ATermAppl aTermAppl19 = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)aTermAppl19);
                String string3 = this.nextNumber();
                ATermAppl aTermAppl20 = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MAX_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(string3, XSD_INTEGER))});
                aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl19, (ATerm)aTermAppl20);
            } else if (string.equals("=")) {
                ATermAppl aTermAppl21 = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)aTermAppl21);
                String string4 = this.nextNumber();
                ATermAppl aTermAppl22 = ATermUtils.makeOr(ATermUtils.makeList((ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makeTypedLiteral(string4, XSD_INTEGER))));
                aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl21, (ATerm)aTermAppl22);
            } else {
                if (!string.equalsIgnoreCase("INV")) throw new RuntimeException("Unknown expression " + string);
                ATermAppl aTermAppl23 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl23);
                aTermAppl = this.kb.getProperty((ATerm)aTermAppl23).getInverse().getName();
            }
            if (this.in.nextToken() == 41) return aTermAppl;
            throw new RuntimeException("Parse exception at term " + string);
        }
        if (n2 == 35) {
            n = this.nextInt();
            if (this.peekNext(35)) {
                this.skipNext();
                aTermAppl = this.terms.get(n);
                if (aTermAppl != null) return aTermAppl;
                throw new RuntimeException("Parse exception: #" + n + "# is not defined");
            }
            this.skipNext("=");
            aTermAppl = this.parseExpr();
            while (this.terms.size() <= n) {
                this.terms.add(null);
            }
        } else {
            if (n2 != -1) throw new RuntimeException("Invalid token");
            return null;
        }
        this.terms.set(n, aTermAppl);
        return aTermAppl;
    }

    @Override
    public void parseFile(String string) {
        try {
            InputStream inputStream = URI.create(string).toURL().openStream();
            this.parse(new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void parse(Reader reader) throws IOException {
        this.initTokenizer(reader);
        this.terms = new ArrayList();
        this.disjoints = new HashMap<ATermAppl, List<ATermAppl>>();
        int n = this.in.nextToken();
        while (n != -1) {
            int n2;
            ATermAppl aTermAppl;
            if (n == 35) {
                this.in.ordinaryChar(124);
                n = this.in.nextToken();
                while (n != 35) {
                    n = this.in.nextToken();
                }
                this.in.quoteChar(124);
                n = this.in.nextToken();
                if (n == -1) break;
            }
            if (n != 40) {
                throw new RuntimeException("Parsing error: Expecting '(' but found " + this.in);
            }
            String string2 = this.nextString();
            if (string2.equalsIgnoreCase("DEFINE-ROLE") || string2.equalsIgnoreCase("DEFINE-PRIMITIVE-ROLE") || string2.equalsIgnoreCase("DEFPRIMROLE") || string2.equalsIgnoreCase("DEFINE-ATTRIBUTE") || string2.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || string2.equalsIgnoreCase("DEFPRIMATTRIBUTE") || string2.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY")) {
                aTermAppl = this.nextTerm();
                boolean bl = string2.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY");
                boolean bl2 = string2.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || string2.equalsIgnoreCase("DEFPRIMATTRIBUTE");
                int n3 = n2 = string2.indexOf("PRIm") != -1 ? 1 : 0;
                if (bl) {
                    this.kb.addDatatypeProperty((ATerm)aTermAppl);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("DEFINE-DATATYPE-ROLE " + aTermAppl);
                    }
                } else {
                    this.kb.addObjectProperty((ATerm)aTermAppl);
                    if (bl2) {
                        this.kb.addFunctionalProperty(aTermAppl);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("DEFINE-PRIMITIVE-ATTRIBUTE " + aTermAppl);
                        }
                    } else if (log.isLoggable(Level.FINE)) {
                        log.fine("DEFINE-PRIMITIVE-ROLE " + aTermAppl);
                    }
                }
                while (!this.peekNext(41)) {
                    ATermAppl aTermAppl2;
                    if (this.peekNext(58)) {
                        this.skipNext(58);
                        String string = this.nextString();
                        if (string.equalsIgnoreCase("parents")) {
                            boolean bl3 = this.peekNext(40);
                            if (bl3) {
                                this.skipNext(40);
                                while (!this.peekNext(41)) {
                                    aTermAppl2 = this.nextTerm();
                                    if (aTermAppl2.getName().equals("NIL")) continue;
                                    this.kb.addObjectProperty((ATerm)aTermAppl2);
                                    this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl2);
                                    if (!log.isLoggable(Level.FINE)) continue;
                                    log.fine("PARENT-ROLE " + aTermAppl + " " + aTermAppl2);
                                }
                                this.skipNext(41);
                                continue;
                            }
                            aTermAppl2 = this.nextTerm();
                            if (aTermAppl2.toString().equalsIgnoreCase("NIL")) continue;
                            this.kb.addObjectProperty((ATerm)aTermAppl2);
                            this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl2);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("PARENT-ROLE " + aTermAppl + " " + aTermAppl2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("feature")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this.kb.addFunctionalProperty(aTermAppl);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("FUNCTIONAL-ROLE " + aTermAppl);
                            continue;
                        }
                        if (string.equalsIgnoreCase("transitive")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this.kb.addTransitiveProperty(aTermAppl);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("TRANSITIVE-ROLE " + aTermAppl);
                            continue;
                        }
                        if (string.equalsIgnoreCase("range")) {
                            ATermAppl aTermAppl3 = this.parseExpr();
                            this.kb.addClass(aTermAppl3);
                            this.kb.addRange((ATerm)aTermAppl, aTermAppl3);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("RANGE " + aTermAppl + " " + aTermAppl3);
                            continue;
                        }
                        if (string.equalsIgnoreCase("domain")) {
                            ATermAppl aTermAppl4 = this.parseExpr();
                            this.kb.addClass(aTermAppl4);
                            this.kb.addDomain((ATerm)aTermAppl, aTermAppl4);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("DOMAIN " + aTermAppl + " " + aTermAppl4);
                            continue;
                        }
                        if (string.equalsIgnoreCase("inverse")) {
                            ATermAppl aTermAppl5 = this.nextTerm();
                            this.kb.addInverseProperty(aTermAppl, aTermAppl5);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("INVERSE " + aTermAppl + " " + aTermAppl5);
                            continue;
                        }
                        throw new RuntimeException("Parsing error: Unrecognized keyword in role definition " + string);
                    }
                    if (this.peekNext(40)) {
                        this.skipNext(40);
                        String string = this.nextString();
                        if (string.equalsIgnoreCase("domain-range")) {
                            ATermAppl aTermAppl6 = this.nextTerm();
                            aTermAppl2 = this.nextTerm();
                            this.kb.addDomain((ATerm)aTermAppl, aTermAppl6);
                            this.kb.addRange((ATerm)aTermAppl, aTermAppl2);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("DOMAIN-RANGE " + aTermAppl + " " + aTermAppl6 + " " + aTermAppl2);
                            }
                        } else {
                            throw new RuntimeException("Parsing error: Unrecognized keyword in role definition");
                        }
                        this.skipNext(41);
                        continue;
                    }
                    ATermAppl aTermAppl7 = this.parseExpr();
                    if (bl) {
                        this.kb.addDatatypeProperty((ATerm)aTermAppl7);
                    } else {
                        this.kb.addObjectProperty((ATerm)aTermAppl);
                    }
                    if (n2 != 0) {
                        this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl7);
                    } else {
                        this.kb.addEquivalentProperty(aTermAppl, aTermAppl7);
                    }
                    log.fine("PARENT-ROLE " + aTermAppl + " " + aTermAppl7);
                }
            } else if (string2.equalsIgnoreCase("DEFINE-PRIMITIVE-CONCEPT") || string2.equalsIgnoreCase("DEFPRIMCONCEPT")) {
                aTermAppl = this.nextTerm();
                this.kb.addClass(aTermAppl);
                ATermAppl aTermAppl7 = null;
                if (!this.peekNext(41) && !(aTermAppl7 = this.parseExpr()).getName().equals("NIL")) {
                    this.kb.addClass(aTermAppl7);
                    this.kb.addSubClass(aTermAppl, aTermAppl7);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-PRIMITIVE-CONCEPT " + aTermAppl + " " + (aTermAppl7 == null ? "" : aTermAppl7.toString()));
                }
            } else if (string2.equalsIgnoreCase("DEFINE-DISJOINT-PRIMITIVE-CONCEPT")) {
                aTermAppl = this.nextTerm();
                this.kb.addClass(aTermAppl);
                this.skipNext(40);
                while (!this.peekNext(41)) {
                    ATermAppl aTermAppl8 = this.parseExpr();
                    List<ATermAppl> list = this.disjoints.get(aTermAppl8);
                    if (list == null) {
                        list = new ArrayList<ATermAppl>();
                    }
                    for (ATermAppl aTermAppl9 : list) {
                        this.kb.addDisjointClass(aTermAppl, aTermAppl9);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("DEFINE-PRIMITIVE-DISJOINT " + aTermAppl + " " + aTermAppl9);
                    }
                    list.add(aTermAppl);
                }
                this.skipNext(41);
                ATermAppl aTermAppl9 = this.parseExpr();
                this.kb.addSubClass(aTermAppl, aTermAppl9);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-PRIMITIVE-CONCEPT " + aTermAppl + " " + aTermAppl9);
                }
            } else if (string2.equalsIgnoreCase("DEFINE-CONCEPT") || string2.equalsIgnoreCase("DEFCONCEPT") || string2.equalsIgnoreCase("EQUAL_C")) {
                aTermAppl = this.nextTerm();
                this.kb.addClass(aTermAppl);
                ATermAppl aTermAppl10 = this.parseExpr();
                this.kb.addEquivalentClass(aTermAppl, aTermAppl10);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-CONCEPT " + aTermAppl + " " + aTermAppl10);
                }
            } else if (string2.equalsIgnoreCase("IMPLIES") || string2.equalsIgnoreCase("IMPLIES_C")) {
                aTermAppl = this.parseExpr();
                ATermAppl aTermAppl11 = this.parseExpr();
                this.kb.addClass(aTermAppl);
                this.kb.addClass(aTermAppl11);
                this.kb.addSubClass(aTermAppl, aTermAppl11);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IMPLIES " + aTermAppl + " " + aTermAppl11);
                }
            } else if (string2.equalsIgnoreCase("IMPLIES_R")) {
                aTermAppl = this.parseExpr();
                ATermAppl aTermAppl12 = this.parseExpr();
                this.kb.addProperty(aTermAppl);
                this.kb.addProperty(aTermAppl12);
                this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl12);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IMPLIES_R " + aTermAppl + " " + aTermAppl12);
                }
            } else if (string2.equalsIgnoreCase("EQUAL_R")) {
                aTermAppl = this.parseExpr();
                ATermAppl aTermAppl13 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl);
                this.kb.addObjectProperty((ATerm)aTermAppl13);
                this.kb.addEquivalentProperty(aTermAppl, aTermAppl13);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("EQUAL_R " + aTermAppl + " " + aTermAppl13);
                }
            } else if (string2.equalsIgnoreCase("DOMAIN")) {
                aTermAppl = this.parseExpr();
                ATermAppl aTermAppl14 = this.parseExpr();
                this.kb.addProperty(aTermAppl);
                this.kb.addClass(aTermAppl14);
                this.kb.addDomain((ATerm)aTermAppl, aTermAppl14);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DOMAIN " + aTermAppl + " " + aTermAppl14);
                }
            } else if (string2.equalsIgnoreCase("RANGE")) {
                aTermAppl = this.parseExpr();
                ATermAppl aTermAppl15 = this.parseExpr();
                this.kb.addProperty(aTermAppl);
                this.kb.addClass(aTermAppl15);
                this.kb.addRange((ATerm)aTermAppl, aTermAppl15);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RANGE " + aTermAppl + " " + aTermAppl15);
                }
            } else if (string2.equalsIgnoreCase("FUNCTIONAL")) {
                aTermAppl = this.parseExpr();
                this.kb.addProperty(aTermAppl);
                this.kb.addFunctionalProperty(aTermAppl);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FUNCTIONAL " + aTermAppl);
                }
            } else if (string2.equalsIgnoreCase("TRANSITIVE")) {
                aTermAppl = this.parseExpr();
                this.kb.addObjectProperty((ATerm)aTermAppl);
                this.kb.addTransitiveProperty(aTermAppl);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("TRANSITIVE " + aTermAppl);
                }
            } else if (string2.equalsIgnoreCase("DISJOINT")) {
                aTermAppl = this.parseExprList();
                for (int i = 0; i < ((ATermAppl)aTermAppl).length - 1; ++i) {
                    ATermAppl aTermAppl16 = aTermAppl[i];
                    for (n2 = i + 1; n2 < ((ATermAppl)aTermAppl).length; ++n2) {
                        ATermAppl aTermAppl10 = aTermAppl[n2];
                        this.kb.addClass(aTermAppl10);
                        this.kb.addDisjointClass(aTermAppl16, aTermAppl10);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("DISJOINT " + aTermAppl16 + " " + aTermAppl10);
                    }
                }
            } else if (string2.equalsIgnoreCase("DEFINDIVIDUAL")) {
                aTermAppl = this.nextTerm();
                this.kb.addIndividual(aTermAppl);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINDIVIDUAL " + aTermAppl);
                }
            } else if (string2.equalsIgnoreCase("INSTANCE")) {
                aTermAppl = this.nextTerm();
                ATermAppl aTermAppl17 = this.parseExpr();
                this.kb.addIndividual(aTermAppl);
                this.kb.addType(aTermAppl, aTermAppl17);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("INSTANCE " + aTermAppl + " " + aTermAppl17);
                }
            } else if (string2.equalsIgnoreCase("RELATED")) {
                aTermAppl = this.nextTerm();
                ATermAppl aTermAppl18 = this.nextTerm();
                ATermAppl aTermAppl19 = this.nextTerm();
                this.kb.addIndividual(aTermAppl);
                this.kb.addIndividual(aTermAppl18);
                this.kb.addPropertyValue(aTermAppl19, aTermAppl, aTermAppl18);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RELATED " + aTermAppl + " - " + aTermAppl19 + " -> " + aTermAppl18);
                }
            } else if (string2.equalsIgnoreCase("DIFFERENT")) {
                aTermAppl = this.nextTerm();
                ATermAppl aTermAppl20 = this.nextTerm();
                this.kb.addIndividual(aTermAppl);
                this.kb.addIndividual(aTermAppl20);
                this.kb.addDifferent(aTermAppl, aTermAppl20);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DIFFERENT " + aTermAppl + " " + aTermAppl20);
                }
            } else if (string2.equalsIgnoreCase("DATATYPE-ROLE-FILLER")) {
                aTermAppl = this.nextTerm();
                ATermAppl aTermAppl21 = ATermUtils.makePlainLiteral(this.nextString());
                ATermAppl aTermAppl22 = this.nextTerm();
                this.kb.addIndividual(aTermAppl);
                this.kb.addIndividual(aTermAppl21);
                this.kb.addPropertyValue(aTermAppl22, aTermAppl, aTermAppl21);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DATATYPE-ROLE-FILLER " + aTermAppl + " - " + aTermAppl22 + " -> " + aTermAppl21);
                }
            } else {
                throw new RuntimeException("Parsing error: Unknown command " + string2);
            }
            this.skipNext(41);
            n = this.in.nextToken();
        }
    }

    @Override
    public void setIgnoreImports(boolean bl) {
    }

    public void verifyTBox(String string, KnowledgeBase knowledgeBase) throws Exception {
        this.initTokenizer(new FileReader(string));
        boolean bl = false;
        int n = 0;
        int n2 = this.in.nextToken();
        while (n2 != 41 && n2 != -1) {
            ATermAppl aTermAppl;
            Set<ATermAppl> set;
            Object object;
            ATermUtils.assertTrue(n2 == 40);
            ++n;
            ATermAppl aTermAppl2 = null;
            if (this.peekNext(40)) {
                object = this.parseExprList();
                aTermAppl2 = object[0];
                set = knowledgeBase.getEquivalentClasses(aTermAppl2);
                for (int i = 1; i < ((ATermAppl[])object).length; ++i) {
                    ATermAppl aTermAppl3 = object[i];
                    if (set.contains(aTermAppl3)) continue;
                    log.severe(aTermAppl3 + " is not equivalent to " + aTermAppl2);
                    bl = true;
                }
            } else {
                aTermAppl2 = this.parseExpr();
            }
            object = SetUtils.union(knowledgeBase.getSuperClasses(aTermAppl2, true));
            set = SetUtils.union(knowledgeBase.getSubClasses(aTermAppl2, true));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Verify (" + n + ") " + aTermAppl2 + " " + object + " " + set);
            }
            if (this.peekNext(40)) {
                ATermAppl[] aTermApplArray = this.parseExprList();
                for (int i = 0; i < aTermApplArray.length; ++i) {
                    aTermAppl = aTermApplArray[i];
                    if (object.contains(aTermAppl)) continue;
                    log.severe(aTermAppl + " is not a superclass of " + aTermAppl2 + " ");
                    bl = true;
                }
            } else {
                this.skipNext();
            }
            if (this.peekNext(40)) {
                ATermAppl[] aTermApplArray = this.parseExprList();
                for (int i = 0; i < aTermApplArray.length; ++i) {
                    aTermAppl = aTermApplArray[i];
                    if (set.contains(aTermAppl)) continue;
                    HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(set);
                    Set<ATermAppl> set2 = knowledgeBase.getEquivalentClasses(aTermAppl);
                    hashSet.retainAll(set2);
                    if (hashSet.size() != 0) continue;
                    log.severe(aTermAppl + " is not a subclass of " + aTermAppl2);
                    bl = true;
                }
            }
            this.skipNext();
            n2 = this.in.nextToken();
        }
        ATermUtils.assertTrue(this.in.nextToken() == -1);
        if (bl) {
            throw new RuntimeException("Classification results are not correct!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyABox(String string, KnowledgeBase knowledgeBase) throws Exception {
        boolean bl;
        this.initTokenizer(new FileReader(string));
        boolean bl2 = bl = !this.peekNext(40);
        while (!this.peekNext(-1)) {
            boolean bl3;
            if (bl) {
                this.skipNext("Command");
                this.skipNext(61);
            }
            this.skipNext(40);
            this.skipNext("INDIVIDUAL-INSTANCE?");
            ATermAppl aTermAppl = this.nextTerm();
            ATermAppl aTermAppl2 = this.parseExpr();
            if (log.isLoggable(Level.FINE)) {
                log.fine("INDIVIDUAL-INSTANCE? " + aTermAppl + " " + aTermAppl2);
            }
            this.skipNext(41);
            if (bl) {
                this.skipNext(45);
                this.skipNext(62);
                String string2 = this.nextString();
                if (string2.equalsIgnoreCase("T")) {
                    bl3 = true;
                } else {
                    if (!string2.equalsIgnoreCase("NIL")) throw new RuntimeException("Unknown result " + string2);
                    bl3 = false;
                }
            } else {
                bl3 = true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(" -> " + bl3);
            }
            if (knowledgeBase.isType(aTermAppl, aTermAppl2) == bl3) continue;
            throw new RuntimeException("Individual " + aTermAppl + " is " + (bl3 ? "not" : "") + " an instance of " + aTermAppl2);
        }
    }

    @Override
    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public void load() {
    }
}

