/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.jena.JenaUtils;

public class SparqlDLResultSet
implements ResultSetRewindable {
    private Model model;
    private List<ATermAppl> resultVars;
    private List<String> resultVarsString;
    private QueryResult queryResult;
    private int index;
    private Iterator<com.clarkparsia.pellet.sparqldl.model.ResultBinding> bindings;
    private Binding parent;
    private QueryParameters parameters;

    public SparqlDLResultSet(QueryResult queryResult, Model model) {
        this(queryResult, model, null, null);
    }

    public SparqlDLResultSet(QueryResult queryResult, Model model, Binding binding) {
        this(queryResult, model, binding, null);
    }

    public SparqlDLResultSet(QueryResult queryResult, Model model, QueryParameters queryParameters) {
        this(queryResult, model, null, queryParameters);
    }

    public SparqlDLResultSet(QueryResult queryResult, Model model, Binding binding, QueryParameters queryParameters) {
        this.parent = binding;
        this.queryResult = queryResult;
        this.model = model;
        this.parameters = queryParameters;
        this.index = 0;
        this.bindings = queryResult.iterator();
        this.resultVars = new ArrayList<ATermAppl>();
        this.resultVarsString = new ArrayList<String>();
        for (ATermAppl aTermAppl : this.queryResult.getResultVars()) {
            this.resultVars.add(aTermAppl);
            this.resultVarsString.add(this.getVarName(aTermAppl));
        }
        if (queryParameters == null) {
            this.parameters = new QueryParameters();
        }
    }

    protected String getVarName(ATermAppl aTermAppl) {
        return ((ATermAppl)aTermAppl.getArgument(0)).getName();
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public boolean hasNext() {
        return this.bindings.hasNext();
    }

    public Binding nextBinding() {
        Node node;
        Object object;
        String string;
        ++this.index;
        com.clarkparsia.pellet.sparqldl.model.ResultBinding resultBinding = this.bindings.next();
        BindingHashMap bindingHashMap = this.parent == null ? new BindingHashMap() : new BindingHashMap(this.parent);
        for (ATermAppl object2 : this.resultVars) {
            if (!resultBinding.isBound(object2)) continue;
            string = this.getVarName(object2);
            object = resultBinding.getValue(object2);
            if (object == null) continue;
            node = JenaUtils.makeGraphNode(object);
            bindingHashMap.add(Var.alloc((String)string), node);
        }
        if (this.resultVars.size() == 0) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                string = (ATermAppl)entry.getKey();
                object = this.getVarName((ATermAppl)string);
                node = Var.alloc((String)object);
                if (bindingHashMap.contains((Var)node)) continue;
                bindingHashMap.add((Var)node, JenaUtils.makeGraphNode((ATermAppl)entry.getValue()));
            }
        }
        return bindingHashMap;
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return this.queryResult.isDistinct();
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this.index;
    }

    public List<String> getResultVars() {
        return Collections.unmodifiableList(this.resultVarsString);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public String toString() {
        return this.queryResult.toString();
    }

    public void reset() {
        this.index = 0;
        this.bindings = this.queryResult.iterator();
    }

    public int size() {
        return this.queryResult.size();
    }

    public Model getResourceModel() {
        return this.model;
    }
}

