/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.bool.RestrictedBooleanDatatype;
import com.clarkparsia.pellet.utils.TermFactory;

public class XSDBoolean
extends AbstractBaseDatatype<Boolean> {
    private static final ATermAppl CANONICAL_FALSE_TERM;
    private static final ATermAppl CANONICAL_TRUE_TERM;
    private static final XSDBoolean instance;
    private static final ATermAppl NAME;
    private final RestrictedBooleanDatatype dataRange = new RestrictedBooleanDatatype(this);

    public static XSDBoolean getInstance() {
        return instance;
    }

    private XSDBoolean() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<Boolean> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (aTermAppl == CANONICAL_FALSE_TERM || aTermAppl == CANONICAL_TRUE_TERM) {
            return aTermAppl;
        }
        return this.getLiteral(this.getValue(aTermAppl));
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? CANONICAL_TRUE_TERM : CANONICAL_FALSE_TERM;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Boolean getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl).trim();
        if (string.equals("true") || string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equals("false") || string.equals("0")) {
            return Boolean.FALSE;
        }
        throw new InvalidLiteralException(this.getName(), string);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        NAME = Datatypes.BOOLEAN;
        CANONICAL_TRUE_TERM = TermFactory.literal(true);
        CANONICAL_FALSE_TERM = TermFactory.literal(false);
        instance = new XSDBoolean();
    }
}

