/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.NestedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class ModularityUtils {
    public static Set<OWLAxiom> extractModule(OWLOntology oWLOntology, Set<OWLEntity> set, ModuleType moduleType) {
        return ModularityUtils.extractModule(oWLOntology.getImportsClosure(), set, moduleType);
    }

    public static Set<OWLAxiom> extractModule(Set<OWLOntology> set, Set<OWLEntity> set2, ModuleType moduleType) {
        switch (moduleType) {
            case TOP: {
                return ModularityUtils.extractTopModule(ModularityUtils.axiomIterator(set), set2);
            }
            case BOT: {
                return ModularityUtils.extractBottomModule(ModularityUtils.axiomIterator(set), set2);
            }
            case TOP_OF_BOT: {
                Set<OWLAxiom> set3 = ModularityUtils.extractBottomModule(ModularityUtils.axiomIterator(set), set2);
                return ModularityUtils.extractTopModule(set3.iterator(), set2);
            }
            case BOT_OF_TOP: {
                Set<OWLAxiom> set4 = ModularityUtils.extractTopModule(ModularityUtils.axiomIterator(set), set2);
                return ModularityUtils.extractBottomModule(set4.iterator(), set2);
            }
        }
        throw new UnsupportedOperationException("Unrecognized module type: " + moduleType);
    }

    private static Iterator<OWLAxiom> axiomIterator(Set<OWLOntology> set) {
        return new NestedIterator<OWLOntology, OWLAxiom>(set){

            @Override
            public Iterator<? extends OWLAxiom> getInnerIterator(OWLOntology oWLOntology) {
                return oWLOntology.getAxioms().iterator();
            }
        };
    }

    private static Set<OWLAxiom> extractTopModule(Iterator<OWLAxiom> iterator, Set<OWLEntity> set) {
        return ModularityUtils.extractModule(iterator, set, LocalityClass.TOP_TOP);
    }

    private static Set<OWLAxiom> extractBottomModule(Iterator<OWLAxiom> iterator, Set<OWLEntity> set) {
        return ModularityUtils.extractModule(iterator, set, LocalityClass.BOTTOM_BOTTOM);
    }

    private static Set<OWLAxiom> extractModule(Iterator<OWLAxiom> iterator, Set<OWLEntity> set, LocalityClass localityClass) {
        AxiomBasedModuleExtractor axiomBasedModuleExtractor = new AxiomBasedModuleExtractor(localityClass);
        while (iterator.hasNext()) {
            axiomBasedModuleExtractor.addAxiom(iterator.next());
        }
        return axiomBasedModuleExtractor.extractModule(set);
    }
}

