/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.riot.process.normalize.DatatypeHandler;
import org.apache.jena.riot.process.normalize.NormalizeValue;
import org.apache.jena.riot.web.LangTag;

public class CanonicalizeLiteral
implements NodeTransform {
    private static final CanonicalizeLiteral singleton = new CanonicalizeLiteral();
    private static final RDFDatatype dtPlainLiteral = Node.getType((String)(RDF.getURI() + "PlainLiteral"));
    private static final Map<RDFDatatype, DatatypeHandler> dispatch = new HashMap<RDFDatatype, DatatypeHandler>();

    public static CanonicalizeLiteral get() {
        return singleton;
    }

    private CanonicalizeLiteral() {
    }

    @Override
    public Node convert(Node node) {
        Node n2;
        if (!node.isLiteral()) {
            return node;
        }
        RDFDatatype dt = node.getLiteralDatatype();
        if (dt == null) {
            if (node.getLiteralLanguage().equals("")) {
                return node;
            }
            n2 = CanonicalizeLiteral.canonicalLangtag(node, node.getLiteralLexicalForm(), node.getLiteralLanguage());
        } else {
            DatatypeHandler handler = dispatch.get(dt);
            if (handler == null) {
                return node;
            }
            n2 = handler.handle(node, node.getLiteralLexicalForm(), dt);
        }
        if (n2 == null) {
            return node;
        }
        return n2;
    }

    private static Node canonicalLangtag(Node node, String lexicalForm, String langTag) {
        String langTag2 = LangTag.canonical(langTag);
        if (langTag2.equals(langTag)) {
            return null;
        }
        return Node.createLiteral((String)lexicalForm, (String)langTag2, null);
    }

    static {
        dispatch.put((RDFDatatype)XSDDatatype.XSDinteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdecimal, NormalizeValue.dtDecimal);
        dispatch.put((RDFDatatype)XSDDatatype.XSDint, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDlong, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDshort, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDbyte, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedInt, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedLong, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedShort, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedByte, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnonPositiveInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnonNegativeInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDpositiveInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnegativeInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDfloat, NormalizeValue.dtFloat);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdouble, NormalizeValue.dtDouble);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdateTime, NormalizeValue.dtDateTime);
        dispatch.put((RDFDatatype)XSDDatatype.XSDduration, null);
        dispatch.put((RDFDatatype)XSDDatatype.XSDboolean, NormalizeValue.dtBoolean);
        dispatch.put((RDFDatatype)XSDDatatype.XSDstring, NormalizeValue.dtXSDString);
        dispatch.put(dtPlainLiteral, NormalizeValue.dtPlainLiteral);
    }
}

