/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Bytes;

public class Hex {
    public static int formatUnsignedLongHex(byte[] b, int start, long value, int width) {
        int idx = start + width - 1;
        int w = width;
        long x = value;
        while (w > 0) {
            byte ch;
            int d = (int)(x & 0xFL);
            b[idx] = ch = Bytes.hexDigitsUC[d];
            --w;
            --idx;
            if ((x >>>= 4) != 0L) continue;
            break;
        }
        if (x != 0L) {
            throw new AtlasException("formatUnsignedLongHex: overflow");
        }
        while (w > 0) {
            b[idx] = 48;
            --idx;
            --w;
        }
        return width;
    }

    public static long getLong(byte[] arr, int idx) {
        long x = 0L;
        for (int i = 0; i < 16; ++i) {
            byte c = arr[idx];
            int v = Hex.hexByteToInt(c);
            x = x << 4 | (long)v;
            ++idx;
        }
        return x;
    }

    public static int hexByteToInt(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Bad index char : " + c);
    }

    public static int hexByteToInt(int c, int marker) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        return marker;
    }
}

