/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.impl.TBoxBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public class TuBox
extends TBoxBase {
    private Map<ATermAppl, List<Unfolding>> unfoldingMap;
    private Collection<ATermAppl> termsToNormalize = null;

    public TuBox(TBoxExpImpl tBoxExpImpl) {
        super(tBoxExpImpl);
    }

    @Override
    public boolean addDef(ATermAppl aTermAppl) {
        boolean bl = false;
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        TermDefinition termDefinition = this.getTD((ATerm)aTermAppl2);
        if (termDefinition == null) {
            termDefinition = new TermDefinition();
            this.termhash.put(aTermAppl2, termDefinition);
        }
        if ((bl = termDefinition.addDef(aTermAppl)) && this.termsToNormalize != null) {
            this.termsToNormalize.add(aTermAppl2);
        }
        return bl;
    }

    @Override
    public boolean removeDef(ATermAppl aTermAppl) {
        boolean bl = super.removeDef(aTermAppl);
        if (bl && this.termsToNormalize != null) {
            this.termsToNormalize.add((ATermAppl)aTermAppl.getArgument(0));
        }
        return bl;
    }

    public void updateDef(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        if (ATermUtils.isPrimitive(aTermAppl2)) {
            this.termsToNormalize.add(aTermAppl2);
        }
    }

    public List<Unfolding> unfold(ATermAppl aTermAppl) {
        List<Unfolding> list = this.unfoldingMap.get(aTermAppl);
        return list != null ? list : Collections.emptyList();
    }

    public void normalize() {
        if (this.termsToNormalize == null) {
            this.termsToNormalize = this.termhash.keySet();
            this.unfoldingMap = CollectionUtils.makeIdentityMap();
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Normalizing " + this.termsToNormalize);
        }
        for (ATermAppl aTermAppl : this.termsToNormalize) {
            ATermAppl aTermAppl2;
            Object object;
            TermDefinition termDefinition = (TermDefinition)this.termhash.get(aTermAppl);
            termDefinition.clearDependencies();
            ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl);
            ArrayList<Unfolding> arrayList = new ArrayList<Unfolding>();
            if (!termDefinition.getEqClassAxioms().isEmpty()) {
                ArrayList arrayList2 = new ArrayList();
                for (ATermAppl aTermAppl4 : termDefinition.getEqClassAxioms()) {
                    object = (ATermAppl)aTermAppl4.getArgument(1);
                    aTermAppl2 = this.tbox.getAxiomExplanation(aTermAppl4);
                    ATermAppl aTermAppl5 = ATermUtils.normalize(object);
                    ATermAppl aTermAppl6 = ATermUtils.negate(aTermAppl5);
                    arrayList.add(Unfolding.create(aTermAppl5, (Set<ATermAppl>)aTermAppl2));
                    arrayList2.add(Unfolding.create(aTermAppl6, (Set<ATermAppl>)aTermAppl2));
                }
                this.unfoldingMap.put(aTermAppl3, arrayList2);
            } else {
                this.unfoldingMap.remove(aTermAppl3);
            }
            for (ATermAppl aTermAppl7 : termDefinition.getSubClassAxioms()) {
                ATermAppl aTermAppl4;
                aTermAppl4 = (ATermAppl)aTermAppl7.getArgument(1);
                object = this.tbox.getAxiomExplanation(aTermAppl7);
                aTermAppl2 = ATermUtils.normalize(aTermAppl4);
                arrayList.add(Unfolding.create(aTermAppl2, (Set<ATermAppl>)object));
            }
            if (!arrayList.isEmpty()) {
                this.unfoldingMap.put(aTermAppl, arrayList);
                continue;
            }
            this.unfoldingMap.remove(aTermAppl);
        }
        this.termsToNormalize = new HashSet<ATermAppl>();
        if (PelletOptions.USE_ROLE_ABSORPTION) {
            this.absorbRanges(this.tbox);
        }
    }

    private void absorbRanges(TBoxExpImpl tBoxExpImpl) {
        List<Unfolding> list = this.unfoldingMap.get(ATermUtils.TOP);
        if (list == null) {
            return;
        }
        ArrayList<Unfolding> arrayList = new ArrayList<Unfolding>();
        for (Unfolding unfolding : list) {
            ATermAppl aTermAppl;
            ATerm aTerm;
            ATermAppl aTermAppl2 = unfolding.getResult();
            Set<ATermAppl> set = unfolding.getExplanation();
            if (ATermUtils.isAllValues(aTermAppl2)) {
                aTerm = aTermAppl2.getArgument(0);
                aTermAppl = (ATermAppl)aTermAppl2.getArgument(1);
                this.kb.addRange(aTerm, aTermAppl, set);
                tBoxExpImpl.getAbsorbedAxioms().addAll(set);
                continue;
            }
            if (ATermUtils.isAnd(aTermAppl2)) {
                aTerm = (ATermList)aTermAppl2.getArgument(0);
                aTermAppl = ATermUtils.EMPTY_LIST;
                while (!aTerm.isEmpty()) {
                    ATermAppl aTermAppl3 = (ATermAppl)aTerm.getFirst();
                    if (aTermAppl3.getAFun().equals(ATermUtils.ALLFUN)) {
                        ATerm aTerm2 = aTermAppl3.getArgument(0);
                        ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(1);
                        this.kb.addRange(aTerm2, aTermAppl4, set);
                        tBoxExpImpl.getAbsorbedAxioms().addAll(set);
                    } else {
                        aTermAppl = aTermAppl.insert((ATerm)aTermAppl3);
                    }
                    aTerm = aTerm.getNext();
                }
                if (aTermAppl.isEmpty()) continue;
                arrayList.add(Unfolding.create(ATermUtils.makeAnd((ATermList)aTermAppl), set));
                continue;
            }
            arrayList.add(unfolding);
        }
        if (arrayList.isEmpty()) {
            this.unfoldingMap.remove(ATermUtils.TOP);
        }
    }

    public boolean addIfUnfoldable(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
        TermDefinition termDefinition = this.getTD((ATerm)aTermAppl2);
        if (!ATermUtils.isPrimitive(aTermAppl2)) {
            return false;
        }
        if (termDefinition == null) {
            termDefinition = new TermDefinition();
        }
        if (!termDefinition.isUnique(aTermAppl)) {
            return false;
        }
        Set<ATermAppl> set = ATermUtils.findPrimitives(aTermAppl3);
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        if (!termDefinition.getDependencies().containsAll(set)) {
            for (ATermAppl aTermAppl4 : set) {
                boolean bl = this.findTarget(aTermAppl4, aTermAppl2, hashSet);
                if (!bl) continue;
                return false;
            }
        }
        boolean bl = this.addDef(aTermAppl);
        return bl;
    }

    protected boolean findTarget(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        arrayList.add(aTermAppl);
        while (!arrayList.isEmpty()) {
            this.kb.timers.checkTimer("preprocessing");
            ATermAppl aTermAppl3 = (ATermAppl)arrayList.remove(arrayList.size() - 1);
            if (!set.add(aTermAppl3)) continue;
            if (aTermAppl3.equals(aTermAppl2)) {
                return true;
            }
            TermDefinition termDefinition = this.getTD((ATerm)aTermAppl3);
            if (termDefinition == null) continue;
            if (termDefinition.getDependencies().contains(aTermAppl2)) {
                return true;
            }
            arrayList.addAll(termDefinition.getDependencies());
        }
        return false;
    }

    public void print(Appendable appendable) {
        try {
            appendable.append("Tu: [\n");
            for (ATermAppl aTermAppl : this.unfoldingMap.keySet()) {
                List<Unfolding> list = this.unfold(aTermAppl);
                if (list.isEmpty()) continue;
                appendable.append(ATermUtils.toString(aTermAppl)).append(" -> ");
                for (Unfolding unfolding : list) {
                    appendable.append(ATermUtils.toString(unfolding.getResult())).append(", ");
                }
                appendable.append("\n");
            }
            appendable.append("]\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder);
        return stringBuilder.toString();
    }
}

