/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.pellet.output.ATermBaseRenderer;
import org.mindswap.pellet.utils.ATermUtils;

public class ATermManchesterSyntaxRenderer
extends ATermBaseRenderer {
    public static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();

    @Override
    public void visitAll(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" only ");
        this.visit((ATermAppl)aTermAppl.getArgument(1));
        this.out.print(")");
    }

    @Override
    public void visitAnd(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visitList((ATermList)aTermAppl.getArgument(0), "and");
        this.out.print(")");
    }

    @Override
    public void visitCard(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" exactly " + ((ATermInt)aTermAppl.getArgument(1)).getInt());
        this.out.print(")");
    }

    @Override
    public void visitHasValue(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" value ");
        ATermAppl aTermAppl2 = (ATermAppl)((ATermAppl)aTermAppl.getArgument(1)).getArgument(0);
        if (aTermAppl2.getArity() == 0) {
            this.visitTerm(aTermAppl2);
        } else {
            this.visitLiteral(aTermAppl2);
        }
        this.out.print(")");
    }

    @Override
    public void visitInverse(ATermAppl aTermAppl) {
        this.out.print("inverse ");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
    }

    @Override
    public void visitLiteral(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
        ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(2);
        if (aTermAppl4.equals(XSDInteger.getInstance().getName()) || aTermAppl4.equals(XSDDecimal.getInstance().getName())) {
            this.out.print(aTermAppl2.getName());
        } else if (aTermAppl4.equals(XSDFloat.getInstance().getName())) {
            this.out.print(aTermAppl2.getName());
            this.out.print("f");
        } else if (!aTermAppl4.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this.out.print(aTermAppl2.getName());
            this.out.print("^^");
            this.out.print(aTermAppl4.getName());
        } else {
            this.out.print("\"" + aTermAppl2.getName() + "\"");
            if (!aTermAppl3.equals(ATermUtils.EMPTY)) {
                this.out.print("@" + aTermAppl3);
            }
        }
    }

    @Override
    public void visitMax(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" max " + ((ATermInt)aTermAppl.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)aTermAppl.getArgument(2));
        this.out.print(")");
    }

    @Override
    public void visitMin(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" min " + ((ATermInt)aTermAppl.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)aTermAppl.getArgument(2));
        this.out.print(")");
    }

    @Override
    public void visitNot(ATermAppl aTermAppl) {
        this.out.print("not ");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
    }

    @Override
    public void visitOneOf(ATermAppl aTermAppl) {
        this.out.print("{");
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            this.visit((ATermAppl)aTermAppl2.getArgument(0));
            if ((aTermList = aTermList.getNext()).isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print("}");
    }

    @Override
    public void visitOr(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visitList((ATermList)aTermAppl.getArgument(0), "or");
        this.out.print(")");
    }

    @Override
    public void visitSelf(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" Self)");
    }

    @Override
    public void visitSome(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(" some ");
        this.visit((ATermAppl)aTermAppl.getArgument(1));
        this.out.print(")");
    }

    @Override
    public void visitValue(ATermAppl aTermAppl) {
        this.out.print("(");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print(")");
    }

    public void visitList(ATermList aTermList, String string) {
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
            this.visit(aTermAppl);
            if ((aTermList = aTermList.getNext()).isEmpty()) continue;
            this.out.print(" " + string + " ");
        }
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl aTermAppl) {
        this.out.print("");
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        this.out.print("[");
        ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            this.out.print(FACETS.get(aTermAppl2.getArgument(0)));
            this.out.print(" ");
            this.visit((ATermAppl)aTermAppl2.getArgument(1));
            if ((aTermList = aTermList.getNext()).isEmpty()) continue;
            this.out.print(", ");
        }
        this.out.print("]");
    }

    static {
        FACETS.put(Facet.XSD.LENGTH.getName(), "length");
        FACETS.put(Facet.XSD.MIN_LENGTH.getName(), "minLength");
        FACETS.put(Facet.XSD.MAX_LENGTH.getName(), "maxLength");
        FACETS.put(Facet.XSD.PATTERN.getName(), "pattern");
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), ">=");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), ">");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "<=");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "<");
    }
}

