/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;

public class OptimizedQueryEngine3
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());

    @Override
    public boolean supports(Query query) {
        return true;
    }

    @Override
    public QueryResult execABoxQuery(Query query) {
        QueryResultImpl queryResultImpl = new QueryResultImpl(query);
        KnowledgeBase knowledgeBase = query.getKB();
        long l = knowledgeBase.getABox().stats.satisfiabilityCount;
        long l2 = knowledgeBase.getABox().stats.consistencyCount;
        if (query.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(query)) {
                queryResultImpl.add(new ResultBindingImpl());
            }
        } else {
            int n;
            Iterator iterator;
            ATermAppl aTermAppl;
            HashMap<ATermAppl, Set<ATermAppl>> hashMap = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl object2 : query.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                aTermAppl = query.rollUpTo(object2, Collections.EMPTY_SET, false);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Rolled up class " + aTermAppl);
                }
                hashMap.put(object2, knowledgeBase.getInstances(aTermAppl));
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Var bindings: " + hashMap);
            }
            ArrayList arrayList = new ArrayList(hashMap.keySet());
            HashMap hashMap2 = new HashMap();
            aTermAppl = (ATermAppl)arrayList.get(0);
            HashSet<ResultBindingImpl> hashSet = new HashSet<ResultBindingImpl>();
            for (ATermAppl n2 : (Set)hashMap.get(aTermAppl)) {
                iterator = new ResultBindingImpl();
                iterator.setValue(aTermAppl, n2);
                hashSet.add((ResultBindingImpl)((Object)iterator));
            }
            hashMap2.put(aTermAppl, hashSet);
            HashSet hashSet2 = (Collection)hashMap2.get(aTermAppl);
            for (n = 1; n < arrayList.size(); ++n) {
                iterator = (ATermAppl)arrayList.get(n);
                Object object = new HashSet();
                for (ResultBinding resultBinding : hashSet2) {
                    for (ATermAppl aTermAppl2 : (Set)hashMap.get(iterator)) {
                        ResultBinding resultBinding2 = resultBinding.duplicate();
                        resultBinding2.setValue((ATermAppl)iterator, aTermAppl2);
                        boolean bl = QueryEngine.execBooleanABoxQuery(query.apply(resultBinding2));
                        if (bl) {
                            object.add(resultBinding2);
                            if (!log.isLoggable(Level.FINER)) continue;
                            log.finer("Accepted binding: " + resultBinding2);
                            continue;
                        }
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.finer("Rejected binding: " + resultBinding2);
                    }
                }
                hashSet2 = object;
            }
            int n3 = n = !query.getDistVarsForType(Query.VarType.LITERAL).isEmpty() ? 1 : 0;
            if (n != 0) {
                for (Object object : hashSet2) {
                    LiteralIterator literalIterator = new LiteralIterator(query, (ResultBinding)object);
                    while (literalIterator.hasNext()) {
                        queryResultImpl.add((ResultBinding)literalIterator.next());
                    }
                }
            } else {
                for (Object object : hashSet2) {
                    queryResultImpl.add((ResultBinding)object);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Results: " + queryResultImpl);
                log.fine("Total satisfiability operations: " + (knowledgeBase.getABox().stats.satisfiabilityCount - l));
                log.fine("Total consistency operations: " + (knowledgeBase.getABox().stats.consistencyCount - l2));
            }
        }
        return queryResultImpl;
    }
}

