/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Map;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class JenaUtils {
    public static final Literal XSD_BOOLEAN_TRUE = ResourceFactory.createTypedLiteral((String)Boolean.TRUE.toString(), (RDFDatatype)XSDDatatype.XSDboolean);

    public static ATermAppl makeLiteral(LiteralLabel literalLabel) {
        String string = literalLabel.getLexicalForm();
        String string2 = literalLabel.getDatatypeURI();
        ATermAppl aTermAppl = null;
        aTermAppl = string2 != null ? ATermUtils.makeTypedLiteral(string, string2) : (literalLabel.language() != null ? ATermUtils.makePlainLiteral(string, literalLabel.language()) : ATermUtils.makePlainLiteral(string));
        return aTermAppl;
    }

    public static ATermAppl makeATerm(RDFNode rDFNode) {
        return JenaUtils.makeATerm(rDFNode.asNode());
    }

    public static ATermAppl makeATerm(Node node) {
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isBlank()) {
            return ATermUtils.makeBnode(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)OWL2.topDataProperty.asNode())) {
                return ATermUtils.TOP_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomDataProperty.asNode())) {
                return ATermUtils.BOTTOM_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.topObjectProperty.asNode())) {
                return ATermUtils.TOP_OBJECT_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomObjectProperty.asNode())) {
                return ATermUtils.BOTTOM_OBJECT_PROPERTY;
            }
            return ATermUtils.makeTermAppl(node.getURI());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar(node.getName());
        }
        return null;
    }

    public static Node makeGraphLiteral(ATermAppl aTermAppl) {
        Node node;
        String string = ((ATermAppl)aTermAppl.getArgument(0)).getName();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(2);
        if (aTermAppl3.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            node = aTermAppl2.equals(ATermUtils.EMPTY) ? Node.createLiteral((String)string) : Node.createLiteral((String)string, (String)aTermAppl2.getName(), (boolean)false);
        } else if (aTermAppl3.equals(Datatypes.XML_LITERAL)) {
            node = Node.createLiteral((String)string, (String)"", (boolean)true);
        } else {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(aTermAppl3.getName());
            node = Node.createLiteral((String)string, (String)"", (RDFDatatype)rDFDatatype);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl aTermAppl) {
        if (ATermUtils.isBnode(aTermAppl)) {
            return Node.createAnon((AnonId)new AnonId(((ATermAppl)aTermAppl.getArgument(0)).getName()));
        }
        if (aTermAppl.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (aTermAppl.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (aTermAppl.equals(ATermUtils.TOP_DATA_PROPERTY)) {
            return OWL2.topDataProperty.asNode();
        }
        if (aTermAppl.equals(ATermUtils.BOTTOM_DATA_PROPERTY)) {
            return OWL2.bottomDataProperty.asNode();
        }
        if (aTermAppl.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            return OWL2.topObjectProperty.asNode();
        }
        if (aTermAppl.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            return OWL2.bottomObjectProperty.asNode();
        }
        if (aTermAppl.getArity() == 0) {
            return Node.createURI((String)aTermAppl.getName());
        }
        throw new InternalReasonerException("Invalid term found " + aTermAppl);
    }

    public static Node makeGraphNode(ATermAppl aTermAppl) {
        if (ATermUtils.isLiteral(aTermAppl)) {
            return JenaUtils.makeGraphLiteral(aTermAppl);
        }
        return JenaUtils.makeGraphResource(aTermAppl);
    }

    public static Literal makeLiteral(ATermAppl aTermAppl, Model model) {
        return (Literal)model.asRDFNode(JenaUtils.makeGraphLiteral(aTermAppl));
    }

    public static Resource makeResource(ATermAppl aTermAppl, Model model) {
        return (Resource)model.asRDFNode(JenaUtils.makeGraphResource(aTermAppl));
    }

    public static RDFNode makeRDFNode(ATermAppl aTermAppl, Model model) {
        return model.asRDFNode(JenaUtils.makeGraphNode(aTermAppl));
    }

    public static QNameProvider makeQNameProvider(PrefixMapping prefixMapping) {
        QNameProvider qNameProvider = new QNameProvider();
        for (Map.Entry entry : prefixMapping.getNsPrefixMap().entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            qNameProvider.setMapping(string, string2);
        }
        return qNameProvider;
    }
}

