/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public class RestrictedURIDatatype
implements RestrictedDatatype<ATermAppl> {
    private final Datatype<ATermAppl> dt;
    private final Set<Object> excludedValues;

    public RestrictedURIDatatype(Datatype<ATermAppl> datatype) {
        this(datatype, Collections.emptySet());
    }

    private RestrictedURIDatatype(Datatype<ATermAppl> datatype, Set<Object> set) {
        this.dt = datatype;
        this.excludedValues = set;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl aTermAppl, Object object) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof ATermAppl) {
            ATermAppl aTermAppl = (ATermAppl)object;
            if (this.excludedValues.contains(aTermAppl)) {
                return false;
            }
            if (ATermUtils.isLiteral(aTermAppl) && XSDAnyURI.NAME.equals(aTermAppl.getArgument(2))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> collection) {
        HashSet<Object> hashSet = new HashSet<Object>(collection);
        hashSet.addAll(this.excludedValues);
        return new RestrictedURIDatatype(this.dt, hashSet);
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this.dt;
    }

    @Override
    public ATermAppl getValue(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

