/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import com.hp.hpl.jena.sparql.util.Timer;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

public class CmdTokens {
    public static void tokens(boolean print, boolean timing, String ... args) {
        String arg;
        if (args.length == 0) {
            args = new String[]{"-"};
        }
        if ((arg = args[0]).equals("--help") || arg.equals("-help") || arg.equals("-h") || arg.equals("--h")) {
            System.err.println("Usage: stdin | FILE ...");
            System.exit(1);
        }
        for (String filename : args) {
            InputStream in = IO.openFile(args[0]);
            Tokenizer tokenize = TokenizerFactory.makeTokenizerUTF8(in);
            Timer timer = new Timer();
            long count = 0L;
            timer.startTimer();
            while (tokenize.hasNext()) {
                Token t = tokenize.next();
                if (print) {
                    System.out.println(t);
                }
                ++count;
            }
            tokenize.close();
            long millis = timer.endTimer();
            if (!timing) continue;
            if (millis == 0L) {
                System.out.printf("Tokens=%,d : Time=0.00s\n", count);
                continue;
            }
            double seconds = (double)millis / 1000.0;
            System.out.printf("Tokens=%,d : Time=%,.2fs : Rate=%,.2f\n", count, seconds, (double)count / seconds);
        }
    }
}

