/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPVersionIRIHandler
extends TriplePredicateHandler {
    public TPVersionIRIHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        OWLOntology ontology = this.getConsumer().getOntology();
        if (ontology != null && ontology.getOntologyID().getVersionIRI() == null) {
            IRI ontologyIRI = ontology.getOntologyID().getOntologyIRI();
            IRI versionIRI = object;
            if (ontologyIRI == null && !this.isAnonymous(subject)) {
                ontologyIRI = subject;
            }
            OWLOntologyID ontologyID = new OWLOntologyID(ontologyIRI, versionIRI);
            this.getConsumer().setOntologyID(ontologyID);
        }
        this.consumeTriple(subject, predicate, object);
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    @Override
    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        return predicate.equals(OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
    }
}

