/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tableau.cache.AbstractConceptCache;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CacheSafetyFactory;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.utils.ATermUtils;

public class ConceptCacheLRU
extends AbstractConceptCache
implements ConceptCache {
    private Map<ATermAppl, CachedNode> primitive;
    private LinkedHashMap<ATermAppl, CachedNode> nonPrimitive;
    private CacheSafety cacheSafety;

    public ConceptCacheLRU(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, Integer.MAX_VALUE);
    }

    public ConceptCacheLRU(KnowledgeBase knowledgeBase, int n) {
        super(n);
        this.cacheSafety = CacheSafetyFactory.createCacheSafety(knowledgeBase.getExpressivity());
        this.primitive = new HashMap<ATermAppl, CachedNode>();
        this.nonPrimitive = new LinkedHashMap<ATermAppl, CachedNode>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ATermAppl, CachedNode> entry) {
                return ConceptCacheLRU.this.nonPrimitive.size() > ConceptCacheLRU.this.getMaxSize();
            }
        };
    }

    @Override
    public CacheSafety getSafety() {
        return this.cacheSafety;
    }

    @Override
    public void clear() {
        this.primitive.clear();
        this.nonPrimitive.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.primitive.containsKey(object) || this.nonPrimitive.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.primitive.containsValue(object) || this.nonPrimitive.containsValue(object);
    }

    @Override
    public Set<Map.Entry<ATermAppl, CachedNode>> entrySet() {
        HashSet<Map.Entry<ATermAppl, CachedNode>> hashSet = new HashSet<Map.Entry<ATermAppl, CachedNode>>(this.primitive.entrySet());
        hashSet.addAll(this.nonPrimitive.entrySet());
        return hashSet;
    }

    @Override
    public CachedNode get(Object object) {
        if (this.primitive.containsKey(object)) {
            return this.primitive.get(object);
        }
        return this.nonPrimitive.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.primitive.isEmpty() && this.nonPrimitive.isEmpty();
    }

    @Override
    public Set<ATermAppl> keySet() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(this.primitive.keySet());
        hashSet.addAll(this.nonPrimitive.keySet());
        return hashSet;
    }

    @Override
    public CachedNode put(ATermAppl aTermAppl, CachedNode cachedNode) {
        if (ATermUtils.isPrimitiveOrNegated(aTermAppl)) {
            CachedNode cachedNode2 = this.primitive.put(aTermAppl, cachedNode);
            if (this.isFull()) {
                this.nonPrimitive.entrySet();
            }
            return cachedNode2;
        }
        return this.nonPrimitive.put(aTermAppl, cachedNode);
    }

    @Override
    public void putAll(Map<? extends ATermAppl, ? extends CachedNode> map) {
        for (Map.Entry<? extends ATermAppl, ? extends CachedNode> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public CachedNode remove(Object object) {
        if (this.primitive.containsKey(object)) {
            return this.primitive.remove(object);
        }
        return (CachedNode)this.nonPrimitive.remove(object);
    }

    @Override
    public int size() {
        return this.primitive.size() + this.nonPrimitive.size();
    }

    @Override
    public Collection<CachedNode> values() {
        HashSet<CachedNode> hashSet = new HashSet<CachedNode>(this.primitive.values());
        hashSet.addAll(this.nonPrimitive.values());
        return hashSet;
    }

    public String toString() {
        return "[Cache size: " + this.primitive.size() + "," + this.nonPrimitive.size() + "]";
    }
}

