/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.RuleBasedELClassifier;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import com.clarkparsia.pellet.rules.rete.Rule;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

public class ReteBasedELClassifier
extends RuleBasedELClassifier
implements TaxonomyBuilder {
    private static final String PREDICATE_PREFIX = "";
    private static final ATermAppl PRED_SUB = ATermUtils.makeTermAppl("subclassOf");
    private static final ATermAppl PRED_SUB_SOME = ATermUtils.makeTermAppl("subclassOfSomeOf");
    private static final ATermAppl TOP = ATermUtils.TOP;
    private static final ATermAppl BOTTOM = ATermUtils.BOTTOM;
    private ConstantStore m_Names = new ConstantStore();
    private VariableStore m_Variables = new VariableStore();
    private List<Rule> m_Rules = CollectionUtils.makeList();
    private List<Fact> m_Facts = CollectionUtils.makeList();

    public ReteBasedELClassifier() {
        this.makeRuleAxioms();
    }

    @Override
    protected MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> collection) {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        Interpreter interpreter = new Interpreter(knowledgeBase.getABox());
        for (Rule multiValueMap2 : this.m_Rules) {
            interpreter.rete.compile(multiValueMap2, null);
        }
        this.addClasses(interpreter, collection);
        this.addClasses(interpreter, this.m_Names.getAllAnons());
        for (Fact fact : this.m_Facts) {
            interpreter.addFact(fact);
        }
        this.m_Facts = null;
        this.m_Names.reset();
        Set<Fact> set = interpreter.run();
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = this.getSubsumers(set);
        for (ATermAppl aTermAppl : collection) {
            multiValueMap.add(aTermAppl, aTermAppl);
            multiValueMap.add(aTermAppl, ATermUtils.TOP);
        }
        return multiValueMap;
    }

    protected MultiValueMap<ATermAppl, ATermAppl> getSubsumers(Set<Fact> set) {
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = new MultiValueMap<ATermAppl, ATermAppl>();
        for (Fact fact : set) {
            if (!((ATermAppl)fact.getElements().get(0)).equals(PRED_SUB)) continue;
            List list = fact.getElements();
            ATermAppl aTermAppl = (ATermAppl)list.get(1);
            ATermAppl aTermAppl2 = (ATermAppl)list.get(2);
            if (ConstantStore.isAnon(aTermAppl) || ConstantStore.isAnon(aTermAppl2)) continue;
            multiValueMap.add(aTermAppl, aTermAppl2);
        }
        return multiValueMap;
    }

    protected void addClasses(Interpreter interpreter, Collection<ATermAppl> collection) {
        for (ATermAppl aTermAppl : collection) {
            interpreter.addFact(this.makeSubclassFact(aTermAppl, aTermAppl));
            interpreter.addFact(this.makeSubclassFact(aTermAppl, TOP));
        }
    }

    @Override
    protected void addSubclassRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addSubclassRule(aTermAppl, aTermAppl2, new FreeVariableStore());
    }

    @Override
    protected void addRoleDomainRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        List<TermTuple> list = CollectionUtils.makeList();
        List<TermTuple> list2 = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        ATermAppl aTermAppl3 = freeVariableStore.next();
        ATermAppl aTermAppl4 = freeVariableStore.next();
        list.add(this.makeSubOfSomeTuple(aTermAppl3, aTermAppl, aTermAppl4));
        this.translateSuper(list2, aTermAppl2, freeVariableStore, aTermAppl3);
        this.m_Rules.add(new Rule(list, list2));
    }

    @Override
    protected void addRoleRangeRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        List<TermTuple> list = CollectionUtils.makeList();
        List<TermTuple> list2 = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        ATermAppl aTermAppl3 = freeVariableStore.next();
        ATermAppl aTermAppl4 = freeVariableStore.next();
        list.add(this.makeSubOfSomeTuple(aTermAppl3, aTermAppl, aTermAppl4));
        ATermAppl aTermAppl5 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
        this.translateSuper(list2, aTermAppl5, freeVariableStore, aTermAppl3);
        this.m_Rules.add(new Rule(list, list2));
    }

    @Override
    protected void addRoleChainRule(ATerm[] aTermArray, ATermAppl aTermAppl) {
        if (aTermArray.length < 1) {
            return;
        }
        List<TermTuple> list = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        ATermAppl[] aTermApplArray = new ATermAppl[aTermArray.length + 1];
        aTermApplArray[0] = freeVariableStore.next();
        for (int i = 0; i < aTermArray.length; ++i) {
            aTermApplArray[i + 1] = freeVariableStore.next();
            list.add(this.makeSubOfSomeTuple(aTermApplArray[i], (ATermAppl)aTermArray[i], aTermApplArray[i + 1]));
        }
        TermTuple termTuple = this.makeSubOfSomeTuple(aTermApplArray[0], aTermAppl, aTermApplArray[aTermApplArray.length - 1]);
        this.m_Rules.add(new Rule(list, Collections.singletonList(termTuple)));
    }

    @Override
    protected void addRoleHierarchyRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addRoleChainRule(new ATerm[]{aTermAppl}, aTermAppl2);
    }

    private void makeRuleAxioms() {
        this.makeBottomAxiom();
    }

    private void makeBottomAxiom() {
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        ATermAppl aTermAppl = freeVariableStore.next();
        ATermAppl aTermAppl2 = freeVariableStore.next();
        ATermAppl aTermAppl3 = freeVariableStore.next();
        List<TermTuple> list = CollectionUtils.makeList();
        list.add(this.makeSubOfSomeTuple(aTermAppl, aTermAppl2, aTermAppl3));
        list.add(this.makeSubclassTuple(aTermAppl3, BOTTOM));
        TermTuple termTuple = this.makeSubclassTuple(aTermAppl, BOTTOM);
        this.m_Rules.add(new Rule(list, Collections.singletonList(termTuple)));
    }

    private void addSubclassRule(ATermAppl aTermAppl, ATermAppl aTermAppl2, FreeVariableStore freeVariableStore) {
        List<TermTuple> list = CollectionUtils.makeList();
        List<TermTuple> list2 = CollectionUtils.makeList();
        ATermAppl aTermAppl3 = freeVariableStore.next();
        this.translateSub(list, aTermAppl, freeVariableStore, aTermAppl3);
        this.translateSuper(list2, aTermAppl2, freeVariableStore, aTermAppl3);
        this.m_Rules.add(new Rule(list, list2));
    }

    private void translateSub(List<TermTuple> list, ATermAppl aTermAppl, FreeVariableStore freeVariableStore, ATermAppl aTermAppl2) {
        AFun aFun = aTermAppl.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl)) {
            list.add(this.makeSubclassTuple(aTermAppl2, aTermAppl));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                this.translateSub(list, aTermAppl3, freeVariableStore, aTermAppl2);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl6 = freeVariableStore.next();
            list.add(this.makeSubOfSomeTuple(aTermAppl2, aTermAppl4, aTermAppl6));
            this.translateSub(list, aTermAppl5, freeVariableStore, aTermAppl6);
        } else assert (false);
    }

    private void translateSuper(List<TermTuple> list, ATermAppl aTermAppl, FreeVariableStore freeVariableStore, ATermAppl aTermAppl2) {
        AFun aFun = aTermAppl.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl)) {
            list.add(this.makeSubclassTuple(aTermAppl2, aTermAppl));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                this.translateSuper(list, aTermAppl3, freeVariableStore, aTermAppl2);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(1);
            if (!ATermUtils.isPrimitive(aTermAppl5) && !ATermUtils.isBottom(aTermAppl5)) {
                ATermAppl aTermAppl6 = this.m_Names.getNextAnon();
                this.translateSuperSome(aTermAppl6, aTermAppl5);
                aTermAppl5 = aTermAppl6;
            }
            list.add(this.makeSubOfSomeTuple(aTermAppl2, aTermAppl4, aTermAppl5));
        } else assert (false);
    }

    private void translateSuperSome(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        AFun aFun = aTermAppl2.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl2) || ATermUtils.isBottom(aTermAppl2)) {
            this.m_Facts.add(this.makeSubclassFact(aTermAppl, aTermAppl2));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                this.translateSuperSome(aTermAppl, aTermAppl3);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getArgument(0);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl2.getArgument(1);
            if (!ATermUtils.isPrimitive(aTermAppl5) && !ATermUtils.isBottom(aTermAppl5)) {
                ATermAppl aTermAppl6 = this.m_Names.getNextAnon();
                this.translateSuperSome(aTermAppl6, aTermAppl5);
                aTermAppl5 = aTermAppl6;
            }
            this.m_Facts.add(this.makeSubOfSomeFact(aTermAppl, aTermAppl4, aTermAppl5));
        } else assert (false);
    }

    private Fact makeSubclassFact(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return new Fact(DependencySet.INDEPENDENT, PRED_SUB, aTermAppl, aTermAppl2);
    }

    private Fact makeSubOfSomeFact(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        return new Fact(DependencySet.INDEPENDENT, PRED_SUB_SOME, aTermAppl, aTermAppl2, aTermAppl3);
    }

    private TermTuple makeSubclassTuple(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return new TermTuple(DependencySet.INDEPENDENT, PRED_SUB, aTermAppl, aTermAppl2);
    }

    private TermTuple makeSubOfSomeTuple(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        return new TermTuple(DependencySet.INDEPENDENT, PRED_SUB_SOME, aTermAppl, aTermAppl2, aTermAppl3);
    }

    class FreeVariableStore {
        private int m_Next = 0;

        FreeVariableStore() {
        }

        protected ATermAppl next() {
            return ReteBasedELClassifier.this.m_Variables.get(this.m_Next++);
        }
    }

    static class VariableStore {
        private static final String PREFIX = "x";
        private List<ATermAppl> m_Variables = CollectionUtils.makeList();

        VariableStore() {
        }

        protected ATermAppl get(int n) {
            for (int i = this.m_Variables.size(); i <= n; ++i) {
                this.m_Variables.add(ATermUtils.makeVar(PREFIX + i));
            }
            return this.m_Variables.get(n);
        }
    }

    static class ConstantStore {
        private static final String ANON = "tag:clarkparsia.com,2008:pellet:el:anon:";
        private static final int FIRST_ANON = 0;
        private Map<ATermAppl, ATermAppl> m_Constants = CollectionUtils.makeMap();
        private int m_NextAnon = 0;

        ConstantStore() {
        }

        public void reset() {
            this.m_Constants = CollectionUtils.makeMap();
            this.m_NextAnon = 0;
        }

        protected ATermAppl get(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2 = this.m_Constants.get(aTermAppl);
            if (aTermAppl2 == null) {
                aTermAppl2 = aTermAppl;
                this.m_Constants.put(aTermAppl, aTermAppl2);
            }
            return aTermAppl2;
        }

        protected ATermAppl getNextAnon() {
            return ConstantStore.makeAnon(this.m_NextAnon++);
        }

        protected Set<ATermAppl> getAllAnons() {
            Set<ATermAppl> set = CollectionUtils.makeSet();
            for (int i = 0; i < this.m_NextAnon; ++i) {
                set.add(ConstantStore.makeAnon(i));
            }
            return set;
        }

        protected static boolean isAnon(ATermAppl aTermAppl) {
            return aTermAppl.getName().startsWith(ANON);
        }

        private static ATermAppl makeAnon(int n) {
            return ATermUtils.makeTermAppl(ANON + n);
        }
    }
}

