/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class WeakIndexCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 30402L;
    protected transient WeakHashMap<K, WeakReference<V>> prefixCache = new WeakHashMap();

    public V cache(K s, V v) {
        Object toReturn;
        WeakReference<V> w = this.prefixCache.get(s);
        if (w != null && (toReturn = w.get()) != null) {
            return (V)toReturn;
        }
        this.prefixCache.put(s, new WeakReference<V>(v));
        return v;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prefixCache = new WeakHashMap();
    }

    public V get(K k) {
        WeakReference<V> w = this.prefixCache.get(k);
        if (w != null) {
            Object toReturn = w.get();
            return (V)toReturn;
        }
        return null;
    }

    public boolean contains(K k) {
        Object toReturn;
        WeakReference<V> w = this.prefixCache.get(k);
        return w != null && (toReturn = w.get()) != null;
    }

    public void clear() {
        this.prefixCache.clear();
    }
}

