/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.Timer;

public class Timers {
    private Map<String, Timer> timers = new LinkedHashMap<String, Timer>();
    public final Timer mainTimer = this.createTimer("main");

    public Timers() {
        this.mainTimer.start();
    }

    public void addAll(Timers timers) {
        for (Map.Entry<String, Timer> entry : timers.timers.entrySet()) {
            String string = entry.getKey();
            Timer timer = entry.getValue();
            Timer timer2 = this.getTimer(string);
            if (timer2 == null) {
                this.timers.put(string, timer);
                continue;
            }
            timer2.add(timer);
        }
    }

    public Timer createTimer(String string) {
        Timer timer = new Timer(string, this.mainTimer);
        this.timers.put(string, timer);
        return timer;
    }

    public Timer startTimer(String string) {
        Timer timer = this.getTimer(string);
        if (timer == null) {
            timer = this.createTimer(string);
        }
        timer.start();
        return timer;
    }

    public void checkTimer(String string) {
        Timer timer = this.getTimer(string);
        if (timer == null) {
            throw new UnsupportedOperationException("Timer " + string + " does not exist!");
        }
        timer.check();
    }

    public void resetTimer(String string) {
        Timer timer = this.getTimer(string);
        if (timer == null) {
            throw new UnsupportedOperationException("Timer " + string + " does not exist!");
        }
        timer.reset();
    }

    public void interrupt() {
        this.mainTimer.interrupt();
    }

    public void setTimeout(String string, long l) {
        Timer timer = this.getTimer(string);
        if (timer == null) {
            timer = this.createTimer(string);
        }
        timer.setTimeout(l);
    }

    public void stopTimer(String string) {
        Timer timer = this.getTimer(string);
        if (timer == null) {
            throw new UnsupportedOperationException("Timer " + string + " does not exist!");
        }
        timer.stop();
    }

    public void resetAll() {
        for (Timer timer : this.timers.values()) {
            timer.reset();
        }
        this.mainTimer.start();
    }

    public long getTimerTotal(String string) {
        Timer timer = this.getTimer(string);
        return timer == null ? 0L : timer.getTotal();
    }

    public double getTimerAverage(String string) {
        Timer timer = this.getTimer(string);
        return timer == null ? 0.0 : timer.getAverage();
    }

    public Timer getTimer(String string) {
        return this.timers.get(string);
    }

    public Collection<Timer> getTimers() {
        return this.timers.values();
    }

    public void print() {
        this.print(false);
    }

    public void print(Writer writer) {
        this.print(writer, false, "Total");
    }

    public void print(boolean bl) {
        this.print(bl, "Total");
    }

    public void print(boolean bl, String string) {
        this.print(new PrintWriter(System.out), bl, string);
    }

    public void print(Writer writer, boolean bl, final String string) {
        boolean[] blArray;
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Name";
            stringArray = stringArray2;
            stringArray2[1] = "Total (ms)";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "Name";
            stringArray3[1] = "Count";
            stringArray3[2] = "Avg";
            stringArray = stringArray3;
            stringArray3[3] = "Total (ms)";
        }
        String[] stringArray4 = stringArray;
        if (bl) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[4];
            blArray3[0] = false;
            blArray3[1] = true;
            blArray3[2] = true;
            blArray = blArray3;
            blArray3[3] = true;
        }
        boolean[] blArray4 = blArray;
        ArrayList<Timer> arrayList = new ArrayList<Timer>(this.timers.values());
        if (string != null) {
            Collections.sort(arrayList, new Comparator<Timer>(){

                @Override
                public int compare(Timer timer, Timer timer2) {
                    if (string.equalsIgnoreCase("Total")) {
                        long l = timer.getTotal();
                        long l2 = timer2.getTotal();
                        if (l == 0L) {
                            l = timer.getElapsed();
                        }
                        if (l2 == 0L) {
                            l2 = timer2.getElapsed();
                        }
                        return (int)(l2 - l);
                    }
                    if (string.equalsIgnoreCase("Avg")) {
                        return (int)(timer2.getAverage() - timer.getAverage());
                    }
                    if (string.equalsIgnoreCase("Count")) {
                        return (int)(timer2.getCount() - timer.getCount());
                    }
                    return AlphaNumericComparator.CASE_INSENSITIVE.compare(timer, timer2);
                }
            });
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        TableData tableData = new TableData(Arrays.asList(stringArray4));
        tableData.setAlignment(blArray4);
        for (Timer timer : arrayList) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(timer.getName());
            if (!bl) {
                arrayList2.add(String.valueOf(timer.getCount()));
                arrayList2.add(decimalFormat.format(timer.getAverage()));
            }
            if (timer.isStarted()) {
                arrayList2.add(String.valueOf(timer.getElapsed()));
            } else {
                arrayList2.add(String.valueOf(timer.getTotal()));
            }
            tableData.add(arrayList2);
        }
        tableData.print(writer);
    }

    public String toString() {
        return this.timers.values().toString();
    }
}

