/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.tableau.blocking.BlockingFactory;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.GuessBranch;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tableau.completion.rule.AllValuesRule;
import org.mindswap.pellet.tableau.completion.rule.ChooseRule;
import org.mindswap.pellet.tableau.completion.rule.DataCardinalityRule;
import org.mindswap.pellet.tableau.completion.rule.DataSatisfiabilityRule;
import org.mindswap.pellet.tableau.completion.rule.DisjunctionRule;
import org.mindswap.pellet.tableau.completion.rule.GuessRule;
import org.mindswap.pellet.tableau.completion.rule.MaxRule;
import org.mindswap.pellet.tableau.completion.rule.MinRule;
import org.mindswap.pellet.tableau.completion.rule.NominalRule;
import org.mindswap.pellet.tableau.completion.rule.SelfRule;
import org.mindswap.pellet.tableau.completion.rule.SimpleAllValuesRule;
import org.mindswap.pellet.tableau.completion.rule.SomeValuesRule;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;
import org.mindswap.pellet.tableau.completion.rule.UnfoldingRule;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class CompletionStrategy {
    public static final Logger log = Logger.getLogger(CompletionStrategy.class.getName());
    protected ABox abox;
    protected TBox tbox;
    protected Blocking blocking;
    protected Timers timers;
    protected Timer completionTimer;
    private boolean merging = false;
    private boolean mergingAll = false;
    protected List<NodeMerge> mergeList;
    protected TableauRule unfoldingRule = new UnfoldingRule(this);
    protected TableauRule disjunctionRule = new DisjunctionRule(this);
    protected AllValuesRule allValuesRule = new AllValuesRule(this);
    protected TableauRule someValuesRule = new SomeValuesRule(this);
    protected TableauRule chooseRule = new ChooseRule(this);
    protected TableauRule minRule = new MinRule(this);
    protected MaxRule maxRule = new MaxRule(this);
    protected TableauRule selfRule = new SelfRule(this);
    protected TableauRule nominalRule = new NominalRule(this);
    protected TableauRule guessRule = new GuessRule(this);
    protected TableauRule dataSatRule = new DataSatisfiabilityRule(this);
    protected TableauRule dataCardRule = new DataCardinalityRule(this);
    protected List<TableauRule> tableauRules;

    public CompletionStrategy(ABox aBox) {
        this.abox = aBox;
        this.tbox = aBox.getTBox();
        this.timers = aBox.getKB().timers;
        this.completionTimer = this.timers.getTimer("complete");
    }

    public ABox getABox() {
        return this.abox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public Blocking getBlocking() {
        return this.blocking;
    }

    public void checkTimer() {
        this.completionTimer.check();
    }

    public Iterator<Individual> getInitializeIterator() {
        return new IndividualIterator(this.abox);
    }

    protected void configureTableauRules(Expressivity expressivity) {
        if (!PelletOptions.USE_COMPLETION_STRATEGY) {
            this.addAllRules();
            return;
        }
        boolean bl = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasUserDefinedDatatype() || expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.tableauRules = new ArrayList<TableauRule>();
        if (!PelletOptions.USE_PSEUDO_NOMINALS && expressivity.hasNominal() || this.implicitNominals()) {
            this.tableauRules.add(this.nominalRule);
            if (expressivity.hasCardinalityQ()) {
                this.tableauRules.add(this.guessRule);
            }
        }
        if (expressivity.hasCardinalityQ() || expressivity.hasCardinalityD()) {
            this.tableauRules.add(this.chooseRule);
        }
        this.tableauRules.add(this.maxRule);
        if (bl) {
            this.tableauRules.add(this.dataCardRule);
        }
        this.tableauRules.add(this.dataSatRule);
        this.tableauRules.add(this.unfoldingRule);
        this.tableauRules.add(this.disjunctionRule);
        this.tableauRules.add(this.someValuesRule);
        this.tableauRules.add(this.minRule);
        this.allValuesRule = expressivity.hasComplexSubRoles() ? new AllValuesRule(this) : new SimpleAllValuesRule(this);
    }

    protected void addAllRules() {
        this.tableauRules = new ArrayList<TableauRule>();
        this.tableauRules.add(this.nominalRule);
        this.tableauRules.add(this.guessRule);
        this.tableauRules.add(this.chooseRule);
        this.tableauRules.add(this.maxRule);
        this.tableauRules.add(this.dataCardRule);
        this.tableauRules.add(this.dataSatRule);
        this.tableauRules.add(this.unfoldingRule);
        this.tableauRules.add(this.disjunctionRule);
        this.tableauRules.add(this.someValuesRule);
        this.tableauRules.add(this.minRule);
        this.allValuesRule = new AllValuesRule(this);
    }

    protected boolean implicitNominals() {
        Collection<Rule> collection = this.abox.getKB().getNormalizedRules().values();
        for (Rule rule : collection) {
            if (rule == null) continue;
            for (RuleAtom ruleAtom : rule.getBody()) {
                if (!(ruleAtom instanceof DifferentIndividualsAtom)) continue;
                return true;
            }
            for (RuleAtom ruleAtom : rule.getHead()) {
                if (!(ruleAtom instanceof SameIndividualAtom)) continue;
                return true;
            }
        }
        return false;
    }

    public void initialize(Expressivity expressivity) {
        Object object;
        this.mergeList = new ArrayList<NodeMerge>();
        this.blocking = BlockingFactory.createBlocking(expressivity);
        this.configureTableauRules(expressivity);
        for (Branch object22 : this.abox.getBranches()) {
            object22.setStrategy(this);
        }
        if (this.abox.isInitialized()) {
            object = this.getInitializeIterator();
            block1: while (object.hasNext()) {
                Individual individual = (Individual)object.next();
                if (individual.isMerged()) continue;
                if (individual.isConceptRoot()) {
                    this.applyUniversalRestrictions(individual);
                }
                this.allValuesRule.apply(individual);
                if (individual.isMerged()) continue;
                this.nominalRule.apply(individual);
                if (individual.isMerged()) continue;
                this.selfRule.apply(individual);
                EdgeList edgeList = individual.getOutEdges();
                for (int i = 0; i < edgeList.size(); ++i) {
                    Edge edge = edgeList.edgeAt(i);
                    if (edge.getTo().isPruned()) continue;
                    this.applyPropertyRestrictions(edge);
                    if (individual.isMerged()) continue block1;
                }
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize started");
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.getToBeMerged());
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        object = this.abox.getRole((ATerm)TermFactory.TOP_OBJECT_PROPERTY);
        Iterator<Individual> iterator = this.getInitializeIterator();
        while (iterator.hasNext()) {
            Individual individual = iterator.next();
            if (individual.isMerged()) continue;
            this.applyUniversalRestrictions(individual);
            if (individual.isMerged()) continue;
            this.selfRule.apply(individual);
            if (individual.isMerged()) continue;
            EdgeList edgeList = individual.getOutEdges();
            for (int i = 0; i < edgeList.size(); ++i) {
                Edge edge = edgeList.edgeAt(i);
                if (edge.getTo().isPruned()) continue;
                this.applyPropertyRestrictions(edge);
                if (individual.isMerged()) break;
            }
            if (individual.isMerged()) continue;
            this.applyPropertyRestrictions(individual, (Role)object, individual, DependencySet.INDEPENDENT);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Merging: " + this.mergeList);
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize finished");
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        this.abox.stats.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    public abstract void complete(Expressivity var1);

    public Individual createFreshIndividual(Individual individual, DependencySet dependencySet) {
        Individual individual2 = this.abox.addFreshIndividual(individual, dependencySet);
        this.applyUniversalRestrictions(individual2);
        return individual2;
    }

    void applyUniversalRestrictions(Individual individual) {
        this.addType(individual, ATermUtils.TOP, DependencySet.INDEPENDENT);
        Set<Role> set = this.abox.getKB().getRBox().getReflexiveRoles();
        for (Role iterator : set) {
            if (log.isLoggable(Level.FINE) && !individual.hasRNeighbor(iterator, individual)) {
                log.fine("REF : " + individual + " " + iterator);
            }
            this.addEdge(individual, iterator, individual, iterator.getExplainReflexive());
            if (!individual.isMerged()) continue;
            return;
        }
        Role role = this.abox.getKB().getRole((ATerm)ATermUtils.TOP_OBJECT_PROPERTY);
        for (ATermAppl aTermAppl : role.getDomains()) {
            this.addType(individual, aTermAppl, role.getExplainDomain(aTermAppl));
            if (!individual.isMerged()) continue;
        }
        for (ATermAppl aTermAppl : role.getRanges()) {
            this.addType(individual, aTermAppl, role.getExplainRange(aTermAppl));
            if (!individual.isMerged()) continue;
        }
    }

    public void addType(Node node, ATermAppl aTermAppl, DependencySet dependencySet) {
        Literal literal;
        Object object;
        if (this.abox.isClosed()) {
            return;
        }
        node.addType(aTermAppl, dependencySet);
        if (node.isLiteral() && (object = (literal = (Literal)node).getMergeToConstant()) != null) {
            literal.clearMergeToConstant();
            Literal literal2 = this.abox.getLiteral((ATerm)((NodeMerge)object).getTarget());
            this.mergeTo(literal, literal2, ((NodeMerge)object).getDepends());
            node = literal2;
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addTypeDependency(node.getName(), aTermAppl, dependencySet);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("ADD: " + node + " " + aTermAppl + " - " + dependencySet + " " + dependencySet.getExplain());
        }
        if (aTermAppl.getAFun().equals(ATermUtils.ANDFUN)) {
            literal = (ATermList)aTermAppl.getArgument(0);
            while (!literal.isEmpty()) {
                object = (ATermAppl)literal.getFirst();
                this.addType(node, (ATermAppl)object, dependencySet);
                node = node.getSame();
                literal = literal.getNext();
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.ALLFUN)) {
            this.allValuesRule.applyAllValues((Individual)node, aTermAppl, dependencySet);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SELFFUN)) {
            literal = (ATermAppl)aTermAppl.getArgument(0);
            object = this.abox.getRole((ATerm)literal);
            if (log.isLoggable(Level.FINE) && !((Individual)node).hasRSuccessor((Role)object, node)) {
                log.fine("SELF: " + node + " " + object + " " + node.getDepends((ATerm)aTermAppl));
            }
            this.addEdge((Individual)node, (Role)object, node, dependencySet);
        }
    }

    protected void updateQueueAddEdge(Individual individual, Role role, Node node) {
        Object object;
        Role role2;
        ATermAppl aTermAppl;
        ATermAppl aTermAppl2;
        int n;
        List<ATermAppl> list = individual.getTypes(5);
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            aTermAppl2 = list.get(n);
            aTermAppl = (ATermAppl)aTermAppl2.getArgument(0);
            role2 = this.abox.getRole(aTermAppl.getArgument(0));
            if (!role.isSubRoleOf(role2)) continue;
            object = new QueueElement(individual, aTermAppl2);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.CHOOSE);
        }
        if (node instanceof Individual) {
            list = ((Individual)node).getTypes(5);
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                aTermAppl2 = list.get(n);
                aTermAppl = (ATermAppl)aTermAppl2.getArgument(0);
                role2 = this.abox.getRole(aTermAppl.getArgument(0));
                object = role.getInverse();
                if (object == null || !((Role)object).isSubRoleOf(role2)) continue;
                QueueElement queueElement = new QueueElement(node, aTermAppl2);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.MAX_NUMBER);
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.CHOOSE);
            }
        }
    }

    public void addEdge(Individual individual, Role role, Node node, DependencySet dependencySet) {
        Edge edge = individual.addEdge(role, node, dependencySet);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addEdgeDependency(edge, dependencySet);
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), individual.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node.getName());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.updateQueueAddEdge(individual, role, node);
        }
        if (edge != null) {
            if (individual.isBlockable() && node.isNominal() && !node.isLiteral() && role.isInverseFunctional()) {
                Individual individual2 = (Individual)node;
                int n = 1;
                if (!individual2.hasDistinctRNeighborsForMin(role.getInverse(), n, ATermUtils.TOP, true)) {
                    int n2 = individual2.getMinCard(role.getInverse(), ATermUtils.TOP);
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    if (n2 > n) {
                        return;
                    }
                    GuessBranch guessBranch = new GuessBranch(this.abox, this, individual2, role.getInverse(), n2, n, ATermUtils.TOP, dependencySet);
                    this.addBranch(guessBranch);
                    if (!guessBranch.tryNext()) {
                        return;
                    }
                    if (this.abox.isClosed()) {
                        return;
                    }
                    if (individual.isPruned()) {
                        return;
                    }
                }
            }
            this.applyPropertyRestrictions(individual, role, node, dependencySet);
        }
    }

    void applyPropertyRestrictions(Edge edge) {
        this.applyPropertyRestrictions(edge.getFrom(), edge.getRole(), edge.getTo(), edge.getDepends());
    }

    void applyPropertyRestrictions(Individual individual, Role role, Node node, DependencySet dependencySet) {
        this.applyDomainRange(individual, role, node, dependencySet);
        if (individual.isPruned() || node.isPruned()) {
            return;
        }
        this.applyFunctionality(individual, role, node);
        if (individual.isPruned() || node.isPruned()) {
            return;
        }
        this.applyDisjointness(individual, role, node, dependencySet);
        this.allValuesRule.applyAllValues(individual, role, node, dependencySet);
        if (individual.isPruned() || node.isPruned()) {
            return;
        }
        if (role.isObjectRole()) {
            Individual individual2 = (Individual)node;
            this.allValuesRule.applyAllValues(individual2, role.getInverse(), individual, dependencySet);
            this.checkReflexivitySymmetry(individual, role, individual2, dependencySet);
            this.checkReflexivitySymmetry(individual2, role.getInverse(), individual, dependencySet);
            this.applyDisjointness(individual2, role.getInverse(), individual, dependencySet);
        }
    }

    void applyDomainRange(Individual individual, Role role, Node node, DependencySet dependencySet) {
        Set<ATermAppl> set = role.getDomains();
        Set<ATermAppl> set2 = role.getRanges();
        for (ATermAppl aTermAppl : set) {
            if (log.isLoggable(Level.FINE) && !individual.hasType((ATerm)aTermAppl)) {
                log.fine("DOM : " + node + " <- " + role + " <- " + individual + " : " + ATermUtils.toString(aTermAppl));
            }
            this.addType(individual, aTermAppl, dependencySet.union(role.getExplainDomain(aTermAppl), this.abox.doExplanation()));
            if (!individual.isPruned() && !node.isPruned()) continue;
            return;
        }
        for (ATermAppl aTermAppl : set2) {
            if (log.isLoggable(Level.FINE) && !node.hasType((ATerm)aTermAppl)) {
                log.fine("RAN : " + individual + " -> " + role + " -> " + node + " : " + ATermUtils.toString(aTermAppl));
            }
            this.addType(node, aTermAppl, dependencySet.union(role.getExplainRange(aTermAppl), this.abox.doExplanation()));
            if (!individual.isPruned() && !node.isPruned()) continue;
            return;
        }
    }

    void applyFunctionality(Individual individual, Role role, Node node) {
        DependencySet dependencySet;
        DependencySet dependencySet2 = dependencySet = role.isFunctional() ? role.getExplainFunctional() : individual.hasMax1(role);
        if (dependencySet != null) {
            this.maxRule.applyFunctionalMaxRule(individual, role, ATermUtils.getTop(role), dependencySet);
        }
        if (role.isDatatypeRole() && role.isInverseFunctional()) {
            this.applyFunctionalMaxRule((Literal)node, role, DependencySet.INDEPENDENT);
        } else if (role.isObjectRole()) {
            Individual individual2 = (Individual)node;
            Role role2 = role.getInverse();
            DependencySet dependencySet3 = dependencySet = role2.isFunctional() ? role2.getExplainFunctional() : individual2.hasMax1(role2);
            if (dependencySet != null) {
                this.maxRule.applyFunctionalMaxRule(individual2, role2, ATermUtils.TOP, dependencySet);
            }
        }
    }

    void applyDisjointness(Individual individual, Role role, Node node, DependencySet dependencySet) {
        Set<Role> set = role.getDisjointRoles();
        if (set.isEmpty()) {
            return;
        }
        EdgeList edgeList = individual.getEdgesTo(node);
        int n = edgeList.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = edgeList.edgeAt(i);
            if (!set.contains(edge.getRole())) continue;
            dependencySet = dependencySet.union(edge.getDepends(), this.abox.doExplanation());
            dependencySet = dependencySet.union(role.getExplainDisjointRole(edge.getRole()), this.abox.doExplanation());
            this.abox.setClash(Clash.disjointProps(individual, dependencySet, role.getName(), edge.getRole().getName()));
            return;
        }
    }

    void checkReflexivitySymmetry(Individual individual, Role role, Individual individual2, DependencySet dependencySet) {
        if (role.isAsymmetric() && individual2.hasRSuccessor(role, individual)) {
            EdgeList edgeList = individual2.getEdgesTo(individual, role);
            dependencySet = dependencySet.union(edgeList.edgeAt(0).getDepends(), this.abox.doExplanation());
            if (PelletOptions.USE_TRACING) {
                dependencySet = dependencySet.union(role.getExplainAsymmetric(), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.unexplained(individual, dependencySet, "Antisymmetric property " + role));
        } else if (individual.equals(individual2)) {
            if (role.isIrreflexive()) {
                this.abox.setClash(Clash.unexplained(individual, dependencySet.union(role.getExplainIrreflexive(), this.abox.doExplanation()), "Irreflexive property " + role));
            } else {
                ATermAppl aTermAppl = ATermUtils.makeNot((ATerm)ATermUtils.makeSelf(role.getName()));
                if (individual.hasType((ATerm)aTermAppl)) {
                    this.abox.setClash(Clash.unexplained(individual, dependencySet.union(individual.getDepends((ATerm)aTermAppl), this.abox.doExplanation()), "Local irreflexive property " + role));
                }
            }
        }
    }

    protected void applyFunctionalMaxRule(Literal literal, Role role, DependencySet dependencySet) {
        Individual individual;
        Edge edge;
        int n;
        EdgeList edgeList = literal.getInEdges().getEdges(role);
        if (edgeList.size() <= 1) {
            return;
        }
        Set<Node> set = edgeList.getNeighbors(literal);
        if (set.size() <= 1) {
            return;
        }
        Individual individual2 = null;
        DependencySet dependencySet2 = null;
        for (n = 0; n < edgeList.size(); ++n) {
            edge = edgeList.edgeAt(n);
            individual = edge.getFrom();
            if (!individual.isNominal() || individual2 != null && individual.getNominalLevel() >= individual2.getNominalLevel()) continue;
            individual2 = individual;
            dependencySet2 = edge.getDepends();
        }
        if (individual2 == null) {
            individual2 = this.abox.addFreshIndividual(null, dependencySet);
        } else {
            dependencySet = dependencySet.union(dependencySet2, this.abox.doExplanation());
        }
        for (n = 0; n < edgeList.size(); ++n) {
            edge = edgeList.edgeAt(n);
            individual = edge.getFrom();
            if (individual.isPruned() || individual2.isSame(individual)) continue;
            dependencySet = dependencySet.union(edge.getDepends(), this.abox.doExplanation());
            if (individual.isDifferent(individual2)) {
                dependencySet = dependencySet.union(individual.getDifferenceDependency(individual2), this.abox.doExplanation());
                if (role.isFunctional()) {
                    this.abox.setClash(Clash.functionalCardinality(literal, dependencySet, role.getName()));
                    break;
                }
                this.abox.setClash(Clash.maxCardinality(literal, dependencySet, role.getName(), 1));
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("FUNC: " + literal + " for prop " + role + " merge " + individual + " -> " + individual2 + " " + dependencySet);
            }
            this.mergeTo(individual, individual2, dependencySet);
            if (this.abox.isClosed()) {
                return;
            }
            if (!individual2.isPruned()) continue;
            dependencySet = dependencySet.union(individual2.getMergeDependency(true), this.abox.doExplanation());
            individual2 = individual2.getSame();
        }
    }

    private void mergeLater(Node node, Node node2, DependencySet dependencySet) {
        this.mergeList.add(new NodeMerge(node, node2, dependencySet));
    }

    public void mergeAll() {
        if (this.mergingAll) {
            return;
        }
        this.mergingAll = true;
        while (!(this.merging || this.mergeList.isEmpty() || this.abox.isClosed())) {
            NodeMerge nodeMerge = this.mergeList.remove(0);
            Node node = this.abox.getNode((ATerm)nodeMerge.getSource());
            Node node2 = this.abox.getNode((ATerm)nodeMerge.getTarget());
            DependencySet dependencySet = nodeMerge.getDepends();
            if (node.isMerged()) {
                dependencySet = dependencySet.union(node.getMergeDependency(true), this.abox.doExplanation());
                node = node.getSame();
            }
            if (node2.isMerged()) {
                dependencySet = dependencySet.union(node2.getMergeDependency(true), this.abox.doExplanation());
                node2 = node2.getSame();
            }
            if (node.isPruned() || node2.isPruned()) continue;
            this.mergeTo(node, node2, dependencySet);
        }
        this.mergingAll = false;
    }

    public void mergeTo(Node node, Node node2, DependencySet dependencySet) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node2.getName());
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addMergeDependency(node.getName(), node2.getName(), dependencySet);
        }
        if (node.isDifferent(node2)) {
            this.abox.setClash(Clash.nominal(node, node.getDifferenceDependency(node2).union(dependencySet, this.abox.doExplanation())));
            return;
        }
        if (!node.isSame(node2)) {
            this.abox.setChanged(true);
            if (this.merging) {
                this.mergeLater(node, node2, dependencySet);
                return;
            }
            this.merging = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("MERG: " + node + " -> " + node2 + " " + dependencySet);
            }
            dependencySet = dependencySet.copy(this.abox.getBranch());
            if (node instanceof Literal && node2 instanceof Literal) {
                this.mergeLiterals((Literal)node, (Literal)node2, dependencySet);
            } else if (node instanceof Individual && node2 instanceof Individual) {
                this.mergeIndividuals((Individual)node, (Individual)node2, dependencySet);
            } else {
                throw new InternalReasonerException("Invalid merge operation!");
            }
        }
        this.merging = false;
        this.mergeAll();
    }

    protected void mergeIndividuals(Individual individual, Individual individual2, DependencySet dependencySet) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        individual.setSame(individual2, dependencySet);
        individual2.setNominalLevel(Math.min(individual2.getNominalLevel(), individual.getNominalLevel()));
        Map<ATermAppl, DependencySet> map = individual.getDepends();
        for (Map.Entry<ATermAppl, DependencySet> entry : map.entrySet()) {
            object4 = entry.getKey();
            object3 = dependencySet.union(entry.getValue(), this.abox.doExplanation());
            this.addType(individual2, (ATermAppl)object4, (DependencySet)object3);
        }
        EdgeList edgeList = individual.getInEdges();
        for (int i = 0; i < edgeList.size(); ++i) {
            object4 = edgeList.edgeAt(i);
            object3 = object4.getFrom();
            object2 = object4.getRole();
            object = dependencySet.union(object4.getDepends(), this.abox.doExplanation());
            if (individual.equals(object3)) {
                this.addEdge(individual2, (Role)object2, individual2, (DependencySet)object);
            } else if (individual2.hasSuccessor((Node)object3)) {
                this.addEdge(individual2, ((Role)object2).getInverse(), (Node)object3, (DependencySet)object);
            } else {
                this.addEdge((Individual)object3, (Role)object2, individual2, (DependencySet)object);
            }
            ((Individual)object3).removeEdge((Edge)object4);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), ((Node)object3).getName());
        }
        individual2.inheritDifferents(individual, dependencySet);
        individual.prune(dependencySet);
        EdgeList edgeList2 = individual.getOutEdges();
        for (int i = 0; i < edgeList2.size(); ++i) {
            object3 = edgeList2.edgeAt(i);
            object2 = object3.getTo();
            if (!((Node)object2).isNominal() || individual.equals(object2)) continue;
            object = object3.getRole();
            DependencySet dependencySet2 = dependencySet.union(object3.getDepends(), this.abox.doExplanation());
            this.addEdge(individual2, (Role)object, (Node)object2, dependencySet2);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), ((Node)object2).getName());
        }
    }

    protected void mergeLiterals(Literal literal, Literal literal2, DependencySet dependencySet) {
        literal.setSame(literal2, dependencySet);
        literal2.addAllTypes(literal.getDepends(), dependencySet);
        EdgeList edgeList = literal.getInEdges();
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.edgeAt(i);
            Individual individual = edge.getFrom();
            Role role = edge.getRole();
            DependencySet dependencySet2 = dependencySet.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(individual, role, literal2, dependencySet2);
            individual.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), individual.getName());
        }
        literal2.inheritDifferents(literal, dependencySet);
        literal.prune(dependencySet);
        if (literal2.getNodeDepends() == null || literal.getNodeDepends() == null) {
            throw new NullPointerException();
        }
    }

    public void restoreLocal(Individual individual, Branch branch) {
        ++this.abox.stats.localRestores;
        this.abox.setClash(null);
        this.abox.setBranch(branch.getBranch());
        HashMap<Node, Boolean> hashMap = new HashMap<Node, Boolean>();
        this.restoreLocal(individual, branch.getBranch(), hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            boolean bl = (Boolean)entry.getValue();
            if (!bl) continue;
            this.allValuesRule.apply((Individual)entry.getKey());
        }
    }

    private void restoreLocal(Individual individual, int n, Map<Node, Boolean> map) {
        boolean bl = individual.restore(n);
        map.put(individual, bl);
        if (bl) {
            Node node;
            for (Edge edge : individual.getOutEdges()) {
                node = edge.getTo();
                if (map.containsKey(node)) continue;
                if (node.isLiteral()) {
                    map.put(node, Boolean.FALSE);
                    node.restore(n);
                    continue;
                }
                this.restoreLocal((Individual)node, n, map);
            }
            for (Edge edge : individual.getInEdges()) {
                node = edge.getFrom();
                if (map.containsKey(node)) continue;
                this.restoreLocal((Individual)node, n, map);
            }
        }
    }

    public void restore(Branch branch) {
        Object object;
        this.abox.setBranch(branch.getBranch());
        this.abox.setClash(null);
        this.abox.rulesNotApplied = true;
        this.mergeList.clear();
        List<ATermAppl> list = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + branch.getBranch());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().clearQueue(NodeSelector.UNIVERSAL);
            this.abox.getCompletionQueue().restore(branch.getBranch());
        }
        if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this.abox.getIncrementalChangeTracker().clear();
        }
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            Node node = this.abox.getNode((ATerm)aTermAppl);
            if (node.getNodeDepends() == null || node.getNodeDepends().getBranch() > branch.getBranch()) {
                this.abox.removeNode(aTermAppl);
                if (node.isMerged()) {
                    node.undoSetSame();
                }
                ++n2;
                continue;
            }
            if (n2 > 0) {
                object = list.subList(i - n2, i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove nodes " + object);
                }
                object.clear();
                n -= n2;
                i -= n2;
                n2 = 0;
            }
            if (PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            node.restore(branch.getBranch());
        }
        if (n2 > 0) {
            list.subList(n - n2, n).clear();
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            Set<ATermAppl> set = this.abox.getBranchEffectTracker().removeAll(branch.getBranch() + 1);
            for (ATermAppl aTermAppl : set) {
                object = this.abox.getNode((ATerm)aTermAppl);
                if (object == null) continue;
                ((Node)object).restore(branch.getBranch());
            }
        }
        this.restoreAllValues();
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (!this.abox.isClosed()) {
            this.abox.validate();
        }
    }

    public void addBranch(Branch branch) {
        this.abox.getBranches().add(branch);
        if (branch.getBranch() != this.abox.getBranches().size()) {
            throw new RuntimeException("Invalid branch created: " + branch.getBranch() + " != " + this.abox.getBranches().size());
        }
        this.completionTimer.check();
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addBranchAddDependency(branch);
        }
    }

    void printBlocked() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        IndividualIterator individualIterator = this.abox.getIndIterator();
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            ATermAppl aTermAppl = individual.getName();
            if (!this.blocking.isBlocked(individual)) continue;
            ++n;
            stringBuffer.append(aTermAppl).append(" ");
        }
        log.fine("Blocked nodes " + n + " [" + stringBuffer + "]");
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    protected void restoreAllValues() {
        IndividualIterator individualIterator = new IndividualIterator(this.abox);
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            this.allValuesRule.apply(individual);
        }
    }
}

