/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.CombinedQueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryExec;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public abstract class AbstractABoxEngineWrapper
implements QueryExec {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());
    public static final QueryExec distCombinedQueryExec = new CombinedQueryEngine();
    protected Query schemaQuery;
    protected Query aboxQuery;

    @Override
    public QueryResult exec(Query query) {
        QueryResult queryResult;
        QueryResult queryResult2;
        boolean bl;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing query " + query.getAtoms());
        }
        this.partitionQuery(query);
        if (this.schemaQuery.getAtoms().isEmpty()) {
            bl = false;
            queryResult2 = new QueryResultImpl(query);
            queryResult2.add(new ResultBindingImpl());
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Executing TBox query: " + this.schemaQuery);
            }
            queryResult2 = distCombinedQueryExec.exec(this.schemaQuery);
            boolean bl2 = bl = SetUtils.intersects(query.getDistVarsForType(Query.VarType.CLASS), query.getResultVars()) || SetUtils.intersects(query.getDistVarsForType(Query.VarType.PROPERTY), query.getResultVars());
        }
        if (bl && queryResult2.isEmpty()) {
            return queryResult2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Partial binding after schema query : " + queryResult2);
        }
        if (this.aboxQuery.getAtoms().size() > 0) {
            queryResult = new QueryResultImpl(query);
            for (ResultBinding resultBinding : queryResult2) {
                Query query2 = this.aboxQuery.apply(resultBinding);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Executing ABox query: " + query2);
                }
                QueryResult queryResult3 = this.execABoxQuery(query2);
                for (ResultBinding resultBinding2 : queryResult3) {
                    for (ATermAppl aTermAppl : resultBinding.getAllVariables()) {
                        resultBinding2.setValue(aTermAppl, resultBinding.getValue(aTermAppl));
                    }
                    queryResult.add(resultBinding2);
                }
            }
        } else {
            queryResult = queryResult2;
            if (log.isLoggable(Level.FINER)) {
                log.finer("ABox query empty ... returning.");
            }
        }
        return queryResult;
    }

    private final void partitionQuery(Query query) {
        this.schemaQuery = new QueryImpl(query);
        this.aboxQuery = new QueryImpl(query);
        for (QueryAtom object2 : query.getAtoms()) {
            switch (object2.getPredicate()) {
                case Type: 
                case PropertyValue: {
                    this.aboxQuery.add(object2);
                    break;
                }
            }
        }
        ArrayList<QueryAtom> arrayList = new ArrayList<QueryAtom>(query.getAtoms());
        arrayList.removeAll(this.aboxQuery.getAtoms());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            QueryAtom queryAtom = (QueryAtom)iterator.next();
            this.schemaQuery.add(queryAtom);
        }
        for (Query.VarType varType : Query.VarType.values()) {
            for (ATermAppl aTermAppl : query.getDistVarsForType(varType)) {
                if (this.aboxQuery.getVars().contains(aTermAppl)) {
                    this.aboxQuery.addDistVar(aTermAppl, varType);
                }
                if (!this.schemaQuery.getVars().contains(aTermAppl)) continue;
                this.schemaQuery.addDistVar(aTermAppl, varType);
            }
        }
        for (ATermAppl aTermAppl : query.getResultVars()) {
            if (this.aboxQuery.getVars().contains(aTermAppl)) {
                this.aboxQuery.addResultVar(aTermAppl);
            }
            if (!this.schemaQuery.getVars().contains(aTermAppl)) continue;
            this.schemaQuery.addResultVar(aTermAppl);
        }
        for (ATermAppl aTermAppl : this.aboxQuery.getDistVarsForType(Query.VarType.CLASS)) {
            if (this.schemaQuery.getVars().contains(aTermAppl)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubClassOfAtom(aTermAppl, ATermUtils.TOP));
        }
        for (ATermAppl aTermAppl : this.aboxQuery.getDistVarsForType(Query.VarType.PROPERTY)) {
            if (this.schemaQuery.getVars().contains(aTermAppl)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubPropertyOfAtom(aTermAppl, aTermAppl));
        }
    }

    protected abstract QueryResult execABoxQuery(Query var1);
}

