/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.GlassBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletExplanation {
    private OWLDataFactory factory;
    private HSTExplanationGenerator expGen;
    private SatisfiabilityConverter converter;

    public static void setup() {
        GlassBoxExplanation.setup();
    }

    public PelletExplanation(OWLOntology oWLOntology) {
        this(oWLOntology, true);
    }

    public PelletExplanation(OWLOntology oWLOntology, boolean bl) {
        this(new PelletReasonerFactory().createReasoner(oWLOntology), bl);
    }

    public PelletExplanation(PelletReasoner pelletReasoner) {
        this(pelletReasoner, true);
    }

    private PelletExplanation(PelletReasoner pelletReasoner, boolean bl) {
        this.factory = pelletReasoner.getManager().getOWLDataFactory();
        GlassBoxExplanation glassBoxExplanation = bl ? new GlassBoxExplanation(pelletReasoner) : new BlackBoxExplanation(pelletReasoner.getRootOntology(), (OWLReasonerFactory)new PelletReasonerFactory(), (OWLReasoner)pelletReasoner);
        this.expGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)glassBoxExplanation);
        this.converter = new SatisfiabilityConverter(this.factory);
    }

    public Set<OWLAxiom> getEntailmentExplanation(OWLAxiom oWLAxiom) {
        OWLClassExpression oWLClassExpression = this.converter.convert(oWLAxiom);
        return this.getUnsatisfiableExplanation(oWLClassExpression);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom oWLAxiom) {
        OWLClassExpression oWLClassExpression = this.converter.convert(oWLAxiom);
        return this.getUnsatisfiableExplanations(oWLClassExpression);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom oWLAxiom, int n) {
        OWLClassExpression oWLClassExpression = this.converter.convert(oWLAxiom);
        return this.getUnsatisfiableExplanations(oWLClassExpression, n);
    }

    public Set<OWLAxiom> getInconsistencyExplanation() {
        return this.getUnsatisfiableExplanation((OWLClassExpression)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations() {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations(int n) {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this.factory.getOWLThing(), n);
    }

    public Set<OWLAxiom> getInstanceExplanation(OWLIndividual oWLIndividual, OWLClassExpression oWLClassExpression) {
        OWLClassAssertionAxiom oWLClassAssertionAxiom = this.factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual);
        return this.getEntailmentExplanation((OWLAxiom)oWLClassAssertionAxiom);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual oWLIndividual, OWLClassExpression oWLClassExpression) {
        OWLClassAssertionAxiom oWLClassAssertionAxiom = this.factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual);
        return this.getEntailmentExplanations((OWLAxiom)oWLClassAssertionAxiom);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual oWLIndividual, OWLClassExpression oWLClassExpression, int n) {
        OWLClassAssertionAxiom oWLClassAssertionAxiom = this.factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual);
        return this.getEntailmentExplanations((OWLAxiom)oWLClassAssertionAxiom, n);
    }

    public Set<OWLAxiom> getSubClassExplanation(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        OWLSubClassOfAxiom oWLSubClassOfAxiom = this.factory.getOWLSubClassOfAxiom(oWLClassExpression, oWLClassExpression2);
        return this.getEntailmentExplanation((OWLAxiom)oWLSubClassOfAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        OWLSubClassOfAxiom oWLSubClassOfAxiom = this.factory.getOWLSubClassOfAxiom(oWLClassExpression, oWLClassExpression2);
        return this.getEntailmentExplanations((OWLAxiom)oWLSubClassOfAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2, int n) {
        OWLSubClassOfAxiom oWLSubClassOfAxiom = this.factory.getOWLSubClassOfAxiom(oWLClassExpression, oWLClassExpression2);
        return this.getEntailmentExplanations((OWLAxiom)oWLSubClassOfAxiom, n);
    }

    public Set<OWLAxiom> getUnsatisfiableExplanation(OWLClassExpression oWLClassExpression) {
        return this.expGen.getExplanation(oWLClassExpression);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression oWLClassExpression) {
        return this.expGen.getExplanations(oWLClassExpression);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression oWLClassExpression, int n) {
        return this.expGen.getExplanations(oWLClassExpression, n);
    }

    static {
        PelletExplanation.setup();
    }
}

