/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.FunctionApplicationVisitor;
import com.clarkparsia.pellet.rules.builtins.NumberToLiteralVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;

public class NumericAdapter
implements Function {
    private NumericFunction function;

    public NumericAdapter(NumericFunction numericFunction) {
        this.function = numericFunction;
    }

    @Override
    public Literal apply(ABox aBox, Literal literal, Literal ... literalArray) {
        Number number = null;
        Number number2 = null;
        Literal literal2 = null;
        if (literal != null) {
            if (!(literal.getValue() instanceof Number)) {
                ABox.log.info("Testing non-numeric against the result of a numeric function '" + this.function + "': " + literal);
                return null;
            }
            number = (Number)literal.getValue();
        }
        Number[] numberArray = new Number[literalArray.length];
        for (int i = 0; i < literalArray.length; ++i) {
            if (!(literalArray[i].getValue() instanceof Number)) {
                ABox.log.info("Non numeric arguments to numeric function '" + this.function + "': " + literalArray[i]);
                return null;
            }
            numberArray[i] = (Number)literalArray[i].getValue();
        }
        NumericPromotion numericPromotion = new NumericPromotion();
        numericPromotion.promote(numberArray);
        FunctionApplicationVisitor functionApplicationVisitor = new FunctionApplicationVisitor(this.function, number);
        numericPromotion.accept(functionApplicationVisitor);
        number2 = functionApplicationVisitor.getResult();
        if (number2 != null) {
            if (literal != null) {
                literal2 = literal;
            } else {
                NumberToLiteralVisitor numberToLiteralVisitor = new NumberToLiteralVisitor(aBox);
                numericPromotion.promote(number2);
                numericPromotion.accept(numberToLiteralVisitor);
                literal2 = numberToLiteralVisitor.getLiteral();
            }
        }
        return literal2;
    }
}

