/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.FlattenningIterator;
import org.mindswap.pellet.utils.iterator.MultiIterator;

public class IteratorUtils {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        return new MultiIterator<T>(iterator, iterator2);
    }

    public static final <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static final <T> Iterator<T> singletonIterator(T t) {
        return new SingletonIterator(t);
    }

    public static <T> Set<T> toSet(Iterator<T> iterator) {
        HashSet<T> hashSet = new HashSet<T>();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> Iterator<T> flatten(Iterator<? extends Iterable<T>> iterator) {
        return new FlattenningIterator(iterator);
    }

    public static <T> Iterator<T> singleton(T t) {
        return IteratorUtils.iterator(t);
    }

    public static <T> Iterator<T> iterator(final T t) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> iterator(T ... TArray) {
        return new ArrayIterator<T>(TArray, TArray.length);
    }

    public static <T> Iterator<T> iterator(int n, T ... TArray) {
        return new ArrayIterator<T>(TArray, n);
    }

    private static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] array;
        private int size;
        private int curr = 0;

        public ArrayIterator(E[] EArray, int n) {
            this.array = EArray;
            this.size = n;
        }

        @Override
        public boolean hasNext() {
            return this.curr != this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.curr++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonIterator<T>
    implements Iterator<T> {
        private T element;
        private boolean consumed;

        private SingletonIterator(T t) {
            this.element = t;
            this.consumed = false;
        }

        @Override
        public boolean hasNext() {
            return !this.consumed;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.consumed = true;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

