/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class ArrayIntSet
implements IntSet {
    private static int INIT_CAPACITY = 1;
    private int[] ints;
    private int size;

    public ArrayIntSet() {
        this.size = 0;
        this.ints = new int[INIT_CAPACITY];
    }

    public ArrayIntSet(ArrayIntSet arrayIntSet) {
        this.size = arrayIntSet.size;
        this.ints = new int[this.size];
        System.arraycopy(arrayIntSet.ints, 0, this.ints, 0, this.size);
    }

    private ArrayIntSet(ArrayIntSet arrayIntSet, ArrayIntSet arrayIntSet2) {
        this.setToUnionOf(arrayIntSet, arrayIntSet2);
    }

    @Override
    public void add(int n) {
        this.ensureCapacity(this.size + 1);
        int n2 = this.binarySearch(this.ints, n);
        if (n2 < 0) {
            if ((n2 = -n2 - 1) < this.size) {
                System.arraycopy(this.ints, n2, this.ints, n2 + 1, this.size - n2);
            }
            this.ints[n2] = n;
            ++this.size;
        }
    }

    @Override
    public void addAll(IntSet intSet) {
        if (intSet instanceof ArrayIntSet) {
            this.setToUnionOf(this, (ArrayIntSet)intSet);
        } else {
            this.ensureCapacity(this.size + intSet.size());
            IntIterator intIterator = intSet.iterator();
            while (intIterator.hasNext()) {
                this.add(intIterator.next());
            }
        }
    }

    private int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = nArray[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    @Override
    public boolean contains(int n) {
        return this.binarySearch(this.ints, n) >= 0;
    }

    @Override
    public IntSet copy() {
        return new ArrayIntSet(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        IntSet intSet = (IntSet)object;
        if (this.size() != intSet.size()) {
            return false;
        }
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intSet.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int n) {
        int n2 = this.ints.length;
        if (n > n2) {
            int[] nArray = this.ints;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.ints = new int[n3];
            System.arraycopy(nArray, 0, this.ints, 0, this.size);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ArrayIntSet.this.size;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArrayIntSet.this.ints[this.next++];
            }
        };
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints[this.size - 1];
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints[0];
    }

    @Override
    public void remove(int n) {
        int n2 = this.binarySearch(this.ints, n);
        if (n2 >= 0) {
            if (n2 < this.size - 1) {
                System.arraycopy(this.ints, n2 + 1, this.ints, n2, this.size - n2 - 1);
            }
            --this.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.ints[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.ints[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void setToUnionOf(ArrayIntSet arrayIntSet, ArrayIntSet arrayIntSet2) {
        int[] nArray = arrayIntSet.ints;
        int[] nArray2 = arrayIntSet2.ints;
        int n = arrayIntSet.size;
        int n2 = arrayIntSet2.size;
        this.size = n + n2;
        this.ints = new int[this.size];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (n3 == n) {
                System.arraycopy(nArray2, n4, this.ints, i, n2 - n4);
                break;
            }
            if (n4 == n2) {
                System.arraycopy(nArray, n3, this.ints, i, n - n3);
                break;
            }
            if (nArray[n3] < nArray2[n4]) {
                this.ints[i] = nArray[n3++];
                continue;
            }
            this.ints[i] = nArray2[n4++];
            if (this.ints[i] != nArray[n3]) continue;
            ++n3;
            --this.size;
        }
    }

    @Override
    public IntSet union(IntSet intSet) {
        return new ArrayIntSet(this, (ArrayIntSet)intSet);
    }
}

