/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.queue;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;

public class BasicCompletionQueue
extends CompletionQueue {
    protected List<ATermAppl> queue = new ArrayList<ATermAppl>();
    protected Set<ATermAppl> newQueue = new HashSet<ATermAppl>();
    protected List<ATermAppl> newQueueList = new ArrayList<ATermAppl>();
    protected int current = 0;
    protected int end = 0;
    protected int cutOff = 0;
    protected boolean backtracked = false;

    public BasicCompletionQueue(ABox aBox) {
        super(aBox);
    }

    @Override
    protected void findNext(int n) {
        Node node;
        while (!(this.current >= this.cutOff || (node = this.abox.getNode((ATerm)this.queue.get(this.current))) != null && ((node = node.getSame()).isLiteral() && this.allowLiterals() || node.isIndividual() && !this.allowLiterals()) && !node.isPruned())) {
            ++this.current;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(-1);
        return this.current < this.cutOff;
    }

    @Override
    public void restore(int n) {
        this.queue.addAll(this.newQueueList);
        this.newQueue.clear();
        this.newQueueList.clear();
        this.end = this.queue.size();
        this.current = 0;
        this.cutOff = this.end;
        this.backtracked = true;
    }

    @Override
    public Individual next() {
        this.findNext(-1);
        Individual individual = this.abox.getIndividual((ATerm)this.queue.get(this.current));
        individual = individual.getSame();
        ++this.current;
        return individual;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(-1);
        Node node = this.abox.getNode((ATerm)this.queue.get(this.current));
        node = node.getSame();
        ++this.current;
        return node;
    }

    @Override
    public void add(QueueElement queueElement, NodeSelector nodeSelector) {
        this.add(queueElement);
    }

    @Override
    public void add(QueueElement queueElement) {
        if (!this.newQueue.contains(queueElement.getNode())) {
            this.newQueue.add(queueElement.getNode());
            this.newQueueList.add(queueElement.getNode());
        }
    }

    @Override
    public void reset(NodeSelector nodeSelector) {
        this.cutOff = this.end;
        this.current = 0;
    }

    @Override
    public void incrementBranch(int n) {
    }

    @Override
    public BasicCompletionQueue copy() {
        BasicCompletionQueue basicCompletionQueue = new BasicCompletionQueue(this.abox);
        basicCompletionQueue.queue = new ArrayList<ATermAppl>(this.queue);
        basicCompletionQueue.newQueue = new HashSet<ATermAppl>(this.newQueue);
        basicCompletionQueue.newQueueList = new ArrayList<ATermAppl>(this.newQueueList);
        basicCompletionQueue.current = this.current;
        basicCompletionQueue.cutOff = this.cutOff;
        basicCompletionQueue.backtracked = this.backtracked;
        basicCompletionQueue.end = this.end;
        basicCompletionQueue.setAllowLiterals(this.allowLiterals());
        return basicCompletionQueue;
    }

    @Override
    public void setABox(ABox aBox) {
        this.abox = aBox;
    }

    @Override
    public void print(int n) {
        System.out.println("Queue: " + this.queue);
    }

    @Override
    public void print() {
        System.out.println("Queue: " + this.queue);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }

    @Override
    public void flushQueue() {
        if (!this.backtracked && !this.closed) {
            this.queue.clear();
        } else if (this.closed && !this.abox.isClosed()) {
            this.closed = false;
        }
        this.queue.addAll(this.newQueueList);
        this.newQueue.clear();
        this.newQueueList.clear();
        this.end = this.queue.size();
        this.backtracked = false;
    }

    @Override
    protected void flushQueue(NodeSelector nodeSelector) {
    }

    @Override
    public void clearQueue(NodeSelector nodeSelector) {
    }
}

