/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;

public class Clash {
    private DependencySet depends;
    private Node node;
    private ClashType type;
    ATerm[] args;
    String explanation;

    private Clash(Node node, ClashType clashType, DependencySet dependencySet) {
        this.setDepends(dependencySet);
        this.setNode(node);
        this.setType(clashType);
    }

    private Clash(Node node, ClashType clashType, DependencySet dependencySet, ATerm[] aTermArray) {
        this.setDepends(dependencySet);
        this.setNode(node);
        this.setType(clashType);
        this.args = aTermArray;
    }

    private Clash(Node node, ClashType clashType, DependencySet dependencySet, String string) {
        this.setDepends(dependencySet);
        this.setNode(node);
        this.setType(clashType);
        this.explanation = string;
    }

    public Clash copyTo(ABox aBox) {
        return new Clash(aBox.getNode((ATerm)this.getNode().getName()), this.getType(), this.getDepends(), this.explanation);
    }

    public ClashType getClashType() {
        return this.getType();
    }

    public static Clash unexplained(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.UNEXPLAINED, dependencySet);
    }

    public static Clash unexplained(Node node, DependencySet dependencySet, String string) {
        return new Clash(node, ClashType.UNEXPLAINED, dependencySet, string);
    }

    public static Clash atomic(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.ATOMIC, dependencySet);
    }

    public static Clash atomic(Node node, DependencySet dependencySet, ATermAppl aTermAppl) {
        return new Clash(node, ClashType.ATOMIC, dependencySet, new ATerm[]{aTermAppl});
    }

    public static Clash bottomProperty(Node node, DependencySet dependencySet, ATermAppl aTermAppl) {
        return new Clash(node, ClashType.BOTTOM_PROP, dependencySet, new ATerm[]{aTermAppl});
    }

    public static Clash maxCardinality(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.MAX_CARD, dependencySet);
    }

    public static Clash maxCardinality(Node node, DependencySet dependencySet, ATermAppl aTermAppl, int n) {
        return new Clash(node, ClashType.MAX_CARD, dependencySet, new ATerm[]{aTermAppl, ATermUtils.getFactory().makeInt(n)});
    }

    public static Clash minMax(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.MIN_MAX, dependencySet);
    }

    public static Clash functionalCardinality(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.FUNC_MAX_CARD, dependencySet);
    }

    public static Clash functionalCardinality(Node node, DependencySet dependencySet, ATermAppl aTermAppl) {
        return new Clash(node, ClashType.FUNC_MAX_CARD, dependencySet, new ATerm[]{aTermAppl});
    }

    public static Clash missingDatatype(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.MISSING_DATATYPE, dependencySet);
    }

    public static Clash missingDatatype(Node node, DependencySet dependencySet, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return new Clash(node, ClashType.MISSING_DATATYPE, dependencySet, (ATerm[])new ATermAppl[]{aTermAppl, aTermAppl2});
    }

    public static Clash nominal(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.NOMINAL, dependencySet);
    }

    public static Clash nominal(Node node, DependencySet dependencySet, ATermAppl aTermAppl) {
        return new Clash(node, ClashType.NOMINAL, dependencySet, (ATerm[])new ATermAppl[]{aTermAppl});
    }

    public static Clash valueDatatype(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.VALUE_DATATYPE, dependencySet);
    }

    public static Clash valueDatatype(Node node, DependencySet dependencySet, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return new Clash(node, ClashType.VALUE_DATATYPE, dependencySet, (ATerm[])new ATermAppl[]{aTermAppl, aTermAppl2});
    }

    public static Clash emptyDatatype(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.EMPTY_DATATYPE, dependencySet);
    }

    public static Clash emptyDatatype(Node node, DependencySet dependencySet, ATermAppl[] aTermApplArray) {
        return new Clash(node, ClashType.EMPTY_DATATYPE, dependencySet, (ATerm[])aTermApplArray);
    }

    public static Clash invalidLiteral(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.INVALID_LITERAL, dependencySet);
    }

    public static Clash invalidLiteral(Node node, DependencySet dependencySet, ATermAppl aTermAppl) {
        return new Clash(node, ClashType.INVALID_LITERAL, dependencySet, (ATerm[])new ATermAppl[]{aTermAppl});
    }

    public static Clash disjointProps(Node node, DependencySet dependencySet) {
        return new Clash(node, ClashType.DISJOINT_PROPS, dependencySet);
    }

    public static Clash disjointProps(Node node, DependencySet dependencySet, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return new Clash(node, ClashType.DISJOINT_PROPS, dependencySet, (ATerm[])new ATermAppl[]{aTermAppl, aTermAppl2});
    }

    public String detailedString() {
        String string = this.explanation != null ? this.explanation : (this.getType() == ClashType.UNEXPLAINED ? "No explanation was generated." : (this.args == null ? "No specific explanation was generated. Generic explanation: " + this.getType().getExplanation() : (this.getType() == ClashType.ATOMIC ? this.atomicExplanation() : (this.getType() == ClashType.BOTTOM_PROP ? this.bottomExplanation() : (this.getType() == ClashType.MAX_CARD ? this.maxCardinalityExplanation() : (this.getType() == ClashType.FUNC_MAX_CARD ? this.functionalCardinalityExplanation() : (this.getType() == ClashType.NOMINAL ? this.nominalExplanation() : (this.getType() == ClashType.MISSING_DATATYPE ? this.missingDatatypeExplanation() : (this.getType() == ClashType.VALUE_DATATYPE ? this.valueDatatypeExplanation() : (this.getType() == ClashType.INVALID_LITERAL ? this.invalidLiteralExplanation() : (this.getType() == ClashType.EMPTY_DATATYPE ? this.emptyDatatypeExplanation() : this.explanation)))))))))));
        return string;
    }

    public String describeNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node.getNameStr().startsWith("Any member of")) {
            stringBuffer.append(node.getNameStr());
        } else if (node.isNamedIndividual()) {
            stringBuffer.append("Individual " + node.getNameStr());
        } else {
            List<ATermAppl> list = node.getPath();
            if (list.isEmpty()) {
                stringBuffer.append("There is an anonymous individual which");
            } else {
                ATermAppl aTermAppl = list.get(0);
                Iterator<ATermAppl> iterator = list.iterator();
                String string = "";
                if (aTermAppl.getName().startsWith("Any member of")) {
                    string = "Y";
                    stringBuffer.append(aTermAppl.getName() + ", X, is related to some " + string + ", identified by this path (X ");
                    iterator.next();
                } else {
                    string = "X";
                    stringBuffer.append("There is an anonymous individual X, identified by this path (" + iterator.next() + " ");
                }
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next() + " ");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append("[ ");
                }
                stringBuffer.append(string);
                for (int i = 0; i < list.size() - 2; ++i) {
                    stringBuffer.append(" ]");
                }
                stringBuffer.append("), which");
            }
        }
        return stringBuffer.toString();
    }

    public String atomicExplanation() {
        return this.describeNode(this.getNode()) + " is forced to belong to class " + this.args[0] + " and its complement";
    }

    public String bottomExplanation() {
        return this.describeNode(this.getNode()) + " has " + this.args[0] + " property";
    }

    public String maxCardinalityExplanation() {
        return this.describeNode(this.getNode()) + " has more than " + this.args[1] + " values for property " + this.args[0] + " violating the cardinality restriction";
    }

    public String functionalCardinalityExplanation() {
        return this.describeNode(this.getNode()) + " has more than " + "one value for the functional property " + this.args[0];
    }

    public String missingDatatypeExplanation() {
        return "Plain literal " + ATermUtils.toString((ATermAppl)this.args[0]) + " does not belong to datatype " + this.args[1] + ". Literal value may be missing the rdf:datatype attribute.";
    }

    public String nominalExplanation() {
        return this.describeNode(this.getNode()) + " is sameAs and differentFrom " + this.args[0] + "  at the same time ";
    }

    public String valueDatatypeExplanation() {
        return "Literal value " + ATermUtils.toString((ATermAppl)this.args[0]) + " does not belong to datatype " + ATermUtils.toString((ATermAppl)this.args[1]);
    }

    public String emptyDatatypeExplanation() {
        if (this.args.length == 1) {
            return "Datatype " + ATermUtils.toString((ATermAppl)this.args[0]) + " is inconsistent";
        }
        StringBuffer stringBuffer = new StringBuffer("Intersection of datatypes [");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ATermUtils.toString((ATermAppl)this.args[i]));
        }
        stringBuffer.append("] is inconsistent");
        return stringBuffer.toString();
    }

    public String invalidLiteralExplanation() {
        ATermAppl aTermAppl = (ATermAppl)this.args[0];
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        return "Literal value " + ATermUtils.toString(aTermAppl) + " is not valid for the rdatatype " + ATermUtils.toString(aTermAppl2);
    }

    public String toString() {
        return "[Clash " + this.getNode() + " " + (Object)((Object)this.getType()) + " " + this.getDepends().toString() + " " + (this.args == null ? null : Arrays.asList(this.args)) + "]";
    }

    public void setDepends(DependencySet dependencySet) {
        this.depends = dependencySet;
    }

    public DependencySet getDepends() {
        return this.depends;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public void setType(ClashType clashType) {
        this.type = clashType;
    }

    public ClashType getType() {
        return this.type;
    }

    public static enum ClashType {
        ATOMIC("An individual belongs to a type and its complement"),
        MIN_MAX("An individual contains a minCardinality restriction that is greater than a maxCardinality restriction"),
        MAX_CARD("The maxCardinality restriction is violated"),
        FUNC_MAX_CARD("An individual contains a minCardinality restriction that is greater than a maxCardinality restriction"),
        MAX_ZERO("The maxCardinality(0) restriction is violated"),
        NOMINAL("An individual is sameAs and differentFrom another individual at the same time"),
        EMPTY_DATATYPE("Range restrictions on a literal is inconsistent"),
        VALUE_DATATYPE("The literal value does not satisfy the datatype restriction"),
        MISSING_DATATYPE("Plain literal does not satisfy the datatype restriction (literal may be missing the rdf:datatype attribute)"),
        INVALID_LITERAL("Invalid literal for the rdf:datatype attribute"),
        DISJOINT_PROPS("Two disjoint properties have the same value"),
        BOTTOM_PROP("An individual has a value for bottom property"),
        UNEXPLAINED("Cannot explain");

        private String explanation;

        private ClashType(String string2) {
            this.explanation = string2;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

