/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class NumericPromotion {
    private BigInteger[] bigIntArgs;
    private BigDecimal[] decimalArgs;
    private Double[] doubleArgs;
    private Float[] floatArgs;
    private Type type;

    public void accept(NumericVisitor numericVisitor) {
        switch (this.type) {
            case BIGDECIMAL: {
                numericVisitor.visit(this.decimalArgs);
                break;
            }
            case BIGINTEGER: {
                numericVisitor.visit(this.bigIntArgs);
                break;
            }
            case DOUBLE: {
                numericVisitor.visit(this.doubleArgs);
                break;
            }
            case FLOAT: {
                numericVisitor.visit(this.floatArgs);
                break;
            }
            default: {
                throw new InternalReasonerException("Cannot visit type " + (Object)((Object)this.type));
            }
        }
    }

    private Type findHighestType(Number[] numberArray) {
        Type type = Type.BYTE;
        for (Number number : numberArray) {
            Type type2 = this.findType(number);
            if (!type.isLessThan(type2)) continue;
            type = type2;
        }
        return type;
    }

    private Type findType(Number number) {
        if (number instanceof Byte) {
            return Type.BYTE;
        }
        if (number instanceof Short) {
            return Type.SHORT;
        }
        if (number instanceof Integer) {
            return Type.INTEGER;
        }
        if (number instanceof Long) {
            return Type.LONG;
        }
        if (number instanceof BigInteger) {
            return Type.BIGINTEGER;
        }
        if (number instanceof BigDecimal) {
            return Type.BIGDECIMAL;
        }
        if (number instanceof Float) {
            return Type.FLOAT;
        }
        if (number instanceof Double) {
            return Type.DOUBLE;
        }
        throw new InternalReasonerException("Unexpected numeric type '" + number.getClass() + "': " + number);
    }

    private void prepArray(Type type, int n) {
        this.bigIntArgs = null;
        this.decimalArgs = null;
        this.doubleArgs = null;
        this.floatArgs = null;
        switch (type) {
            case BIGDECIMAL: {
                this.decimalArgs = new BigDecimal[n];
                break;
            }
            case BIGINTEGER: {
                this.bigIntArgs = new BigInteger[n];
                break;
            }
            case DOUBLE: {
                this.doubleArgs = new Double[n];
                break;
            }
            case FLOAT: {
                this.floatArgs = new Float[n];
                break;
            }
            default: {
                throw new InternalReasonerException("Faulty switch: Don't know how to handle '" + (Object)((Object)type) + "'.");
            }
        }
    }

    public void promote(Number ... numberArray) {
        this.promote(Type.BIGINTEGER, numberArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void promote(Number number, int n, Type type) {
        if (type.isLessThan(Type.BIGINTEGER)) {
            throw new InternalReasonerException("Cannot promote to anything less than BigInteger");
        }
        Type type2 = this.findType(number);
        if (type == Type.DOUBLE) {
            this.doubleArgs[n] = number.doubleValue();
            return;
        } else if (type == Type.FLOAT) {
            this.floatArgs[n] = Float.valueOf(number.floatValue());
            return;
        } else if (type == Type.BIGDECIMAL) {
            if (type2 == Type.BIGDECIMAL) {
                this.decimalArgs[n] = (BigDecimal)number;
                return;
            } else if (type2 == Type.BIGINTEGER) {
                this.decimalArgs[n] = new BigDecimal((BigInteger)number, 0, MathContext.DECIMAL128);
                return;
            } else {
                if (!type2.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + (Object)((Object)type2) + " to BigDecimal.");
                this.decimalArgs[n] = new BigDecimal(number.longValue(), MathContext.DECIMAL128);
            }
            return;
        } else {
            if (type != Type.BIGINTEGER) throw new InternalReasonerException("Do not know how to promote numbers to type " + (Object)((Object)type));
            if (type2 == Type.BIGINTEGER) {
                this.bigIntArgs[n] = (BigInteger)number;
                return;
            } else {
                if (!type2.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + (Object)((Object)type2) + " to BigInteger.");
                this.bigIntArgs[n] = new BigDecimal(number.longValue(), MathContext.DECIMAL128).toBigInteger();
            }
        }
    }

    private void promote(Type type, Number ... numberArray) {
        Type type2 = this.findHighestType(numberArray);
        if (type2.isLessThan(type)) {
            type2 = type;
        }
        this.prepArray(type2, numberArray.length);
        for (int i = 0; i < numberArray.length; ++i) {
            this.promote(numberArray[i], i, type2);
        }
        this.type = type2;
    }

    private static enum Type {
        BIGDECIMAL(5),
        BIGINTEGER(4),
        BYTE(0),
        DOUBLE(7),
        FLOAT(6),
        INTEGER(2),
        LONG(3),
        SHORT(1);

        private final int rank;

        private Type(int n2) {
            this.rank = n2;
        }

        public boolean isLessThan(Type type) {
            if (type == null) {
                return false;
            }
            return this.rank < type.rank;
        }
    }
}

