/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.NumericComparisonVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.Tester;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class ComparisonTesters {
    private static Logger log = Logger.getLogger(ComparisonTesters.class.getCanonicalName());
    public static final Tester equal = new EqualityTester(false);
    public static final Tester greaterThan = new OrderingTester(false, false);
    public static final Tester greaterThanOrEqual = new OrderingTester(false, true);
    public static final Tester lessThan = new OrderingTester(true, false);
    public static final Tester lessThanOrEqual = new OrderingTester(true, true);
    public static final Tester notEqual = new EqualityTester(true);

    public static Literal expectedIfEquals(Literal literal, Literal literal2) {
        if (literal == null) {
            return literal2;
        }
        if (equal.test(new Literal[]{literal, literal2})) {
            return literal;
        }
        return null;
    }

    private static class OrderingTester
    extends BinaryTester {
        private boolean lt;
        private boolean inclusive;

        private OrderingTester(boolean bl, boolean bl2) {
            this.lt = bl;
            this.inclusive = bl2;
        }

        private boolean comparesWell(int n) {
            if (this.lt && n < 0) {
                return true;
            }
            if (!this.lt && n > 0) {
                return true;
            }
            return this.inclusive && n == 0;
        }

        @Override
        public boolean test(Literal literal, Literal literal2) {
            Object object = literal.getValue();
            Object object2 = literal2.getValue();
            if (object instanceof ATermAppl && object2 instanceof ATermAppl) {
                ATermAppl aTermAppl = (ATermAppl)object;
                ATermAppl aTermAppl2 = (ATermAppl)object2;
                String string = ATermUtils.getLiteralValue(aTermAppl);
                String string2 = ATermUtils.getLiteralValue(aTermAppl2);
                String string3 = ATermUtils.getLiteralLang(aTermAppl);
                String string4 = ATermUtils.getLiteralLang(aTermAppl2);
                String string5 = ATermUtils.getLiteralDatatype(aTermAppl);
                String string6 = ATermUtils.getLiteralDatatype(aTermAppl2);
                if (string3.equals(string4) && string5.equals(string6)) {
                    return this.comparesWell(string.compareTo(string2));
                }
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                NumericPromotion numericPromotion = new NumericPromotion();
                Number number = (Number)object;
                Number number2 = (Number)object2;
                numericPromotion.promote(number, number2);
                NumericComparisonVisitor numericComparisonVisitor = new NumericComparisonVisitor();
                numericPromotion.accept(numericComparisonVisitor);
                return this.comparesWell(numericComparisonVisitor.getComparison());
            }
            DatatypeReasoner datatypeReasoner = literal.getABox().getDatatypeReasoner();
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(2);
            ATermAppl aTermAppl4 = (ATermAppl)literal2.getTerm().getArgument(2);
            try {
                if (datatypeReasoner.isSatisfiable(Arrays.asList(aTermAppl3, aTermAppl4))) {
                    Facet.XSD xSD = this.lt ? (this.inclusive ? Facet.XSD.MIN_INCLUSIVE : Facet.XSD.MIN_EXCLUSIVE) : (this.inclusive ? Facet.XSD.MAX_INCLUSIVE : Facet.XSD.MAX_EXCLUSIVE);
                    ATermAppl aTermAppl5 = datatypeReasoner.getCanonicalRepresentation(aTermAppl);
                    ATermAppl aTermAppl6 = (ATermAppl)aTermAppl5.getArgument(2);
                    ATermAppl aTermAppl7 = ATermUtils.makeRestrictedDatatype(aTermAppl6, new ATermAppl[]{ATermUtils.makeFacetRestriction(xSD.getName(), aTermAppl5)});
                    return datatypeReasoner.isSatisfiable(Collections.singleton(aTermAppl7), object2);
                }
                return false;
            }
            catch (DatatypeReasonerException datatypeReasonerException) {
                String string = String.format("Unexpected datatype reasoner exception comparaing two literals ('%s','%s'). Treating as incomparable.", aTermAppl, literal2.getTerm());
                log.log(Level.WARNING, string, datatypeReasonerException);
                return false;
            }
        }
    }

    private static class EqualityTester
    extends BinaryTester {
        private boolean flip;

        private EqualityTester(boolean bl) {
            this.flip = bl;
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            Object object = literal.getValue();
            Object object2 = literal2.getValue();
            if (object instanceof Number && object2 instanceof Number) {
                NumericPromotion numericPromotion = new NumericPromotion();
                Number number = (Number)object;
                Number number2 = (Number)object2;
                numericPromotion.promote(number, number2);
                NumericComparisonVisitor numericComparisonVisitor = new NumericComparisonVisitor();
                numericPromotion.accept(numericComparisonVisitor);
                if (numericComparisonVisitor.getComparison() == 0) {
                    return true ^ this.flip;
                }
                return false ^ this.flip;
            }
            if (literal.getValue() != null && literal2.getValue() != null) {
                return (object.getClass().equals(object2.getClass()) && object.equals(object2)) ^ this.flip;
            }
            return false;
        }
    }
}

