/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class TrivialSatisfactionHelpers {
    private static final BindingTester ALWAYS_TRUE = new BindingTester(){

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            return DependencySet.INDEPENDENT;
        }

        public String toString() {
            return "test(TRUE)";
        }
    };
    private ABox abox;

    public TrivialSatisfactionHelpers(ABox aBox) {
        this.abox = aBox;
    }

    public Collection<BindingHelper> getHelpers(Rule rule) {
        ArrayList<BindingHelper> arrayList = new ArrayList<BindingHelper>();
        BodyAtomVisitor bodyAtomVisitor = new BodyAtomVisitor();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(bodyAtomVisitor);
            if (bodyAtomVisitor.getTester() == null) continue;
            arrayList.add(new FilterHelper(bodyAtomVisitor.getTester(), VariableUtils.getVars(ruleAtom)));
        }
        return arrayList;
    }

    public DependencySet isAtomTrue(RuleAtom ruleAtom, VariableBinding variableBinding) {
        HeadAtomVisitor headAtomVisitor = new HeadAtomVisitor();
        ruleAtom.accept(headAtomVisitor);
        BindingTester bindingTester = headAtomVisitor.getTester();
        return bindingTester == null ? null : bindingTester.check(variableBinding);
    }

    private static abstract class UnaryBindingTester<R extends AtomObject>
    implements BindingTester {
        R arg;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public UnaryBindingTester(R r) {
            this.this$0 = var1_1;
            this.arg = r;
        }

        public R getArg() {
            return this.arg;
        }
    }

    private class TestSame
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestSame(AtomIObject atomIObject, AtomIObject atomIObject2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)atomIObject, (AtomObject)atomIObject2);
        }

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            Individual individual;
            Individual individual2 = variableBinding.get((AtomIObject)this.arg1);
            if (individual2.isSame(individual = variableBinding.get((AtomIObject)this.arg2))) {
                DependencySet dependencySet = individual2.getMergeDependency(true);
                DependencySet dependencySet2 = individual.getMergeDependency(true);
                return dependencySet == null ? dependencySet2 : (dependencySet2 == null ? dependencySet : dependencySet.union(dependencySet2, true));
            }
            return null;
        }
    }

    private static abstract class TestProperty<S extends AtomObject>
    extends BinaryBindingTester<AtomIObject, S> {
        Role r;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public TestProperty(ATermAppl aTermAppl, AtomIObject atomIObject, S s) {
            this.this$0 = var1_1;
            super((TrivialSatisfactionHelpers)var1_1, (AtomObject)atomIObject, s);
            this.r = ((TrivialSatisfactionHelpers)var1_1).abox.getRole((ATerm)aTermAppl);
            if (this.r == null) {
                throw new InternalReasonerException("Cannot retreive role!: " + aTermAppl);
            }
        }

        public DependencySet check(Individual individual, Node node) {
            EdgeList edgeList = individual.getRNeighborEdges(this.r);
            int n = edgeList.size();
            for (int i = 0; i < n; ++i) {
                Edge edge = edgeList.edgeAt(i);
                if (!edge.getNeighbor(individual).equals(node)) continue;
                return edge.getDepends();
            }
            return null;
        }
    }

    private class TestIndividualProperty
    extends TestProperty<AtomIObject> {
        public TestIndividualProperty(ATermAppl aTermAppl, AtomIObject atomIObject, AtomIObject atomIObject2) {
            super(TrivialSatisfactionHelpers.this, aTermAppl, atomIObject, (AtomObject)atomIObject2);
        }

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            return this.check(variableBinding.get((AtomIObject)this.getArg1()), variableBinding.get((AtomIObject)this.getArg2()));
        }
    }

    private class TestDifferent
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestDifferent(AtomIObject atomIObject, AtomIObject atomIObject2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)atomIObject, (AtomObject)atomIObject2);
        }

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            return variableBinding.get((AtomIObject)this.arg1).getDifferenceDependency(variableBinding.get((AtomIObject)this.arg2));
        }

        public String toString() {
            return "notDifferent(" + this.getArg1() + "," + this.getArg2() + ")";
        }
    }

    private class TestDataProperty
    extends TestProperty<AtomDObject> {
        public TestDataProperty(ATermAppl aTermAppl, AtomIObject atomIObject, AtomDObject atomDObject) {
            super(TrivialSatisfactionHelpers.this, aTermAppl, atomIObject, (AtomObject)atomDObject);
        }

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            return this.check(variableBinding.get((AtomIObject)this.getArg1()), variableBinding.get((AtomDObject)this.getArg2()));
        }
    }

    private class TestClass
    extends UnaryBindingTester<AtomIObject> {
        private ATermAppl c;

        public TestClass(ATermAppl aTermAppl, AtomIObject atomIObject) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)atomIObject);
            this.c = aTermAppl;
        }

        @Override
        public DependencySet check(VariableBinding variableBinding) {
            Individual individual = variableBinding.get((AtomIObject)this.getArg());
            return individual.getDepends((ATerm)this.c);
        }

        public String toString() {
            return "notClass(" + this.getArg() + ":" + this.c + ")";
        }
    }

    private class HeadAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester tester = null;

        private HeadAtomVisitor() {
        }

        public BindingTester getTester() {
            return this.tester;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            this.tester = ALWAYS_TRUE;
        }

        @Override
        public void visit(ClassAtom classAtom) {
            this.tester = new TestClass(ATermUtils.normalize((ATermAppl)classAtom.getPredicate()), (AtomIObject)classAtom.getArgument());
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.tester = ALWAYS_TRUE;
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.tester = new TestDataProperty((ATermAppl)datavaluedPropertyAtom.getPredicate(), (AtomIObject)datavaluedPropertyAtom.getArgument1(), (AtomDObject)datavaluedPropertyAtom.getArgument2());
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            this.tester = new TestDifferent((AtomIObject)differentIndividualsAtom.getArgument1(), (AtomIObject)differentIndividualsAtom.getArgument2());
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            this.tester = new TestIndividualProperty((ATermAppl)individualPropertyAtom.getPredicate(), (AtomIObject)individualPropertyAtom.getArgument1(), (AtomIObject)individualPropertyAtom.getArgument2());
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            this.tester = new TestSame((AtomIObject)sameIndividualAtom.getArgument1(), (AtomIObject)sameIndividualAtom.getArgument2());
        }
    }

    private static class FilterHelper
    implements BindingHelper {
        private boolean result = false;
        private BindingTester tester;
        private Collection<? extends AtomVariable> vars;

        public FilterHelper(BindingTester bindingTester, Collection<? extends AtomVariable> collection) {
            this.tester = bindingTester;
            this.vars = collection;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
            return this.vars;
        }

        @Override
        public void rebind(VariableBinding variableBinding) {
            this.result = this.tester.check(variableBinding) == null;
        }

        @Override
        public boolean selectNextBinding() {
            boolean bl = this.result;
            this.result = false;
            return bl;
        }

        @Override
        public void setCurrentBinding(VariableBinding variableBinding) {
        }

        public String toString() {
            return "Filter(" + this.tester + ")";
        }
    }

    private class BodyAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester tester = null;

        private BodyAtomVisitor() {
        }

        public BindingTester getTester() {
            return this.tester;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            this.tester = null;
        }

        @Override
        public void visit(ClassAtom classAtom) {
            this.tester = new TestClass(ATermUtils.normalize(ATermUtils.negate((ATermAppl)classAtom.getPredicate())), (AtomIObject)classAtom.getArgument());
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.tester = null;
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.tester = null;
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            this.tester = new TestSame((AtomIObject)differentIndividualsAtom.getArgument1(), (AtomIObject)differentIndividualsAtom.getArgument2());
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            this.tester = null;
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            this.tester = new TestDifferent((AtomIObject)sameIndividualAtom.getArgument1(), (AtomIObject)sameIndividualAtom.getArgument2());
        }
    }

    private static interface BindingTester {
        public DependencySet check(VariableBinding var1);
    }

    private static abstract class BinaryBindingTester<R extends AtomObject, S extends AtomObject>
    implements BindingTester {
        R arg1;
        S arg2;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public BinaryBindingTester(R r, S s) {
            this.this$0 = var1_1;
            this.arg1 = r;
            this.arg2 = s;
        }

        public R getArg1() {
            return this.arg1;
        }

        public S getArg2() {
            return this.arg2;
        }
    }
}

