/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.BindingGenerator;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mindswap.pellet.ABox;

public class BindingGeneratorImpl
implements BindingGenerator {
    private Collection<BindingHelper> helpers;
    private VariableBinding initialBinding;

    public BindingGeneratorImpl() {
        this.helpers = Collections.emptySet();
    }

    public BindingGeneratorImpl(ABox aBox, VariableBinding variableBinding, Collection<BindingHelper> collection) {
        this.helpers = collection;
        this.initialBinding = variableBinding;
    }

    @Override
    public Iterator<VariableBinding> iterator() {
        return new BindingIterator();
    }

    private class BindingIterator
    implements Iterator<VariableBinding> {
        private VariableBinding binding;
        private BindingHelper[] helperChain;

        public BindingIterator() {
            this.helperChain = new BindingHelper[BindingGeneratorImpl.this.helpers.size()];
            this.helperChain = BindingGeneratorImpl.this.helpers.toArray(this.helperChain);
            if (this.helperChain.length > 0) {
                this.helperChain[0].rebind(BindingGeneratorImpl.this.initialBinding);
            }
        }

        private VariableBinding getBinding(int n) {
            VariableBinding variableBinding = new VariableBinding(BindingGeneratorImpl.this.initialBinding);
            for (int i = 0; i <= n; ++i) {
                this.helperChain[i].setCurrentBinding(variableBinding);
            }
            return variableBinding;
        }

        @Override
        public boolean hasNext() {
            if (this.binding != null) {
                return true;
            }
            VariableBinding variableBinding = null;
            int n = this.helperChain.length - 1;
            while (n >= 0) {
                if (this.helperChain[n].selectNextBinding()) {
                    if (variableBinding == null) {
                        variableBinding = this.getBinding(n);
                    } else {
                        this.helperChain[n].setCurrentBinding(variableBinding);
                    }
                    if (n < this.helperChain.length - 1) {
                        this.helperChain[n + 1].rebind(variableBinding);
                        ++n;
                        continue;
                    }
                    this.binding = variableBinding;
                    return true;
                }
                variableBinding = null;
                --n;
            }
            return false;
        }

        @Override
        public VariableBinding next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            VariableBinding variableBinding = this.binding;
            this.binding = null;
            return variableBinding;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

