/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDDecimal
implements Datatype<Number> {
    private static final XSDDecimal instance;
    private static final Logger log;
    private final RestrictedRealDatatype dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal");

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedRealDatatype(this, OWLRealInterval.allReals());
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            BigDecimal bigDecimal = DatatypeConverter.parseDecimal(string);
            String string2 = DatatypeConverter.printDecimal(bigDecimal);
            if (string2.equals(string)) {
                return aTermAppl;
            }
            return ATermUtils.makeTypedLiteral(string2, this.name);
        }
        catch (NumberFormatException numberFormatException) {
            log.severe(String.format("Number format exception (%s) cause while parsing decimal %s", numberFormatException.getMessage(), string));
            throw new InvalidLiteralException(this.name, string);
        }
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (this.dataRange.contains(object)) {
            return ATermUtils.makeTypedLiteral(OWLRealUtils.print((Number)object), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.name, string);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        log = Logger.getLogger(XSDDecimal.class.getCanonicalName());
        instance = new XSDDecimal();
    }
}

