/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.clarkparsia.owlapiv3.OntologyUtils;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWL {
    public static final OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    public static final OWLDataFactory factory = manager.getOWLDataFactory();
    public static final OWLClass Nothing = factory.getOWLNothing();
    public static final OWLClass Thing = factory.getOWLThing();
    public static final OWLObjectProperty topObjectProperty = OWL.ObjectProperty("http://www.w3.org/2002/07/owl#topObjectProperty");
    public static final OWLObjectProperty bottomObjectProperty = OWL.ObjectProperty("http://www.w3.org/2002/07/owl#bottomObjectProperty");
    public static final OWLDataProperty topDataProperty = OWL.DataProperty("http://www.w3.org/2002/07/owl#topDataProperty");
    public static final OWLDataProperty bottomDataProperty = OWL.DataProperty("http://www.w3.org/2002/07/owl#bottomDataProperty");

    public static OWLOntology Ontology(Collection<? extends OWLAxiom> collection) {
        IRI iRI = IRI.create((String)("http://www.example.org/ontology" + new UID()));
        return OWL.Ontology(collection, iRI);
    }

    public static OWLOntology Ontology(Collection<? extends OWLAxiom> collection, IRI iRI) {
        OWLOntology oWLOntology;
        try {
            oWLOntology = manager.createOntology(iRI);
            OntologyUtils.addAxioms(oWLOntology, collection);
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new RuntimeException(oWLOntologyCreationException);
        }
        catch (OWLOntologyChangeException oWLOntologyChangeException) {
            throw new RuntimeException(oWLOntologyChangeException);
        }
        return oWLOntology;
    }

    public static OWLOntology Ontology(OWLAxiom ... oWLAxiomArray) {
        return OWL.Ontology(Arrays.asList(oWLAxiomArray));
    }

    public static OWLDataAllValuesFrom all(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataRange oWLDataRange) {
        return factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectAllValuesFrom all(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLObjectAllValuesFrom allValuesFrom(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLObjectIntersectionOf and(OWLClassExpression ... oWLClassExpressionArray) {
        return factory.getOWLObjectIntersectionOf(OWL.set(oWLClassExpressionArray));
    }

    public static OWLObjectIntersectionOf and(Set<? extends OWLClassExpression> set) {
        return factory.getOWLObjectIntersectionOf(set);
    }

    public static OWLDataIntersectionOf dataAnd(OWLDataRange ... oWLDataRangeArray) {
        return factory.getOWLDataIntersectionOf(OWL.set(oWLDataRangeArray));
    }

    public static OWLDataIntersectionOf dataAnd(Set<? extends OWLDataRange> set) {
        return factory.getOWLDataIntersectionOf(set);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity oWLEntity, OWLAnnotation oWLAnnotation) {
        return factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)oWLEntity.getIRI(), oWLAnnotation);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity oWLEntity, IRI iRI, OWLLiteral oWLLiteral) {
        return factory.getOWLAnnotationAssertionAxiom(factory.getOWLAnnotationProperty(iRI), (OWLAnnotationSubject)oWLEntity.getIRI(), (OWLAnnotationValue)oWLLiteral);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity oWLEntity, IRI iRI, OWLIndividual oWLIndividual) {
        if (oWLIndividual.isAnonymous()) {
            return factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)oWLEntity.getIRI(), factory.getOWLAnnotation(factory.getOWLAnnotationProperty(iRI), (OWLAnnotationValue)oWLIndividual.asOWLAnonymousIndividual()));
        }
        return factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)oWLEntity.getIRI(), factory.getOWLAnnotation(factory.getOWLAnnotationProperty(iRI), (OWLAnnotationValue)oWLIndividual.asOWLNamedIndividual().getIRI()));
    }

    public static OWLAnonymousIndividual AnonymousIndividual() {
        return factory.getOWLAnonymousIndividual();
    }

    public static OWLAnonymousIndividual AnonymousIndividual(String string) {
        return factory.getOWLAnonymousIndividual(string);
    }

    public static OWLAsymmetricObjectPropertyAxiom asymmetric(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLAsymmetricObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLClass Class(String string) {
        return factory.getOWLClass(IRI.create((String)string));
    }

    public static OWLClass Class(IRI iRI) {
        return factory.getOWLClass(iRI);
    }

    public static OWLClassAssertionAxiom classAssertion(OWLIndividual oWLIndividual, OWLClassExpression oWLClassExpression) {
        return factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual);
    }

    public static OWLAnnotationAssertionAxiom comment(OWLEntity oWLEntity, String string) {
        return factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)oWLEntity.getIRI(), factory.getOWLAnnotation(factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI()), (OWLAnnotationValue)factory.getOWLLiteral(string)));
    }

    public static OWLObjectComplementOf complementOf(OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectComplementOf(oWLClassExpression);
    }

    public static OWLLiteral constant(boolean bl) {
        return factory.getOWLLiteral(bl);
    }

    public static OWLLiteral constant(double d) {
        return factory.getOWLLiteral(d);
    }

    public static OWLLiteral constant(float f) {
        return factory.getOWLLiteral(f);
    }

    public static OWLLiteral constant(int n) {
        return factory.getOWLLiteral(n);
    }

    public static OWLLiteral constant(String string) {
        return factory.getOWLLiteral(string);
    }

    public static OWLLiteral constant(String string, OWLDatatype oWLDatatype) {
        return factory.getOWLLiteral(string, oWLDatatype);
    }

    public static OWLLiteral constant(String string, String string2) {
        return factory.getOWLLiteral(string, string2);
    }

    public static OWLDataProperty DataProperty(String string) {
        return factory.getOWLDataProperty(IRI.create((String)string));
    }

    public static OWLDataProperty DataProperty(IRI iRI) {
        return factory.getOWLDataProperty(iRI);
    }

    public static OWLDatatype Datatype(String string) {
        return factory.getOWLDatatype(IRI.create((String)string));
    }

    public static OWLDatatype Datatype(IRI iRI) {
        return factory.getOWLDatatype(iRI);
    }

    public static OWLDeclarationAxiom declaration(OWLEntity oWLEntity) {
        return factory.getOWLDeclarationAxiom(oWLEntity);
    }

    public static OWLDifferentIndividualsAxiom differentFrom(OWLIndividual oWLIndividual, OWLIndividual oWLIndividual2) {
        return factory.getOWLDifferentIndividualsAxiom(OWL.set(oWLIndividual, oWLIndividual2));
    }

    public static OWLDifferentIndividualsAxiom differentFrom(Set<OWLIndividual> set) {
        return factory.getOWLDifferentIndividualsAxiom(set);
    }

    public static OWLDisjointClassesAxiom disjointClasses(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        return factory.getOWLDisjointClassesAxiom(OWL.set(oWLClassExpression, oWLClassExpression2));
    }

    public static OWLDisjointClassesAxiom disjointClasses(Set<? extends OWLClassExpression> set) {
        return factory.getOWLDisjointClassesAxiom(set);
    }

    public static OWLDisjointDataPropertiesAxiom disjointProperties(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataPropertyExpression oWLDataPropertyExpression2) {
        return factory.getOWLDisjointDataPropertiesAxiom(OWL.set(oWLDataPropertyExpression, oWLDataPropertyExpression2));
    }

    public static OWLDisjointObjectPropertiesAxiom disjointProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        return factory.getOWLDisjointObjectPropertiesAxiom(OWL.set(oWLObjectPropertyExpression, oWLObjectPropertyExpression2));
    }

    public static OWLDataPropertyDomainAxiom domain(OWLDataPropertyExpression oWLDataPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLDataPropertyDomainAxiom(oWLDataPropertyExpression, oWLClassExpression);
    }

    public static OWLObjectPropertyDomainAxiom domain(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectPropertyDomainAxiom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLDatatypeDefinitionAxiom datatypeDefinition(OWLDatatype oWLDatatype, OWLDataRange oWLDataRange) {
        return factory.getOWLDatatypeDefinitionAxiom(oWLDatatype, oWLDataRange);
    }

    public static OWLEquivalentClassesAxiom equivalentClasses(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        return factory.getOWLEquivalentClassesAxiom(OWL.set(oWLClassExpression, oWLClassExpression2));
    }

    public static OWLEquivalentClassesAxiom equivalentClasses(Set<? extends OWLClassExpression> set) {
        return factory.getOWLEquivalentClassesAxiom(set);
    }

    public static OWLEquivalentDataPropertiesAxiom equivalentDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataPropertyExpression oWLDataPropertyExpression2) {
        return factory.getOWLEquivalentDataPropertiesAxiom(OWL.set(oWLDataPropertyExpression, oWLDataPropertyExpression2));
    }

    public static OWLEquivalentDataPropertiesAxiom equivalentDataProperties(Set<? extends OWLDataPropertyExpression> set) {
        return factory.getOWLEquivalentDataPropertiesAxiom(set);
    }

    public static OWLEquivalentObjectPropertiesAxiom equivalentProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        return factory.getOWLEquivalentObjectPropertiesAxiom(OWL.set(oWLObjectPropertyExpression, oWLObjectPropertyExpression2));
    }

    public static OWLEquivalentObjectPropertiesAxiom equivalentProperties(Set<? extends OWLObjectPropertyExpression> set) {
        return factory.getOWLEquivalentObjectPropertiesAxiom(set);
    }

    public static OWLClassExpression exactly(OWLDataProperty oWLDataProperty, int n) {
        return factory.getOWLDataExactCardinality(n, (OWLDataPropertyExpression)oWLDataProperty);
    }

    public static OWLClassExpression exactly(OWLDataProperty oWLDataProperty, int n, OWLDataRange oWLDataRange) {
        return factory.getOWLDataExactCardinality(n, (OWLDataPropertyExpression)oWLDataProperty, oWLDataRange);
    }

    public static OWLClassExpression exactly(OWLObjectProperty oWLObjectProperty, int n) {
        return factory.getOWLObjectExactCardinality(n, (OWLObjectPropertyExpression)oWLObjectProperty);
    }

    public static OWLClassExpression exactly(OWLObjectProperty oWLObjectProperty, int n, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectExactCardinality(n, (OWLObjectPropertyExpression)oWLObjectProperty, oWLClassExpression);
    }

    public static OWLFunctionalDataPropertyAxiom functional(OWLDataPropertyExpression oWLDataPropertyExpression) {
        return factory.getOWLFunctionalDataPropertyAxiom(oWLDataPropertyExpression);
    }

    public static OWLFunctionalObjectPropertyAxiom functional(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLFunctionalObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLNamedIndividual Individual(String string) {
        return factory.getOWLNamedIndividual(IRI.create((String)string));
    }

    public static OWLNamedIndividual Individual(IRI iRI) {
        return factory.getOWLNamedIndividual(iRI);
    }

    public static OWLObjectInverseOf inverse(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLObjectInverseOf(oWLObjectPropertyExpression);
    }

    public static OWLInverseFunctionalObjectPropertyAxiom inverseFunctional(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLInverseFunctionalObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLInverseObjectPropertiesAxiom inverseProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        return factory.getOWLInverseObjectPropertiesAxiom(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
    }

    public static OWLIrreflexiveObjectPropertyAxiom irreflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLIrreflexiveObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLAnnotationAssertionAxiom label(OWLEntity oWLEntity, String string) {
        return factory.getOWLAnnotationAssertionAxiom(factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI()), (OWLAnnotationSubject)oWLEntity.getIRI(), (OWLAnnotationValue)factory.getOWLLiteral(string));
    }

    public static OWLFacetRestriction length(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.LENGTH, n);
    }

    public static OWLFacetRestriction length(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.LENGTH, oWLLiteral);
    }

    public static OWLDataMaxCardinality max(OWLDataPropertyExpression oWLDataPropertyExpression, int n) {
        return factory.getOWLDataMaxCardinality(n, oWLDataPropertyExpression);
    }

    public static OWLDataMaxCardinality max(OWLDataPropertyExpression oWLDataPropertyExpression, int n, OWLDataRange oWLDataRange) {
        return factory.getOWLDataMaxCardinality(n, oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectMaxCardinality max(OWLObjectPropertyExpression oWLObjectPropertyExpression, int n) {
        return factory.getOWLObjectMaxCardinality(n, oWLObjectPropertyExpression);
    }

    public static OWLObjectMaxCardinality max(OWLObjectPropertyExpression oWLObjectPropertyExpression, int n, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectMaxCardinality(n, oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLFacetRestriction maxExclusive(double d) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, d);
    }

    public static OWLFacetRestriction maxExclusive(float f) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, f);
    }

    public static OWLFacetRestriction maxExclusive(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, n);
    }

    public static OWLFacetRestriction maxExclusive(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, oWLLiteral);
    }

    public static OWLFacetRestriction maxInclusive(double d) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, d);
    }

    public static OWLFacetRestriction maxInclusive(float f) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, f);
    }

    public static OWLFacetRestriction maxInclusive(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, n);
    }

    public static OWLFacetRestriction maxInclusive(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, oWLLiteral);
    }

    public static OWLFacetRestriction maxLength(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, n);
    }

    public static OWLFacetRestriction maxLength(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, oWLLiteral);
    }

    public static OWLDataMinCardinality min(OWLDataPropertyExpression oWLDataPropertyExpression, int n) {
        return factory.getOWLDataMinCardinality(n, oWLDataPropertyExpression);
    }

    public static OWLDataMinCardinality min(OWLDataPropertyExpression oWLDataPropertyExpression, int n, OWLDataRange oWLDataRange) {
        return factory.getOWLDataMinCardinality(n, oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectMinCardinality min(OWLObjectPropertyExpression oWLObjectPropertyExpression, int n) {
        return factory.getOWLObjectMinCardinality(n, oWLObjectPropertyExpression);
    }

    public static OWLObjectMinCardinality min(OWLObjectPropertyExpression oWLObjectPropertyExpression, int n, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectMinCardinality(n, oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLFacetRestriction minExclusive(double d) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, d);
    }

    public static OWLFacetRestriction minExclusive(float f) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, f);
    }

    public static OWLFacetRestriction minExclusive(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, n);
    }

    public static OWLFacetRestriction minExclusive(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, oWLLiteral);
    }

    public static OWLFacetRestriction minInclusive(double d) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, d);
    }

    public static OWLFacetRestriction minInclusive(float f) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, f);
    }

    public static OWLFacetRestriction minInclusive(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, n);
    }

    public static OWLFacetRestriction minInclusive(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, oWLLiteral);
    }

    public static OWLFacetRestriction minLength(int n) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_LENGTH, n);
    }

    public static OWLFacetRestriction minLength(OWLLiteral oWLLiteral) {
        return factory.getOWLFacetRestriction(OWLFacet.MIN_LENGTH, oWLLiteral);
    }

    public static OWLObjectComplementOf not(OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectComplementOf(oWLClassExpression);
    }

    public static OWLDataComplementOf dataNot(OWLDataRange oWLDataRange) {
        return factory.getOWLDataComplementOf(oWLDataRange);
    }

    public static OWLObjectProperty ObjectProperty(String string) {
        return factory.getOWLObjectProperty(IRI.create((String)string));
    }

    public static OWLObjectProperty ObjectProperty(IRI iRI) {
        return factory.getOWLObjectProperty(iRI);
    }

    public static OWLDataOneOf oneOf(OWLLiteral ... oWLLiteralArray) {
        return factory.getOWLDataOneOf(OWL.set(oWLLiteralArray));
    }

    public static OWLObjectOneOf oneOf(OWLIndividual ... oWLIndividualArray) {
        return factory.getOWLObjectOneOf(OWL.set(oWLIndividualArray));
    }

    public static OWLDataOneOf dataOneOf(Set<? extends OWLLiteral> set) {
        return factory.getOWLDataOneOf(set);
    }

    public static OWLObjectOneOf objectOneOf(Set<OWLIndividual> set) {
        return factory.getOWLObjectOneOf(set);
    }

    public static OWLDataAllValuesFrom only(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataRange oWLDataRange) {
        return factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectAllValuesFrom only(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLObjectUnionOf or(OWLClassExpression ... oWLClassExpressionArray) {
        return factory.getOWLObjectUnionOf(OWL.set(oWLClassExpressionArray));
    }

    public static OWLObjectUnionOf or(Set<? extends OWLClassExpression> set) {
        return factory.getOWLObjectUnionOf(set);
    }

    public static OWLDataUnionOf dataOr(OWLDataRange ... oWLDataRangeArray) {
        return factory.getOWLDataUnionOf(OWL.set(oWLDataRangeArray));
    }

    public static OWLDataUnionOf dataOr(Set<? extends OWLDataRange> set) {
        return factory.getOWLDataUnionOf(set);
    }

    public static OWLDataPropertyAssertionAxiom propertyAssertion(OWLIndividual oWLIndividual, OWLDataPropertyExpression oWLDataPropertyExpression, OWLLiteral oWLLiteral) {
        return factory.getOWLDataPropertyAssertionAxiom(oWLDataPropertyExpression, oWLIndividual, oWLLiteral);
    }

    public static OWLObjectPropertyAssertionAxiom propertyAssertion(OWLIndividual oWLIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLIndividual oWLIndividual2) {
        return factory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLIndividual, oWLIndividual2);
    }

    public static OWLDataPropertyRangeAxiom range(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataRange oWLDataRange) {
        return factory.getOWLDataPropertyRangeAxiom(oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectPropertyRangeAxiom range(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectPropertyRangeAxiom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLReflexiveObjectPropertyAxiom reflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLReflexiveObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLDataRange restrict(OWLDatatype oWLDatatype, OWLFacetRestriction ... oWLFacetRestrictionArray) {
        return factory.getOWLDatatypeRestriction(oWLDatatype, oWLFacetRestrictionArray);
    }

    public static OWLDataRange restrict(OWLDatatype oWLDatatype, Set<OWLFacetRestriction> set) {
        return factory.getOWLDatatypeRestriction(oWLDatatype, set);
    }

    public static OWLSameIndividualAxiom sameAs(OWLIndividual oWLIndividual, OWLIndividual oWLIndividual2) {
        return factory.getOWLSameIndividualAxiom(OWL.set(oWLIndividual, oWLIndividual2));
    }

    public static OWLSameIndividualAxiom sameAs(Set<OWLIndividual> set) {
        return factory.getOWLSameIndividualAxiom(set);
    }

    public static OWLObjectHasSelf self(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLObjectHasSelf(oWLObjectPropertyExpression);
    }

    private static <T> Set<T> set(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    private static <T> Set<T> set(T t, T t2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.add(t);
        hashSet.add(t2);
        return hashSet;
    }

    public static OWLDataSomeValuesFrom some(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataRange oWLDataRange) {
        return factory.getOWLDataSomeValuesFrom(oWLDataPropertyExpression, oWLDataRange);
    }

    public static OWLObjectSomeValuesFrom some(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLClassExpression oWLClassExpression) {
        return factory.getOWLObjectSomeValuesFrom(oWLObjectPropertyExpression, oWLClassExpression);
    }

    public static OWLSubClassOfAxiom subClassOf(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        return factory.getOWLSubClassOfAxiom(oWLClassExpression, oWLClassExpression2);
    }

    public static OWLSubDataPropertyOfAxiom subPropertyOf(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataPropertyExpression oWLDataPropertyExpression2) {
        return factory.getOWLSubDataPropertyOfAxiom(oWLDataPropertyExpression, oWLDataPropertyExpression2);
    }

    public static OWLSubObjectPropertyOfAxiom subPropertyOf(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        return factory.getOWLSubObjectPropertyOfAxiom(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
    }

    public static OWLSubPropertyChainOfAxiom subPropertyOf(OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLSubPropertyChainOfAxiom(Arrays.asList(oWLObjectPropertyExpressionArray), oWLObjectPropertyExpression);
    }

    public static OWLSymmetricObjectPropertyAxiom symmetric(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLSymmetricObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLTransitiveObjectPropertyAxiom transitive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return factory.getOWLTransitiveObjectPropertyAxiom(oWLObjectPropertyExpression);
    }

    public static OWLDataHasValue value(OWLDataPropertyExpression oWLDataPropertyExpression, OWLLiteral oWLLiteral) {
        return factory.getOWLDataHasValue(oWLDataPropertyExpression, oWLLiteral);
    }

    public static OWLObjectHasValue value(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLIndividual oWLIndividual) {
        return factory.getOWLObjectHasValue(oWLObjectPropertyExpression, oWLIndividual);
    }
}

