/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.lib.StringAbbrev;
import com.hp.hpl.jena.tdb.nodetable.Nodec;
import java.nio.ByteBuffer;
import org.apache.jena.atlas.io.BlockUTF8;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.riot.web.LangTag;

public class NodecSSE
implements Nodec {
    private static boolean SafeChars = false;
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    @Override
    public int maxSize(Node node) {
        return NodecSSE.maxLength(node);
    }

    @Override
    public int encode(Node node, ByteBuffer bb, PrefixMapping pmap) {
        String lang;
        String x;
        if (node.isURI() && (x = StrUtils.encodeHex((String)node.getURI(), (char)'_', (char[])invalidIRIChars)) != node.getURI()) {
            node = Node.createURI((String)x);
        }
        if (node.isLiteral() && node.getLiteralLanguage() != null && !LangTag.check((String)(lang = node.getLiteralLanguage()))) {
            throw new TDBException("bad language tag: " + node);
        }
        String str = NodeFmtLib.serialize(node);
        BlockUTF8.fromChars((CharSequence)str, (ByteBuffer)bb);
        bb.flip();
        return bb.limit();
    }

    @Override
    public Node decode(ByteBuffer bb, PrefixMapping pmap) {
        String str = BlockUTF8.toString((ByteBuffer)bb);
        if (str.startsWith("_:")) {
            str = str.substring(2);
            return Node.createAnon((AnonId)new AnonId(str));
        }
        if (str.startsWith("<")) {
            str = str.substring(1, str.length() - 1);
            str = StrUtils.unescapeString((String)str);
            str = StrUtils.decodeHex((String)str, (char)'_');
            return Node.createURI((String)str);
        }
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)str);
        if (!tokenizer.hasNext()) {
            throw new TDBException("Failed to tokenise: " + str);
        }
        Token t = tokenizer.next();
        try {
            Node n = t.asNode();
            if (n == null) {
                throw new TDBException("Not a node: " + str);
            }
            return n;
        }
        catch (RiotException ex) {
            throw new TDBException("Bad string for node: " + str);
        }
    }

    private static int maxLength(Node node) {
        if (node.isBlank()) {
            return 2 + NodecSSE.maxLength(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            return 2 + NodecSSE.maxLength(node.getURI());
        }
        if (node.isLiteral()) {
            if (node.getLiteralDatatypeURI() != null) {
                return 6 + NodecSSE.maxLength(node.getLiteralLexicalForm()) + NodecSSE.maxLength(node.getLiteralDatatypeURI());
            }
            if (node.getLiteralLanguage() != null) {
                return 3 + NodecSSE.maxLength(node.getLiteralLexicalForm()) + node.getLiteralLanguage().length();
            }
            return 2 + NodecSSE.maxLength(node.getLiteralLexicalForm());
        }
        if (node.isVariable()) {
            return 1 + NodecSSE.maxLength(node.getName());
        }
        throw new TDBException("Unrecognized node type: " + node);
    }

    private static int maxLength(String string) {
        return string.length() * 3;
    }

    private String compress(String str) {
        return str;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }
}

