/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.SyntaxLabels;

public class SinkQuadOutput
implements Sink<Quad> {
    private Prologue prologue = null;
    private Writer out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkQuadOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.asBufferedUTF8(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Quad quad) {
        try {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = quad.getGraph();
            this.nodeFmt.format(this.out, s);
            this.out.write(" ");
            this.nodeFmt.format(this.out, p);
            this.out.write(" ");
            this.nodeFmt.format(this.out, o);
            if (SinkQuadOutput.outputGraphSlot(g)) {
                this.out.write(" ");
                this.nodeFmt.format(this.out, g);
            }
            this.out.write(" .\n");
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void close() {
        IO.flush(this.out);
    }
}

