/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDUnsignedLong
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedLong instance;
    private static final BigInteger MAX_VALUE;

    public static XSDUnsignedLong getInstance() {
        return instance;
    }

    private XSDUnsignedLong() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedLong"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            BigInteger bigInteger = DatatypeConverter.parseInteger(string);
            if (BigInteger.ZERO.compareTo(bigInteger) > 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            if (MAX_VALUE.compareTo(bigInteger) < 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    static {
        MAX_VALUE = new BigInteger("18446744073709551615");
        instance = new XSDUnsignedLong();
    }
}

