/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import org.mindswap.pellet.utils.ATermUtils;

public class OWLReal
extends AbstractBaseDatatype<Number> {
    private static final OWLReal instance = new OWLReal();
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLReal getInstance() {
        return instance;
    }

    private OWLReal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#real"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        throw new InvalidLiteralException(this.getName(), string);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof Rational) {
            return OWLRational.getInstance().getLiteral(object);
        }
        if (object instanceof Number) {
            try {
                return XSDDecimal.getInstance().getLiteral(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        throw new InvalidLiteralException(this.getName(), string);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

