/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.atlas.lib.MultiMapToList;
import org.apache.jena.atlas.lib.MultiMapToSet;

public abstract class MultiMap<K, V> {
    private Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    protected abstract Collection<V> createCollection();

    public static <K, V> MultiMapToList<K, V> createMapList() {
        return new MultiMapToList();
    }

    public static <K, V> MultiMapToSet<K, V> createMapSet() {
        return new MultiMapToSet();
    }

    protected MultiMap() {
    }

    protected Collection<V> getByKey(K key) {
        return this.map.get(key);
    }

    public abstract Collection<V> get(K var1);

    public V getOne(K key) {
        Collection<V> c = this.map.get(key);
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.iterator().next();
    }

    public void putAll(K key, V ... values) {
        for (V v : values) {
            this.put(key, v);
        }
    }

    public void put(K key, V value) {
        Collection<V> x = this.map.get(key);
        if (x == null) {
            x = this.createCollection();
            this.map.put(key, x);
        }
        x.add(value);
    }

    public void remove(K key, V value) {
        if (this.map.containsKey(key)) {
            this.map.get(key).remove(value);
        }
    }

    public void removeKey(K key) {
        this.map.remove(key);
    }

    protected Collection<V> valuesForKey(K key) {
        return this.map.get(key);
    }

    public abstract Collection<V> values(K var1);

    public abstract Collection<V> values();

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator<V> flatten() {
        IteratorConcat<V> all = new IteratorConcat<V>();
        for (K k : this.map.keySet()) {
            Collection<V> x = this.map.get(k);
            all.add(x.iterator());
        }
        return all;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMap other = (MultiMap)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public int hashCode() {
        return this.map.hashCode() ^ 0x1010101;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean firstKey = true;
        for (K key : this.keys()) {
            if (!firstKey) {
                sb.append(", ");
            }
            firstKey = false;
            sb.append(key);
            sb.append(" => [");
            boolean firstValue = true;
            for (V value : this.values(key)) {
                if (firstValue) {
                    sb.append(" ");
                } else {
                    sb.append(", ");
                }
                sb.append(value);
                firstValue = false;
            }
            sb.append(" ] ");
        }
        sb.append("}");
        return sb.toString();
    }
}

