/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure.binary;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermFwdVoid;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermLong;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jjtraveler.VisitFailure;

public class BinaryWriter
extends ATermFwdVoid {
    private static final int ISSHAREDFLAG = 128;
    private static final int ANNOSFLAG = 16;
    private static final int ISFUNSHARED = 64;
    private static final int APPLQUOTED = 32;
    private static final int STACKSIZE = 256;
    private static final int MINIMUMFREESPACE = 10;
    private final Map<ATerm, Integer> sharedTerms = new HashMap<ATerm, Integer>();
    private int currentKey = 0;
    private final Map<AFun, Integer> applSignatures = new HashMap<AFun, Integer>();
    private int sigKey = 0;
    private ATermMapping[] stack = new ATermMapping[256];
    private int stackPosition = 0;
    private ATerm currentTerm;
    private int indexInTerm;
    private byte[] tempNameWriteBuffer;
    private ByteBuffer currentBuffer;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;
    private static final int LONGBITS = 8;

    public BinaryWriter(ATerm root) {
        ATermMapping tm = new ATermMapping();
        tm.term = root;
        this.stack[this.stackPosition] = tm;
        this.currentTerm = root;
        this.indexInTerm = 0;
        this.tempNameWriteBuffer = null;
    }

    public void serialize(ByteBuffer buffer) throws VisitFailure {
        this.currentBuffer = buffer;
        while (this.currentTerm != null && buffer.remaining() >= 10) {
            Integer id = this.sharedTerms.get(this.currentTerm);
            if (id != null) {
                buffer.put((byte)-128);
                this.writeInt(id);
                --this.stackPosition;
            } else {
                this.visit(this.currentTerm);
                if (this.currentTerm.getType() == 4) {
                    this.stack[this.stackPosition].nextPartOfList = (ATermList)this.currentTerm;
                }
                if (this.indexInTerm != 0) break;
                this.sharedTerms.put(this.currentTerm, new Integer(this.currentKey++));
            }
            this.currentTerm = this.getNextTerm();
        }
        buffer.flip();
    }

    public boolean isFinished() {
        return this.currentTerm == null;
    }

    private ATerm getNextTerm() {
        ATerm next = null;
        this.ensureStackCapacity();
        while (next == null && this.stackPosition > -1) {
            ATermMapping current = this.stack[this.stackPosition];
            ATerm term = current.term;
            if (term.getChildCount() > current.subTermIndex + 1) {
                if (term.getType() != 4) {
                    next = (ATerm)term.getChildAt(++current.subTermIndex);
                } else {
                    ATermList nextList = current.nextPartOfList;
                    next = nextList.getFirst();
                    current.nextPartOfList = nextList.getNext();
                    ++current.subTermIndex;
                }
                ATermMapping child = new ATermMapping();
                child.term = next;
                this.stack[++this.stackPosition] = child;
                continue;
            }
            if (!current.annosDone && term.hasAnnotations()) {
                next = term.getAnnotations();
                ATermMapping annos = new ATermMapping();
                annos.term = next;
                this.stack[++this.stackPosition] = annos;
                current.annosDone = true;
                continue;
            }
            --this.stackPosition;
        }
        return next;
    }

    private void ensureStackCapacity() {
        int stackSize = this.stack.length;
        if (this.stackPosition + 1 == stackSize) {
            ATermMapping[] newStack = new ATermMapping[stackSize << 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
    }

    private byte getHeader(ATerm term) {
        byte header = (byte)term.getType();
        if (term.hasAnnotations()) {
            header = (byte)(header | 0x10);
        }
        return header;
    }

    public void voidVisitAppl(ATermAppl arg) throws VisitFailure {
        if (this.indexInTerm == 0) {
            byte header = this.getHeader(arg);
            AFun fun = arg.getAFun();
            Integer key = this.applSignatures.get(fun);
            if (key == null) {
                if (arg.isQuoted()) {
                    header = (byte)(header | 0x20);
                }
                this.currentBuffer.put(header);
                this.writeInt(arg.getArity());
                String name = fun.getName();
                byte[] nameBytes = name.getBytes();
                int length = nameBytes.length;
                this.writeInt(length);
                int endIndex = length;
                int remaining = this.currentBuffer.remaining();
                if (remaining < endIndex) {
                    endIndex = remaining;
                }
                this.currentBuffer.put(nameBytes, 0, endIndex);
                if (endIndex != length) {
                    this.indexInTerm = endIndex;
                    this.tempNameWriteBuffer = nameBytes;
                }
                this.applSignatures.put(fun, new Integer(this.sigKey++));
            } else {
                header = (byte)(header | 0x40);
                this.currentBuffer.put(header);
                this.writeInt(key);
            }
        } else {
            int length;
            int endIndex = length = this.tempNameWriteBuffer.length;
            int remaining = this.currentBuffer.remaining();
            if (this.indexInTerm + remaining < endIndex) {
                endIndex = this.indexInTerm + remaining;
            }
            this.currentBuffer.put(this.tempNameWriteBuffer, this.indexInTerm, endIndex - this.indexInTerm);
            this.indexInTerm = endIndex;
            if (this.indexInTerm == length) {
                this.indexInTerm = 0;
                this.tempNameWriteBuffer = null;
            }
        }
    }

    public void voidVisitBlob(ATermBlob arg) throws VisitFailure {
        int size = arg.getBlobSize();
        if (this.indexInTerm == 0) {
            this.currentBuffer.put(this.getHeader(arg));
            this.writeInt(size);
        }
        byte[] blobBytes = arg.getBlobData();
        int bytesToWrite = size - this.indexInTerm;
        int remaining = this.currentBuffer.remaining();
        if (remaining < bytesToWrite) {
            bytesToWrite = remaining;
        }
        this.currentBuffer.put(blobBytes, this.indexInTerm, bytesToWrite);
        this.indexInTerm += bytesToWrite;
        if (this.indexInTerm == size) {
            this.indexInTerm = 0;
        }
    }

    public void voidVisitInt(ATermInt arg) throws VisitFailure {
        this.currentBuffer.put(this.getHeader(arg));
        this.writeInt(arg.getInt());
    }

    public void voidVisitLong(ATermLong arg) throws VisitFailure {
        this.currentBuffer.put(this.getHeader(arg));
        this.writeLong(arg.getLong());
    }

    public void voidVisitList(ATermList arg) throws VisitFailure {
        byte header = this.getHeader(arg);
        this.currentBuffer.put(header);
        this.writeInt(arg.getLength());
    }

    public void voidVisitPlaceholder(ATermPlaceholder arg) throws VisitFailure {
        this.currentBuffer.put(this.getHeader(arg));
    }

    public void voidVisitReal(ATermReal arg) throws VisitFailure {
        this.currentBuffer.put(this.getHeader(arg));
        this.writeDouble(arg.getReal());
    }

    private void writeInt(int value) {
        int intValue = value;
        if ((intValue & 0xFFFFFF80) == 0) {
            this.currentBuffer.put((byte)(intValue & 0x7F));
            return;
        }
        this.currentBuffer.put((byte)(intValue & 0x7F | 0x80));
        if ((intValue & 0xFFFFC000) == 0) {
            this.currentBuffer.put((byte)(intValue >>> 7 & 0x7F));
            return;
        }
        this.currentBuffer.put((byte)(intValue >>> 7 & 0x7F | 0x80));
        if ((intValue & 0xFFE00000) == 0) {
            this.currentBuffer.put((byte)(intValue >>> 14 & 0x7F));
            return;
        }
        this.currentBuffer.put((byte)(intValue >>> 14 & 0x7F | 0x80));
        if ((intValue & 0xF0000000) == 0) {
            this.currentBuffer.put((byte)(intValue >>> 21 & 0x7F));
            return;
        }
        this.currentBuffer.put((byte)(intValue >>> 21 & 0x7F | 0x80));
        this.currentBuffer.put((byte)(intValue >>> 28 & 0x7F));
    }

    private void writeDouble(double value) {
        long longValue = Double.doubleToLongBits(value);
        this.writeLong(longValue);
    }

    private void writeLong(long value) {
        for (int i = 0; i < 8; ++i) {
            this.currentBuffer.put((byte)(value >>> i * 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTermToSAFFile(ATerm aTerm, File file) throws IOException, VisitFailure {
        BinaryWriter binaryWriter = new BinaryWriter(aTerm);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(2);
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fos = new FileOutputStream(file);
            fc = fos.getChannel();
            byteBuffer.put((byte)63);
            byteBuffer.flip();
            ((FileChannel)fc).write(byteBuffer);
            do {
                byteBuffer.clear();
                binaryWriter.serialize(byteBuffer);
                int blockSize = byteBuffer.limit();
                sizeBuffer.clear();
                sizeBuffer.put((byte)(blockSize & 0xFF));
                sizeBuffer.put((byte)(blockSize >>> 8 & 0xFF));
                sizeBuffer.flip();
                ((FileChannel)fc).write(sizeBuffer);
                ((FileChannel)fc).write(byteBuffer);
            } while (!binaryWriter.isFinished());
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static byte[] writeTermToSAFString(ATerm aTerm) throws VisitFailure {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int totalBytesWritten = 0;
        BinaryWriter binaryWriter = new BinaryWriter(aTerm);
        do {
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            binaryWriter.serialize(byteBuffer);
            buffers.add(byteBuffer);
            totalBytesWritten += byteBuffer.limit() + 2;
        } while (!binaryWriter.isFinished());
        byte[] data = new byte[totalBytesWritten];
        int position = 0;
        int numberOfBuffers = buffers.size();
        for (int i = 0; i < numberOfBuffers; ++i) {
            ByteBuffer buffer = (ByteBuffer)buffers.get(i);
            int blockSize = buffer.limit();
            data[position++] = (byte)(blockSize & 0xFF);
            data[position++] = (byte)(blockSize >>> 8 & 0xFF);
            System.arraycopy(buffer.array(), 0, data, position, blockSize);
            position += blockSize;
        }
        return data;
    }

    private static class ATermMapping {
        public ATerm term;
        public int subTermIndex = -1;
        public boolean annosDone = false;
        public ATermList nextPartOfList = null;

        private ATermMapping() {
        }
    }
}

