/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermList;
import aterm.Visitable;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import aterm.stream.BufferedOutputStreamWriter;
import java.io.IOException;
import jjtraveler.VisitFailure;
import shared.SharedObject;

public class AFunImpl
extends ATermImpl
implements AFun {
    private String name;
    private int arity;
    private boolean isQuoted;

    protected AFunImpl(PureFactory factory) {
        super(factory);
    }

    protected AFunImpl(PureFactory factory, String name, int arity, boolean isQuoted) {
        super(factory, null);
        this.name = name.intern();
        this.arity = arity;
        this.isQuoted = isQuoted;
        this.setHashCode(this.hashFunction());
    }

    protected void init(int hashCode, String name, int arity, boolean isQuoted) {
        super.init(hashCode, null);
        this.name = name.intern();
        this.arity = arity;
        this.isQuoted = isQuoted;
    }

    protected void initHashCode(String name, int arity, boolean isQuoted) {
        this.name = name.intern();
        this.arity = arity;
        this.isQuoted = isQuoted;
        this.setHashCode(this.hashFunction());
    }

    public SharedObject duplicate() {
        return this;
    }

    public boolean equivalent(SharedObject obj) {
        if (obj instanceof AFun) {
            AFun peer = (AFun)obj;
            return peer.getName().equals(this.name) && peer.getArity() == this.arity && peer.isQuoted() == this.isQuoted;
        }
        return false;
    }

    public int getType() {
        return 7;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public ATerm getAnnotation(ATerm key) {
        throw new UnsupportedOperationException();
    }

    public ATermList getAnnotations() {
        throw new UnsupportedOperationException();
    }

    public ATerm setAnnotations(ATermList annos) {
        throw new UnsupportedOperationException();
    }

    public int serialize(BufferedOutputStreamWriter writer) throws IOException {
        int bytesWritten = 0;
        if (this.isQuoted) {
            writer.write('\"');
            ++bytesWritten;
        }
        int numberOfCharacters = this.name.length();
        bytesWritten += numberOfCharacters;
        block11: for (int i = 0; i < numberOfCharacters; ++i) {
            char c = this.name.charAt(i);
            switch (c) {
                case '\n': {
                    writer.write('\\');
                    writer.write('n');
                    ++bytesWritten;
                    continue block11;
                }
                case '\t': {
                    writer.write('\\');
                    writer.write('t');
                    ++bytesWritten;
                    continue block11;
                }
                case '\b': {
                    writer.write('\\');
                    writer.write('b');
                    ++bytesWritten;
                    continue block11;
                }
                case '\r': {
                    writer.write('\\');
                    writer.write('r');
                    ++bytesWritten;
                    continue block11;
                }
                case '\f': {
                    writer.write('\\');
                    writer.write('f');
                    ++bytesWritten;
                    continue block11;
                }
                case '\\': {
                    writer.write('\\');
                    writer.write('\\');
                    ++bytesWritten;
                    continue block11;
                }
                case '\'': {
                    writer.write('\\');
                    writer.write('\'');
                    ++bytesWritten;
                    continue block11;
                }
                case '\"': {
                    writer.write('\\');
                    writer.write('\"');
                    ++bytesWritten;
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    writer.write(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        writer.write(c);
                        continue block11;
                    }
                    writer.write('\\');
                    writer.write(48 + c / 64);
                    c = (char)(c % 64);
                    writer.write(48 + c / 8);
                    c = (char)(c % 8);
                    writer.write(48 + c);
                    bytesWritten += 3;
                }
            }
        }
        if (this.isQuoted) {
            writer.write('\"');
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name.length());
        if (this.isQuoted) {
            result.append('\"');
        }
        block11: for (int i = 0; i < this.name.length(); ++i) {
            char c = this.name.charAt(i);
            switch (c) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block11;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block11;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    continue block11;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block11;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block11;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    continue block11;
                }
                case '\'': {
                    result.append('\\');
                    result.append('\'');
                    continue block11;
                }
                case '\"': {
                    result.append('\\');
                    result.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    result.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        result.append(c);
                        continue block11;
                    }
                    result.append('\\');
                    result.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    result.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    result.append((char)(48 + c));
                }
            }
        }
        if (this.isQuoted) {
            result.append('\"');
        }
        return result.toString();
    }

    public Visitable accept(Visitor v) throws VisitFailure {
        return v.visitAFun(this);
    }

    private int hashFunction() {
        int b = -1640531527;
        int a = -1640531527;
        int len = this.name.length();
        if (len >= 12) {
            return this.hashFunction2();
        }
        int c = this.isQuoted ? 7 * this.arity + 1 : this.arity + 1;
        c += len;
        switch (len) {
            case 11: {
                c += this.name.charAt(10) << 24;
            }
            case 10: {
                c += this.name.charAt(9) << 16;
            }
            case 9: {
                c += this.name.charAt(8) << 8;
            }
            case 8: {
                b += this.name.charAt(7) << 24;
            }
            case 7: {
                b += this.name.charAt(6) << 16;
            }
            case 6: {
                b += this.name.charAt(5) << 8;
            }
            case 5: {
                b += this.name.charAt(4);
            }
            case 4: {
                a += this.name.charAt(3) << 24;
            }
            case 3: {
                a += this.name.charAt(2) << 16;
            }
            case 2: {
                a += this.name.charAt(1) << 8;
            }
            case 1: {
                a += this.name.charAt(0);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }

    private int hashFunction2() {
        int len;
        int offset = 0;
        int count = this.name.length();
        char[] source = new char[count];
        offset = 0;
        this.name.getChars(0, count, source, 0);
        int b = -1640531527;
        int a = -1640531527;
        int c = this.isQuoted ? 7 * (this.arity + 1) : this.arity + 1;
        int k = offset;
        for (len = count; len >= 12; len -= 12) {
            a += source[k + 0] + (source[k + 1] << 8) + (source[k + 2] << 16) + (source[k + 3] << 24);
            a -= (b += source[k + 4] + (source[k + 5] << 8) + (source[k + 6] << 16) + (source[k + 7] << 24));
            a -= (c += source[k + 8] + (source[k + 9] << 8) + (source[k + 10] << 16) + (source[k + 11] << 24));
            b -= c;
            b -= (a ^= c >> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >> 13);
            b -= c;
            b -= (a ^= c >> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >> 5);
            b -= c;
            b -= (a ^= c >> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >> 15;
            k += 12;
        }
        c += count;
        switch (len) {
            case 11: {
                c += source[k + 10] << 24;
            }
            case 10: {
                c += source[k + 9] << 16;
            }
            case 9: {
                c += source[k + 8] << 8;
            }
            case 8: {
                b += source[k + 7] << 24;
            }
            case 7: {
                b += source[k + 6] << 16;
            }
            case 6: {
                b += source[k + 5] << 8;
            }
            case 5: {
                b += source[k + 4];
            }
            case 4: {
                a += source[k + 3] << 24;
            }
            case 3: {
                a += source[k + 2] << 16;
            }
            case 2: {
                a += source[k + 1] << 8;
            }
            case 1: {
                a += source[k + 0];
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

