/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.VersionInfo;
import pellet.PelletClassify;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletConsistency;
import pellet.PelletEntailment;
import pellet.PelletExceptionFormatter;
import pellet.PelletExplain;
import pellet.PelletExtractInferences;
import pellet.PelletInfo;
import pellet.PelletModularity;
import pellet.PelletQuery;
import pellet.PelletRealize;
import pellet.PelletTransTree;
import pellet.PelletUnsatisfiable;
import pellet.Pellint;

public class Pellet {
    public static final Logger logger = Logger.getLogger(Pellet.class.getName());
    public static final PelletExceptionFormatter exceptionFormatter = new PelletExceptionFormatter();
    private static final Map<String, PelletCmdApp> COMMANDS = new TreeMap<String, PelletCmdApp>();

    public static void main(String[] args) {
        Pellet app = new Pellet();
        try {
            app.run(args);
        }
        catch (PelletCmdException e) {
            Pellet.printError(e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.fine(sw.toString());
            logger.throwing(null, null, e);
            System.exit(1);
        }
    }

    private static void printError(Throwable e) {
        System.err.println(exceptionFormatter.formatException(e));
    }

    public static PelletCmdApp getCommand(String name) {
        PelletCmdApp cmd = COMMANDS.get(name.toLowerCase());
        if (cmd == null) {
            throw new PelletCmdException("Unrecognized subcommand: " + name);
        }
        return cmd;
    }

    private void run(String[] args) {
        if (args.length == 0) {
            throw new PelletCmdException("Type 'pellet help' for usage.");
        }
        String arg = args[0];
        if (arg.equals("h") || arg.equals("-h") || arg.equals("help") || arg.equals("--help")) {
            if (args.length == 1) {
                this.mainhelp();
            } else {
                PelletCmdApp cmd = Pellet.getCommand(args[1]);
                cmd.help();
            }
        } else if (arg.equals("--version") || arg.equals("-V")) {
            this.version();
        } else {
            PelletCmdApp cmd = Pellet.getCommand(arg);
            cmd.parseArgs(args);
            cmd.run();
            cmd.finish();
        }
    }

    private void mainhelp() {
        StringBuffer buf = new StringBuffer();
        String version = this.getVersionInfo().getVersionString();
        buf.append("Usage: pellet <subcommand> [options] <file URI>...\n");
        buf.append("Pellet command-line client, version " + version + ".\n");
        buf.append("Type 'pellet help <subcommand>' for help on a specific subcommand.\n");
        buf.append("\n");
        buf.append("Available subcommands:\n");
        for (String cmd : COMMANDS.keySet()) {
            buf.append("\t");
            buf.append(cmd);
            buf.append("\n");
        }
        buf.append("\n");
        buf.append("Pellet is an OWL ontology reasoner.\n");
        buf.append("For more information, see http://clarkparsia.com/pellet");
        System.out.println(buf);
        System.exit(0);
    }

    private VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    private void version() {
        System.out.println(this.getVersionInfo());
    }

    static {
        COMMANDS.put("classify", new PelletClassify());
        COMMANDS.put("consistency", new PelletConsistency());
        COMMANDS.put("realize", new PelletRealize());
        COMMANDS.put("unsat", new PelletUnsatisfiable());
        COMMANDS.put("explain", new PelletExplain());
        COMMANDS.put("query", new PelletQuery());
        COMMANDS.put("modularity", new PelletModularity());
        COMMANDS.put("trans-tree", new PelletTransTree());
        COMMANDS.put("extract", new PelletExtractInferences());
        COMMANDS.put("lint", new Pellint());
        COMMANDS.put("info", new PelletInfo());
        COMMANDS.put("entail", new PelletEntailment());
    }
}

